
stoShowDiary = function () {

    // Set Scene
    sto.wuiSetScene(pp.ScnUniverse, null, cc.TransitionFade, 2);

    //'年表表示
    sto.wuiShowBigMessage(pp.mediator.person.diary);
};


stoShowThankYou = function (personId) {

    // Thank You 表示
    sto.wuiShowThankYou(personId);

    pp.mediator.playSound(res.Snd_OK, null, true);

    // Set BGM
    pp.mediator.setBgm("");
};


stoEvePersonActivated = function (personId, aMessageIdx) {

    var person = pp.world.persons[personId];
    var messageIdx = cc.isUndefined(aMessageIdx) ? tm.irand(3) : aMessageIdx;

    sto.wuiSetFocusOnPlace(person.placeId);

    sto.wuiShowMessage(
        __(str.s739, person.fullName)
        //person.fullName + "が研究活動を開始しました。"
    );

    var messages = [ __(str.s740), __(str.s741), __(str.s742) ];

    /*
    var mes =
        tm.irand(3) == 0 ? "自然を知ることによって宇宙の真理に少しでも近づきたいものだな。" :
        tm.irand(2) == 0 ? "暗闇に閉ざされた自然哲学界に光明を見出すことが出来るのだろうか・・・。" :
                           "先人たちの素晴らしい仕事に劣らぬ優れた業績を上げて見せるぞ。";
    */

    sto.wuiShowVoice(person.id, null, messages[messageIdx], __(str.s743)); //"研究活動開始");

};

stoEvePersonRetired = function (personId, aMessageIdx) {

    var person = pp.world.persons[personId];
    var age = person.age;
    var messageIdx = cc.isUndefined(aMessageIdx) ? (age < 30 ? 0 : age < 50 ? 1 : 2) : aMessageIdx;

    var messages = [ __(str.s358), __(str.s359), __(str.s360) ];

    //age < 30 ? "自然の探求は私の天職ではなさそうだな。私には他にやることがある。" :
    //age < 50 ? "研究はもう充分やった。これからは他の分野で活躍していこう。" :
    //           "私ももう年だ。研究はもう充分やった。後は若い者に任せるとしよう。";

    sto.wuiShowVoice(person.id, null, messages[messageIdx]);

    //'*** 年表追加
    if (person.isManual) {
        person.addDiary(__(str.s361)); //"研究活動から引退。");
    }

    /*@@@
    person.state = pp.pcDead;
    pp.mediator.uiUpdatePlace(person.placeId);
    */
};


stoEvePersonDied = function (personId, aMessageIdx) {

    var person = pp.world.persons[personId];
    var messageIdx = cc.isUndefined(aMessageIdx) ? tm.irand(3) : aMessageIdx;

    pp.mediator.toShowMessageTemporary = true;

    var messages = [ __(str.s353), __(str.s354), __(str.s355) ];

    //"あの日、私は確かに宇宙の真理を垣間見た。それは疑いの無いこと・・・。" :
    // "私の人生が無駄ではなかった、と言うことになれば良いのだが・・・。" :
    //"あともう少しでたどり着けたはずなのだ。私の意思を継いでくれる者が現れるのを願うだけだ。";

    sto.wuiSetFocusOnPlace(person.placeId);

    sto.wuiShowVoice(person.id, null, messages[messageIdx]);

    sto.wuiShowMessage(
        __(str.s356, person.fullName));
    //person.fullName + "は科学者としてその生涯を閉じました。");

    pp.mediator.toShowMessageTemporary = false;

    //'*** 年表追加
    if (person.isManual) {
        var place = pp.world.places[person.placeId];
        person.addDiary(__(str.s357, place.name));
        //place.name + "でその生涯を閉じる。");
    }

    person.state = pp.pcDead;
    pp.mediator.uiUpdatePlace(person.placeId);
};
