

stoShowDiary = function () {

    // Set Scene
    sto.wuiSetScene(pp.ScnUniverse, null, cc.TransitionFade, 2);

    //'年表表示
    sto.wuiShowBigMessage(pp.mediator.person.diary);

    return;
};


stoShowThankYou = function () {

    // Set Scene
    sto.wuiSetScene(pp.ScnUniverse, null, cc.TransitionFade, 2);

    // Thank You 表示
    sto.wuiShowThankYou();

    pp.mediator.playSound(res.Snd_OK);

    // Set BGM
    pp.mediator.setBgm("");

    return;
};




stoEveChangeSocietyJobs = function (societyId) {

    var society = pp.world.societies[societyId];

    if (society.hasManualMember())
        pp.mediator.toShowMessageTemporary = true;


    //---------- SCENE SOCIETY ----------
    sto.wuiPushScene(pp.ScnSociety, societyId);
    sto.wuiShowCutS(res.Img_CutSociety);



    var orgJobPersonIds = [ society.job0PersonId, society.job1PersonId, society.job2PersonId];

    //'*** 現在の役職ﾃﾞｰﾀを破棄(g_Societyのみ。g_Personには残しておく)
    society.job0PersonId = pp.idInvalid;
    society.job1PersonId = pp.idInvalid;
    society.job2PersonId = pp.idInvalid;

    //'*** まずg_Societyを更新する
    //'役職毎に適任者を探す（名声の高い人物を選ぶ）
    for (var jIdx = 0; jIdx < pp.prJobNumASociety; jIdx++)
    {
        var maxFam = 0;
        var maxFamPID = pp.idInvalid;
        var jobFame =
            jIdx == 0 ? society.jobFame0 :
            jIdx == 1 ? society.jobFame1 : society.jobFame2;

        for (var i = 0; i < society.persons.length; i++)
        {
            var person = society.persons[i];

            //'必要名声値を超えているか
            if (person.fame < jobFame) continue;
            //'*** すでに上位の役職に就いているかどうか
            if (society.job0PersonId == person.id ||
                society.job1PersonId == person.id) continue;

            //'*** 上位の役職に就いていなかった
            //'候補者発見(対抗馬がいなければこの人物)
            if (person.fame > maxFam)
            {
                maxFam = person.fame;
                maxFamPID = person.id;
            }
        }

        //'候補者がいれば、その人物をg_Society()に書きこむ※g_Person()のほうはまだ書きこまない
        if (maxFam != pp.idInvalid)
        {
            jIdx == 0 ? (society.job0PersonId = maxFamPID) :
            jIdx == 1 ? (society.job1PersonId = maxFamPID) :
                        (society.job2PersonId = maxFamPID);
        }
    }

    //'*** ﾒｯｾｰｼﾞ表示しながらg_Personのほうも更新
    sto.wuiShowVoiceS(pp.PIDX_FACILI, "それでは本年度の" + society.name + "役員の選出を行いたいと思います。");

    var jIdx = 0;
For:
    var personId =jIdx == 0 ? society.job0PersonId :
                   jIdx == 1 ? society.job1PersonId : society.job2PersonId;

    if (personId == pp.idInvalid)
        goto("Continue");

    var person = pp.world.persons[personId];
    var jobName =
        jIdx == 0 ? society.jobName0 :
        jIdx == 1 ? society.jobName1 : society.jobName2;

    if (person.jobIdx == pp.idxInvalid || person.jobIdx > jIdx)
        goto("NewOrRankUp");
    else if (person.jobIdx == jIdx)
        goto("SameRank");
    else
        goto("RankDown");

NewOrRankUp:

    //'*** 新任 or ﾗﾝｸｱｯﾌﾟ
    sto.wuiShowVoiceS(pp.PIDX_FACILI, jobName + "にはこれまでの業績に敬意を表して" + person.fullName + "氏を選出したいと思います。");

    sto.wuiShowVoiceSById(person.id, "光栄の極みです。及ばずながら" + society.name + "の発展に尽力する所存です。");

    if (person.isManual == false)
        goto("NotManual");

Manual:

    var prevBgm = pp.mediator.setBgm(res.Mus_Congrats);

    sto.wuiShowMessageEx(person.fullName + "は" + society.name + "の" + jobName +"に選任されました！", res.Img_CutKnighted);

    //pp.mediator.setBgm(prevBgm);

    person.addDiary("その年の人事により" + society.name + "の" + jobName + "に就任。");
    goto("Step1Done");

NotManual:

    sto.wuiShowMessage(person.fullName + "は" + society.name + "の" + jobName + "に選任されました。");
    goto("Step1Done");

SameRank:

    //'*** 再選
    sto.wuiShowVoiceS(pp.PIDX_FACILI, jobName + "は昨年に引き続いて" + person.fullName + "氏を選出したいと思います。");

    sto.wuiShowVoiceSById(person.id, "ありがとうございます。");
    goto("Step1Done");

RankDown:

    //'*** ﾗﾝｸﾀﾞｳﾝ
    sto.wuiShowVoiceS(pp.PIDX_FACILI, person.fullName + "氏は本年から" + jobName + "の職についていただきます。");

    sto.wuiShowVoiceSById(person.id, "・・・・・・・・。");
    goto("Step1Done");

    sto.wuiShowMessage(person.fullName + "は" + society.name + "の" + jobName + "に選任されました。");

    //'年表追加
    if (person.isManual)
    {
        person.addDiary("その年の人事により" + society.name + "の" + jobName + "に降格。");
    }

    goto("Step1Done");

Step1Done:

    //'名声変化
    var up = society.authority / 3;
    if (person.jobIdx == pp.idxInvalid)
        up *= 3 - jIdx;
    else
        up *= person.jobIdx - jIdx;

    up = tm.int(up);

    if (up == 0)
        goto("FameNotChanged");

    sto.wuiShowParamChange("名声", person.fame, person.fame + up, person.fullName);

    person.fame += up;

FameNotChanged:
    //'再度判定ﾌﾟﾚｲﾔｰが会長に就任したかどうか判定
    if (person.isManual && person.jobIdx > 0 && jIdx == 0)
        goto("PlayerPromotedToPresident");

    goto("Step2Done");

PlayerPromotedToPresident:

    //'*** ﾌﾟﾚｲﾔｰ会長就任
    var ret = sto.wuiSelectOptions(["はい", "いいえ"], "会長就任を期に引退しますか？");
    if (ret == 1)
        goto("WontRetire");

    pp.mediator.personId = person.id;

    //'ｹﾞｰﾑｵｰﾊﾞｰ理由ｾｯﾄ
    pp.mediator.gameOverReason = pp.goRetired;

    //'次ｽﾃｰﾄは『ｴﾝﾃﾞｨﾝｸﾞ』
    pp.mediator.gameState = pp.gsEndGame;

    //'就任(g_Person更新)
    person.jobIdx = jIdx;

    sto.callStoryFunc(this.stoExeRetire, pp.goRetired);
    goto("Exit");

WontRetire:
    var ret = sto.wuiSelectOkCancel("引退せずに、このまま名声がどこまで上がるか挑戦します。");
    if (ret == pp.selCancel)
        goto("PlayerPromotedToPresident");

Step2Done:
    //'就任(g_Person更新)
    person.jobIdx = jIdx;

Continue:
    jIdx++;
    if (jIdx < pp.prJobNumASociety)
        goto("For");

ExitFor:


    //'役員からもれた人物検索
    var jIdx = 0;
For2:

    if (orgJobPersonIds[jIdx] == pp.idxInvalid)
        goto("Continue2");

    if (society.job0PersonId != orgJobPersonIds[jIdx] &&
        society.job1PersonId != orgJobPersonIds[jIdx] &&
        society.job2PersonId != orgJobPersonIds[jIdx])
        goto("NotSelected");

    goto("Continue2");

NotSelected:
    //'*** 落選
    var person = pp.world.persons[orgJobPersonIds[jIdx]];

    sto.wuiShowMessage(person.fullName + "は" + society.name + "の役員に選出されませんでした。");

    sto.wuiShowVoiceSById(person.id, "・・・・・・・・。");

    //'名声低下
    var up = society.authority / 3;
    up *= -3 + person.jobIdx;
    up = tm.int(up);

    sto.wuiShowParamChange("名声", person.fame, person.fame + up, person.fullName);

    person.fame += up;

    //'退任(g_Person更新)
    person.jobIdx = pp.idxInvalid;

    //'年表追加
    if (person.isManual)
    {
        person.addDiary("その年の人事により" + society.name + "の役員の座を追われる。");
    }

Continue2:
    jIdx++;
    if (jIdx < pp.prJobNumASociety)
        goto("For2");

ExitFor2:

Exit:

    //---------- SCENE SOCIETY ----------
    sto.wuiPopScene();

    pp.mediator.toShowMessageTemporary = false;

    return;

};







stoEveKnight = function (personId) {

    var person = pp.world.persons[personId];

    person.knightedSocietyId = person.societyId;

    pp.mediator.toShowMessageTemporary = true;

    pp.mediator.setBgm(res.Mus_Main, 2);

    //---------- SCENE SOCIETY ----------
    sto.wuiPushScene(pp.ScnSociety, person.societyId);

    //pp.mediator.uiUpdatePlace(person.placeId);
    //pp.mediator.uiBlinkPerson(person.id);

    var society = pp.world.societies[person.societyId];
    var monarch = pp.world.persons[society.monarchId];
    sto.wuiShowMessage(
        "その日、" + society.name + "には" + monarch.firstName + monarch.lastName + "の姿があった。" +
        "今やその名声が揺るぎないものとなった" + person.lastName + "を騎士（" + society.knightName + "）に叙任するためである。"
    );

    mes = [
        "@" + person.fullName + "よ。",

        "@そなたの自然哲学に対する貢献は計り知れぬ。" +
        "その卓越した功績を讃え、今日そなたを騎士に叙任しよう。\n" +
        "今後も" + society.nationName + "のために力を尽くすがよい。",

        "・・・光栄の極みです、国王陛下。",

        "今や自然哲学と技術の発展は国家の繁栄に欠かせないものとなりました。" +
        "微力ながら国王陛下と" + society.nationName + "のために一層尽力いたしましょう。"
    ];

    sto.wuiShowVoice([person.id, monarch.id], null, mes, "勲爵叙任");

    //'年表追加
    if (person.isManual)
    {
        person.addDiary(monarch.firstName + "より騎士（" + society.knightName + "）に叙任される。");
    }

    //'上昇値の元を計算
    var fup = 1000;

    pp.mediator.setBgm(res.Mus_Congrats);

    //'名声UP
    sto.wuiShowMessageEx(person.fullName + "は" + monarch.firstName + "より騎士に叙任されました！", res.Img_CutKnighted);

    sto.wuiShowParamChange("名声", person.fame, person.fame+fup, person.fullName);

    person.fame += fup;

    pp.mediator.uiUpdate();

    //'研究費授与
    var mup = 1000;
    mup = tm.imin(mup, pp.monMax - person.money);

    sto.wuiShowParamChange("資金", person.money, person.money+mup, person.fullName);
    person.money += mup;

    pp.mediator.uiUpdate();

    //'組織権威上昇
    var aup = tm.imin(fup / 10, 20);
    sto.wuiShowParamChange("権威", society.authority, society.authority+aup, society.name);
    society.authority += aup;

    //pp.mediator.uiBlinkPerson(pp.ID_INVALID);

    //---------- SCENE SOCIETY ----------
    sto.wuiPopScene();

    pp.mediator.toShowMessageTemporary = false;

    return;
};
