
stoComSystemOnDemo = function () {

    pp.mediator.toShowMessageTemporary = true;

    var ret = 0;

Select:
    var options = [];

    options.push(tm.buildOptionStr("messageSpeed"));
    options.push(tm.buildOptionStr("toShowCpuTurn"));
    options.push(tm.buildOptionStr("cpuBaseLevel"));
    if (pp.world.interestedPersonId == pp.idInvalid) {
        options.push(__("プレイヤーを選ぶ"));
    }
    else {
        options.push(__("操作を再開"));
    }
    options.push(__("ゲーム終了"));

    ret = sto.wuiSelectOptionsWithCancel(options, __("システム"), 3.5);

    if (ret == pp.selCancel)
        goto("Exit");

DidSelect:
    sto.callStoryFuncIf(ret == 0, this.stoComSelectTmdOptions, "messageSpeed");
    sto.callStoryFuncIf(ret == 1, this.stoComSelectToShowCpuTurn);
    sto.callStoryFuncIf(ret == 2, this.stoComSelectTmdOptions, "cpuBaseLevel");
    sto.callStoryFuncIf(ret == 3, this.stoComSelectPlayer);
    sto.callStoryFuncIf(ret == 4, this.stoComExitGame);

    if (pp.mediator.isDemo && pp.mediator.gameState != pp.gsTitle) {
        goto("Select");
    }

Exit:
    pp.mediator.toShowMessageTemporary = false;

    return false;
};


stoComSelectToShowCpuTurn = function () {

    var prevToShowCpuTurn = tmd.toShowCpuTurn;

Select:
    var ret = sto.callStoryFunc(this.stoComSelectTmdOptions, "toShowCpuTurn", true);

    if (!ret)
        return false;

    if (tmd.toShowCpuTurn != pp.ctCheckOne) {
        pp.world.interestedPersonId = pp.idInvalid;
    }

    if (pp.world.interestedPersonId != pp.idInvalid || tmd.toShowCpuTurn != pp.ctCheckOne) {
        goto("DidSelectInterestedPerson");
    }

SelectInterestedPerson:
    var personId = sto.wuiSelectPerson(__("人物"));

    if (personId == pp.selCancel) {
        tmd.toShowCpuTurn = prevToShowCpuTurn;
        tm.saveTmd();
        goto("Select");
    }
    pp.world.interestedPersonId = personId;

DidSelectInterestedPerson:

    var tmdName = "toShowCpuTurn";
    var setting = tm.system_settings[tmdName];

    var uiOptions = setting.options;
    var uiName = __(setting.caption);

    uiOptions = uiOptions.map(__1);

    sto.wuiShowMessage(__("{0} を {1} に設定しました。").format(uiName, uiOptions[tmd[tmdName]]));

    return true;
};


stoComOptionOnTitle = function () {

    var ret = 0;

Select:
    var options = [];

    options.push(tm.buildOptionStr("messageSpeed"));
    options.push(tm.buildOptionStr("toShowOpening"));
    options.push(tm.buildOptionStr("toShowTutorial"));
    options.push(tm.buildOptionStr("toShowCpuTurn"));
    options.push(tm.buildOptionStr("cpuBaseLevel"));
    options.push(__("図鑑"));
    options.push(__("音楽室"));
    options.push(__("データ初期化"));

    ret = sto.wuiSelectOptionsWithCancel(options, __("オプション"), 3);

    if (ret == pp.selCancel)
        goto("Exit");

    sto.callStoryFuncIf(ret == 0, this.stoComSelectTmdOptions, "messageSpeed");
    sto.callStoryFuncIf(ret == 1, this.stoComSelectTmdOptions, "toShowOpening");
    sto.callStoryFuncIf(ret == 2, this.stoComSelectTmdOptions, "toShowTutorial");
    sto.callStoryFuncIf(ret == 3, this.stoComSelectTmdOptions, "toShowCpuTurn", null, [1,0,1]);
    sto.callStoryFuncIf(ret == 4, this.stoComSelectTmdOptions, "cpuBaseLevel");
    sto.callStoryFuncIf(ret == 5, this.stoComLibrary);
    sto.callStoryFuncIf(ret == 6, this.stoComMusic);
    sto.callStoryFuncIf(ret == 7, this.stoComInitSystem);

Next:
    goto("Select");

Exit:
    return false;
};


stoAutoSave = function () {

    if (!pp.mediator.person) {
        var id;
        var persons = pp.world.persons;
        for (var i = 0; i < persons.length; i++) {
            id = pp.world.shuffledPersonIds[i];
            var person = persons[id];
            if (person.state == pp.pcActive) {
                break;
            }
        }
        pp.mediator.personId = id;

        cc.log("AUTOSAVE: Person to use = " + person.name);
    }

    sto.callStoryFunc(this.stoComSave, true);
};


stoComSave = function (isAuto) {

    var saveIdx;
    var dataName = pp.mediator.isDemo ?  pp.mediator.getDateString() : pp.getSaveDataName();

    if (isAuto) {
        saveIdx = tmd.savedDataNames.length-1;
        goto("DoSave");
    }

    var options = [];
    for (var i = 0; i < tmd.savedDataNames.length-1; i++)
        options.push("" + (i+1) + ": " + tmd.savedDataNames[i]);

Select:
    saveIdx = sto.wuiSelectOptionsWithCancel(options, __("セーブ"), tm.m(3.5, 4), null, null, tm.m(__(14, 12), null));

    if (saveIdx == pp.selCancel)
        goto("Cancelled");
    var selectedName = options[saveIdx];
    if (selectedName.substr(selectedName.length - pp.saveDataNameEmpty.length) == pp.saveDataNameEmpty)
        goto("NotOverwrite");

Overwrite:
    var ret = sto.wuiSelectOkCancel(__(str.s759, selectedName));
        //"" + (saveIdx+1) + ":『" + selectedName + "』のデータに上書きします。\nよろしいですか？");
    if (ret == pp.selCancel)
        goto("Select");
    goto("DoSave");

NotOverwrite:
    var ret = sto.wuiSelectOkCancel(__(str.s760, "" + (saveIdx+1) + ": " + dataName));
        //"" + (saveIdx+1) + ":『" + dataName + "』としてセーブします。\nよろしいですか？");
    if (ret == pp.selCancel)
        goto("Select");

DoSave:
    //*** Do Save
    tmd.savedDataNames[saveIdx] = dataName;
    tm.saveTmd();

    if (isAuto) {
        pp.doSaveGame(saveIdx);
        goto("Exit");
    }

    pp.mediator.person.preferredPage = pp.PG_MAP;

    pp.doSaveGame(saveIdx);

    pp.mediator.person.preferredPage = pp.PG_SYSTEM;

    sto.wuiShowMessage(__(str.s761, "" + (saveIdx+1) + ": " + dataName));
        //"" + (saveIdx+1) + ":『" + dataName + "』としてセーブしました。");

Exit:
    return true;

Cancelled:
    return false;
};


stoComLoad = function () {

    var options = [];
    for (var i = 0; i < tmd.savedDataNames.length - 1; i++)
        options.push("" + (i+1) + ": " + tmd.savedDataNames[i]);

    options.push("AUTO: " + tmd.savedDataNames[tmd.savedDataNames.length-1]);

Select:
    var saveIdx = sto.wuiSelectOptionsWithCancel(options, __("ロード"), tm.m(3.5, 4), null, null, tm.m(__(14, 12), null));
    if (saveIdx == pp.selCancel)
        goto("Cancelled");

    var selectedName = options[saveIdx];
    if (selectedName.substr(selectedName.length - pp.saveDataNameEmpty.length) == pp.saveDataNameEmpty)
        goto("NoData");

Confirm:
    var ret = sto.wuiSelectOkCancel(__(str.s762, selectedName));
        //"" + (saveIdx+1) + ":『" + selectedName + "』のデータを読み込みます。\nよろしいですか？");
    if (ret == pp.selCancel)
        goto("Select");
    goto("DoLoad");

NoData:
    sto.wuiShowMessage(__(str.s763)); //"データがありません。");
    goto("Select");

DoLoad:
    //*** Do Load
    pp.doLoadGame(saveIdx);

    if (pp.mediator.gameState != pp.gsTitle && pp.mediator.person.isManual == false) {
        pp.mediator.person.isManual = true;
        pp.mediator.toResetManualAfterThisTurn = true;
    }
    return true;

Cancelled:
    return false;
};

stoComExitGame = function () {

    var ret = sto.wuiSelectOkCancel(__(str.s771)); //"ゲームを終了してタイトルに戻ります。");

    if (ret != pp.selCancel) {
        pp.mediator.gameState = pp.gsTitle;
        return true;
    }

    return false;
};


stoComAutoMode = function () {

    var person = pp.mediator.person;

Confirm:
    var ret = sto.wuiSelectOkCancel(
        __(str.s1014) + CR +
        //"今の状態からデモモードへ移行します。" + CR +
        __(str.s289)); // よろしいですか？

    if (ret == pp.selCancel) {
        return false;
    }

    var ret = sto.wuiSelectOptionsWithCancel([
        __("全員見る"), __("今のプレイヤーだけ見る"), __("見ない") ], __(str.s752), 3); //"コンピューターのターンを見ますか？");
    if (ret == pp.selCancel) {
        goto("Confirm");
    }

    pp.mediator.toResetManualAfterThisTurn = true;
    tmd.toShowCpuTurn = pp.ctNoCheck;

    if (ret == 0) goto("CheckAll");
    if (ret == 1) goto ("CheckOne");
    goto ("NoCheck");

CheckAll:
    tmd.toShowCpuTurn = pp.ctCheckAll;
    goto("Exit");

CheckOne:
    pp.world.interestedPersonId = pp.mediator.person.id;
    goto("Exit");

NoCheck:
    goto("Exit");

Exit:
    tm.saveTmd();

    return true;
};



stoComMusic = function () {

    if (pp.mediator.bgmIdxForMusicRoom == pp.idxInvalid) {
        pp.mediator.bgmIdxForMusicRoom = 6;
        pp.mediator.setBgm("");
    }

Start:
    var options = [
        __(str.s772),
        __(str.s773),
        __(str.s774),
        __(str.s775),
        __(str.s776),
        __(str.s777),
        __("(停止)", "(Stop)")
    ];
        /*
        "曲1 タイトル画面",
        "曲2 メイン画面",
        "曲3 審査中",
        "曲4 アカデミー入会",
        "曲5 祝賀パーティー",
        "曲6 エンディング",
        "(停止)"
        */

    var musics = [
        res.Mus_Title,
        res.Mus_Main,
        res.Mus_Society,
        res.Mus_Congrats,
        res.Mus_Congrats2,
        res.Mus_Ending,
        ""
    ];

    var current = options[pp.mediator.bgmIdxForMusicRoom];

Select:
    var ret = sto.wuiSelectOptionsWithCancel(options, __(str.s778, current));
        //"音楽室 - [現在: " + current + "]");

    if (ret == pp.selCancel) {
        goto("Exit");
    }

    pp.mediator.bgmIdxForMusicRoom = ret;

    pp.mediator.setBgm(musics[ret]);
    current = options[ret];
    goto("Select");

Exit:

    return;
};

stoComDebugSetting = function () {

Start:
Select:
    var options = [];

    options.push(tm.buildOptionStr("researchBoost"));
    options.push(__(str.s780) + ": " + (tmd.debugPreselectedPersonId == pp.idInvalid ? __("なし") : pp.world.persons[tmd.debugPreselectedPersonId].name));
    //options.push("図鑑アンロック");
    options.push(__("テキストチェック"));

    var ret = sto.wuiSelectOptionsWithCancel(options, "Debug", 3.5);

    if (ret == pp.selCancel) {
        goto("Exit");
    }

    sto.callStoryFuncIf(ret == 0, this.stoComSelectTmdOptions, "researchBoost");

    if (ret == 1) {
        goto("ToSelectPerson");
    }
    if (ret == 2) {
        goto("CheckText");
    }
    /*
    if (ret == 3) {
        goto("UnlockLibrary");
    }
    */
    goto("Select");

    /*
UnlockLibrary:
    pp.unlockItemsForDebug();
    goto("Select");
    */

CheckText:
    var ret = sto.wuiSelectOkCancel("テキストチェックモードを開始します。よろしいですか？", pp.POP_FRM_FLAT_OK_CANCEL_BUTTONS);
    if (ret == pp.selCancel) {
        goto("Select");
    }
    pp.mediator.gameState = pp.gsStartGame;
    pp.mediator.isCheckingText = true;

    sto.loadDatabaseAndInitForCheck();

    goto("Exit");

ToSelectPerson:
    if (tmd.debugPreselectedPersonId == pp.ID_INVALID) {
        goto("CurrentIsToSelect");
    }
    else {
        goto("CurrentIsSelected");
    }

CurrentIsToSelect:
    var ret = sto.wuiSelectOkCancel(
        __(str.s784) + CR +
        //"現在、デフォルトのプレイヤーは「なし」です。" + CR +
        __(str.s785));
        // "変更しますか？");
    if (ret == pp.selCancel) {
        goto("Select");
    }

SelectPerson:
    var ret = sto.wuiSelectPerson(
        __(str.s786));
        //"デフォルトの科学者を選んでください");
    if (ret == pp.selCancel) {
        goto("Select");
    }
    tmd.debugPreselectedPersonId = ret;
    tm.saveTmd();

    var person = pp.world.persons[tmd.debugPreselectedPersonId];
    sto.wuiShowMessage(
        __(str.s787, person.name));
       // "デフォルトの科学者を「" + person.name + "」に設定しました。");

    goto("Select");


CurrentIsSelected:
    var person = pp.world.persons[tmd.debugPreselectedPersonId];
    var ret = sto.wuiSelectOkCancel(
        __(str.s788, person.name) + CR +
        __(str.s789));
        //"現在、デフォルトのプレイヤーは「" + person.name + "」です。\n" +
        //"解除しますか？");
    if (ret == pp.selCancel) {
        goto("Select");
    }
    tmd.debugPreselectedPersonId = pp.idInvalid;
    tm.saveTmd();

    sto.wuiShowMessage(
        __(str.s790)); //"デフォルトの科学者を「なし」に設定しました。");
    goto("Select");

Exit:
    return;
};

stoComInitSystem = function () {

    var ret = false;

    var sel = sto.wuiSelectOkCancel(
        __("全てのセーブデータ、図鑑データを消去します！") + "\n" +
        __("よろしいですか？"));

    if (sel == pp.selCancel)
        goto("Exit");

DoInitSystem:
    tm.initTmd();
    tm.saveTmd();
    sto.wuiShowMessage(__("全てのセーブデータ、図鑑データを消去しました。"));
    ret = true;

Exit:
    return ret;
};

stoComSelectTmdOptions = function (tmdName, skipChangedMessage, showns) {

    var changed = false;
    var setting = tm.system_settings[tmdName];

    var uiOptions = setting.options;
    var uiName = __(setting.caption);
    var currentVal = tmd[tmdName];
    var currentStr = __(uiOptions[currentVal]);

    uiOptions = uiOptions.map(__1);

    var ids = [];
    var uiOptionShowns = [];
    for (var i = 0; i < uiOptions.length; i++) {
        if (cc.isArray(showns) && !showns[i]) continue;

        ids.push(i);
        uiOptionShowns.push(uiOptions[i]);
    }

    var ret = sto.wuiSelectOptionsWithCancel(uiOptionShowns, uiName + ": " + currentStr);

    if (ret == pp.selCancel) {
        goto("Exit");
    }

    var id = ids[ret];

    if (id == currentVal)
        goto("Exit");

    tmd[tmdName] = id;
    tm.saveTmd();

    changed = true;

    if (skipChangedMessage)
        goto("Exit");

    sto.wuiShowMessage(__("{0} を {1} に設定しました。").format(uiName, uiOptions[id]));
    goto("Exit");

Exit:
    return changed;
};



stoComSelectPlayer = function () {

    var personId;

    if (pp.world.interestedPersonId != pp.idInvalid) {
        personId = pp.world.interestedPersonId;
        goto("Selected");
    }

Select:
    personId = sto.wuiSelectPerson(__("人物"));

    if (personId == pp.selCancel) {
        goto("Exit");
    }

Selected:
    var person = pp.world.persons[personId];
    var sel = sto.wuiSelectOkCancel(
            __(str.s1015, person.fullName) + CR +
            //person.fullName + "をプレイヤーにして続行します。" + CR +
            __(str.s289)); // よろしいですか？

    if (sel == pp.selCancel) {
        if (pp.world.interestedPersonId != pp.idInvalid)
            goto("Exit");
        else
            goto("Select");
    }

    person.isManual = true;
    person.preferredPage = pp.PG_MAP;
    pp.mediator.updateIsDemo();
    pp.world.interestedPersonId = pp.idInvalid;
    pp.mediator.uiUpdate();

Exit:
    return false;
};
