stoComCheckText = function () {

    var options = [
        "科学者登場",
        "科学者引退",
        "役員選出",
        "勲爵叙任",
        "エンディング",
        "スタッフロール",
        "最終画面"
    ];

    var functions = [
        this.stoCheck_PersonActivated,
        this.stoCheck_PersonRetired,
        this.stoCheck_ChangeSocietyJobs,
        this.stoCheck_Knighted,
        this.stoCheck_Ending,
        this.stoCheck_StaffRoll,
        this.stoCheck_ThankYou
    ];

Select:
    var ret = sto.wuiSelectOptionsWithCancel(options, null, 3.5, null, pp.POP_FRM_FLAT_CANCEL_BUTTON);
    if (ret == pp.selCancel)
        goto("Exit");

    sto.callStoryFunc(functions[ret]);

    goto("Select");

Exit:
    return false;
};


//----------------------------------------------------------------------


stoCheck_ChangeSocietyJobs = function () {

    sto.loadDatabaseAndInitForCheck();

    sto.callStoryFunc(this.stoCheck_ChangeSocietyJobs1);
    sto.callStoryFunc(this.stoCheck_ChangeSocietyJobs2);
};


stoCheck_ChangeSocietyJobs1 = function () {

    sto.wuiShowMessageFlat("役員選出１／２");

    // 全役員が新任に取って代わられるパターン
    var society = pp.world.societies[0];

    var boyle = pp.world.persons[pp.piBoyle];
    var barrow = pp.world.persons[pp.piBarrow];
    var hooke = pp.world.persons[pp.piHooke];
    var leibniz = pp.world.persons[pp.piLeibniz];

    boyle.fame = 800;
    barrow.fame = 500;
    hooke.fame = 400;
    leibniz.fame = 1000;
    leibniz.societyId = society.id;
    leibniz.jobIdx = pp.idxInvalid;

    society.job0PersonId = boyle.id;
    society.job1PersonId = barrow.id;
    society.job2PersonId = hooke.id;
    pp.world.persons[society.job0PersonId].jobIdx = 0;
    pp.world.persons[society.job1PersonId].jobIdx = 1;
    pp.world.persons[society.job2PersonId].jobIdx = 2;

    sto.callStoryFunc(this.stoEveChangeSocietyJobs, society.id);
};


stoCheck_ChangeSocietyJobs2 = function () {

    sto.wuiShowMessageFlat("役員選出２／２");

    // 全役員が留任
    var society = pp.world.societies[1];

    var picard = pp.world.persons[pp.piPicard];
    var cassini = pp.world.persons[pp.piCassini];
    var huygens = pp.world.persons[pp.piHuygens];
    var leibniz = pp.world.persons[pp.piLeibniz];

    picard.fame = 1000;
    cassini.fame = 800;
    huygens.fame = 400;
    leibniz.fame = 100;
    leibniz.societyId = society.id;
    leibniz.jobIdx = pp.idxInvalid;

    society.job0PersonId = picard.id;
    society.job1PersonId = cassini.id;
    society.job2PersonId = huygens.id;
    pp.world.persons[society.job0PersonId].jobIdx = 0;
    pp.world.persons[society.job1PersonId].jobIdx = 1;
    pp.world.persons[society.job2PersonId].jobIdx = 2;

    sto.callStoryFunc(this.stoEveChangeSocietyJobs, society.id);
};


//----------------------------------------------------------------------


stoCheck_PersonActivated = function () {

    sto.wuiShowMessageFlat("科学者登場１／３");

    sto.callStoryFunc(this.stoEvePersonActivated, pp.piBernoulliJa, 0);

    sto.wuiShowMessageFlat("科学者登場２／３");

    sto.callStoryFunc(this.stoEvePersonActivated, pp.piHalley, 1);

    sto.wuiShowMessageFlat("科学者登場３／３");

    sto.callStoryFunc(this.stoEvePersonActivated, pp.piNewton, 2);

};



stoCheck_PersonRetired = function () {

    sto.wuiShowMessageFlat("科学者引退１／６");
    sto.callStoryFunc(this.stoEvePersonRetired, pp.piBecher, 0);

    sto.wuiShowMessageFlat("科学者引退２／６");
    sto.callStoryFunc(this.stoEvePersonRetired, pp.piBoyle, 1);

    sto.wuiShowMessageFlat("科学者引退３／６");
    sto.callStoryFunc(this.stoEvePersonRetired, pp.piGuericke, 2);

    sto.wuiShowMessageFlat("科学者引退４／６");
    sto.callStoryFunc(this.stoEvePersonDied, pp.piHevelius, 0);

    sto.wuiShowMessageFlat("科学者引退５／６");
    sto.callStoryFunc(this.stoEvePersonDied, pp.piPicard, 1);

    sto.wuiShowMessageFlat("科学者引退６／６");
    sto.callStoryFunc(this.stoEvePersonDied, pp.piLeeuwenhoek, 2);

};


stoCheck_Knighted = function () {

    sto.loadDatabaseAndInitForCheck();

    sto.wuiShowMessageFlat("勲爵叙任１／２：（イギリス）");

    var person = pp.world.persons[pp.piBoyle];

    person.isManual = true;
    sto.callStoryFunc(this.stoEveKnight, pp.piBoyle);
    person.isManual = false;

    sto.wuiShowMessageFlat("勲爵叙任２／２：（フランス）");

    sto.callStoryFunc(this.stoEveKnight, pp.piPicard);

};


stoCheck_Ending = function () {

    sto.loadDatabaseAndInitForCheck();

    sto.callStoryFunc(this.stoCheck_Ending1);
    sto.callStoryFunc(this.stoCheck_Ending2);
    sto.callStoryFunc(this.stoCheck_Ending3);
    sto.callStoryFunc(this.stoCheck_Ending4);
    sto.callStoryFunc(this.stoCheck_Ending5);
};

stoCheck_Ending1 = function () {

    sto.wuiShowMessageFlat("エンディング１／５");

    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 3);

    //ニュートン、引退、無所属、名声=10、何も発見せず
    var person = pp.world.persons[pp.piNewton];

    person.fame = 10;

    pp.mediator.gameOverReason = pp.goRetired;
    sto.callStoryFunc(this.stoEveEnding, pp.piNewton);

    sto.wuiPopScene(cc.TransitionFade, 3);
};

stoCheck_Ending2 = function () {

    sto.wuiShowMessageFlat("エンディング２／５");

    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 3);

    //フック、死亡、ロンドン王立協会、役職２、名声=210、理論１、
    var person = pp.world.persons[pp.piHooke];

    person.fame = 210;

    pp.mediator.gameOverReason = pp.goDead;
    sto.callStoryFunc(this.stoEveEnding, pp.piHooke);

    sto.wuiPopScene(cc.TransitionFade, 3);
};


stoCheck_Ending3 = function () {

    sto.wuiShowMessageFlat("エンディング３／５");

    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 3);

    //ホイヘンス、死亡、パリ科学アカデミー、メンバー、名声=410、理論１、存在１
    var person = pp.world.persons[pp.piHuygens];
    person.fame = 410;

    pp.mediator.gameOverReason = pp.goDead;
    sto.callStoryFunc(this.stoEveEnding, pp.piHuygens);

    sto.wuiPopScene(cc.TransitionFade, 3);
};


stoCheck_Ending4 = function () {

    sto.wuiShowMessageFlat("エンディング４／５");

    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 3);

    //ゲーリケ、引退、ロンドン王立協会、役職２、名声=610、発明１、スケッチ１
    var person = pp.world.persons[pp.piGuericke];
    person.fame = 610;
    person.societyId = 0;
    person.jobIdx = 1;

    //発見追加
    pp.world.reports.push(new pp.PrReport(pp.piGuericke, pp.diAirTemprature, 0));
    pp.world.reports.push(new pp.PrReport(pp.piGuericke, pp.diSkin, 0));

    pp.mediator.gameOverReason = pp.goRetired;
    sto.callStoryFunc(this.stoEveEnding, pp.piGuericke);

    sto.wuiPopScene(cc.TransitionFade, 3);
};


stoCheck_Ending5 = function () {

    sto.wuiShowMessageFlat("エンディング５／５");

    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 3);

    //ベッヒャー、出版、パリ科学アカデミー、会長、名声=1100、発明１、理論１、存在１
    var person = pp.world.persons[pp.piBecher];
    person.fame = 1100;
    person.societyId = 1;
    person.jobIdx = 0;

    //発見追加
    pp.world.reports.push(new pp.PrReport(pp.piBecher, pp.diAirTemprature, 0));
    pp.world.reports.push(new pp.PrReport(pp.piBecher, pp.diSkin, 0));
    pp.world.reports.push(new pp.PrReport(pp.piBecher, pp.diPendulumPlain, 0));
    pp.world.reports.push(new pp.PrReport(pp.piBecher, pp.diDione, 0));

    pp.mediator.gameOverReason = pp.goClear;
    sto.callStoryFunc(this.stoEveEnding, pp.piBecher);

    sto.wuiPopScene(cc.TransitionFade, 3);
};


stoCheck_StaffRoll = function () {

    sto.wuiShowMessageFlat("スタッフロール");

    sto.wuiPushScene(pp.ScnUniverse, null, cc.TransitionFade, 3);

    sto.callStoryFunc(this.stoEveStaffRoll);

    sto.wuiPopScene(cc.TransitionFade, 3);
};

stoCheck_ThankYou = function () {

    sto.wuiShowMessageFlat("最終画面");

    sto.callStoryFunc(this.stoShowThankYou, pp.piNewton);
};


//----------------------------------------------------------------------


stoCheck_ComData = function (themeIdx) {
    sto.callStoryFunc(this.stoExeResearchData, themeIdx, 0);
    sto.callStoryFunc(this.stoExeResearchData, themeIdx, 1);
    sto.callStoryFunc(this.stoExeResearchData, themeIdx, 2);
};

stoCheck_ComDeduce = function (themeIdx) {
    sto.callStoryFunc(this.stoExeResearchDeduce, themeIdx, 0);
    sto.callStoryFunc(this.stoExeResearchDeduce, themeIdx, 1);
    sto.callStoryFunc(this.stoExeResearchDeduce, themeIdx, 2);
};

stoCheck_ComDiscovery = function (discId) {
    sto.callStoryFunc(this.stoDiscover, discId);
};

stoCheck_ComTheory = function (discId) {
    sto.callStoryFunc(this.stoExeVerifyTheory, discId, 0);
    sto.callStoryFunc(this.stoExeVerifyTheory, discId, 1);
    sto.callStoryFunc(this.stoExeVerifyTheory, discId, 2);
    sto.callStoryFunc(this.stoExeVerifyTheory, discId, 3);
    sto.callStoryFunc(this.stoExeVerifyTheory, discId, 4);
    sto.callStoryFunc(this.stoExeVerifyTheory, discId, 5);
    sto.callStoryFunc(this.stoExeVerifyTheory, discId, 6);
};

stoCheck_ComItem = function (discId) {
    sto.callStoryFunc(this.stoExeMakeTrial, discId, 0);
    sto.callStoryFunc(this.stoExeMakeTrial, discId, 1);
    sto.callStoryFunc(this.stoExeMakeTrial, discId, 2);
    sto.callStoryFunc(this.stoExeMakeTrial, discId, 3);
    sto.callStoryFunc(this.stoExeMakeTrial, discId, 4);
    sto.callStoryFunc(this.stoExeMakeTrial, discId, 5);
};

stoCheck_ComDrawFigure = function (discId) {
    sto.callStoryFunc(this.stoExeDrawFigure, discId, 0);
    sto.callStoryFunc(this.stoExeDrawFigure, discId, 30);
    sto.callStoryFunc(this.stoExeDrawFigure, discId, 50);
    sto.callStoryFunc(this.stoExeDrawFigure, discId, 70);
    sto.callStoryFunc(this.stoExeDrawFigure, discId, 90);
};

stoCheck_ComWriteReport = function (discId) {

    var disc = pp.world.discoveries[discId];

    sto.callStoryFunc(this.stoExeWriteReport, discId, 0);

    if (disc.type != pp.ttTheory)
        return;

    sto.callStoryFunc(this.stoExeWriteReport, discId, 1);
    sto.callStoryFunc(this.stoExeWriteReport, discId, 2);
    sto.callStoryFunc(this.stoExeWriteReport, discId, 3);
};

stoCheck_ComRewriteReport = function (reportId) {

    var disc = pp.world.discoveries[reportId];

    sto.callStoryFunc(this.stoExeRewriteReport, reportId, 0);

    if (disc.type != pp.ttTheory)
        return;

    sto.callStoryFunc(this.stoExeRewriteReport, reportId, 1);
    sto.callStoryFunc(this.stoExeRewriteReport, reportId, 2);
    sto.callStoryFunc(this.stoExeRewriteReport, reportId, 3);
};

stoCheck_ComLecture = function (fieldId) {
    sto.callStoryFunc(this.stoExeLecture, fieldId, 0);
    sto.callStoryFunc(this.stoExeLecture, fieldId, 10);
    sto.callStoryFunc(this.stoExeLecture, fieldId, 30);
    sto.callStoryFunc(this.stoExeLecture, fieldId, 50);
    sto.callStoryFunc(this.stoExeLecture, fieldId, 100);
};

stoCheck_ComReadBook = function (fieldId) {
    sto.callStoryFunc(this.stoExeReadBook, fieldId, 0);
    sto.callStoryFunc(this.stoExeReadBook, fieldId, 10);
    sto.callStoryFunc(this.stoExeReadBook, fieldId, 30);
    sto.callStoryFunc(this.stoExeReadBook, fieldId, 50);
    sto.callStoryFunc(this.stoExeReadBook, fieldId, 100);
};

stoCheck_ComTrain = function (fieldId) {
    sto.callStoryFunc(this.stoExeTrain, fieldId, 0);
    sto.callStoryFunc(this.stoExeTrain, fieldId, 10);
    sto.callStoryFunc(this.stoExeTrain, fieldId, 30);
    sto.callStoryFunc(this.stoExeTrain, fieldId, 50);
    sto.callStoryFunc(this.stoExeTrain, fieldId, 100);
};

stoCheck_ComSubmitReport = function (reportId) {

    var society = pp.world.societies[0];

    var boyle = pp.world.persons[pp.piBoyle];
    var barrow = pp.world.persons[pp.piBarrow];
    var hooke = pp.world.persons[pp.piHooke];

    boyle.societyId = society.id; boyle.jobIdx = 0;
    barrow.societyId = society.id; barrow.jobIdx = 1;
    hooke.societyId = society.id; hooke.jobIdx = 2;

    society.job0PersonId = boyle.id;
    society.job1PersonId = barrow.id;
    society.job2PersonId = hooke.id;

    // パターン１

    var report = pp.world.reports[reportId];
    var disc = pp.world.discoveries[report.discoveryId];

    if (disc.type == pp.ttBook)
        goto("Book");

Theory:
Thing:
Item:
Figure:
    // 評価：低、低、低
    sto.callStoryFunc(this.stoExeSubmitReport, reportId, society.id, [1, 1, 1]);

    // 評価：最低、最低、高
    sto.callStoryFunc(this.stoExeSubmitReport, reportId, society.id, [0, 0, 3]);

    // 評価：高、高、最低
    sto.callStoryFunc(this.stoExeSubmitReport, reportId, society.id, [3, 3, 0]);

    // 評価：最高、最高、最高
    sto.callStoryFunc(this.stoExeSubmitReport, reportId, society.id, [4, 4, 4]);

    // 自分の論文

    // すでにある論文
    goto("Exit");

Book:
    sto.callStoryFunc(this.stoExeSubmitReport, reportId, society.id, [0, 0, 0]);

Exit:
    return;
};

stoCheck_ComDonate = function (toPersonId) {

    sto.callStoryFunc(this.stoExeDonate, toPersonId, 0, true);
    sto.callStoryFunc(this.stoExeDonate, toPersonId, 40, true);
    sto.callStoryFunc(this.stoExeDonate, toPersonId, 70, true);

    sto.callStoryFunc(this.stoExeDonate, toPersonId, 0, false);
    sto.callStoryFunc(this.stoExeDonate, toPersonId, 40, false);

};

stoCheck_ComAbuse = function (toPersonId) {

    sto.callStoryFunc(this.stoExeAbuse, toPersonId, 0);
    sto.callStoryFunc(this.stoExeAbuse, toPersonId, 40);
    sto.callStoryFunc(this.stoExeAbuse, toPersonId, 70);

};

stoCheck_ComCommunicate = function (withPersonId) {

    sto.callStoryFunc(this.stoExeCommunicate, withPersonId, 0, 0);
    sto.callStoryFunc(this.stoExeCommunicate, withPersonId, 0, 400);
    sto.callStoryFunc(this.stoExeCommunicate, withPersonId, 0, 500);

    sto.callStoryFunc(this.stoExeCommunicate, withPersonId, 60, 0);
    sto.callStoryFunc(this.stoExeCommunicate, withPersonId, 60, 400);
    sto.callStoryFunc(this.stoExeCommunicate, withPersonId, 60, 500);

};

stoCheck_ComClaimReport = function (reportId) {

    /*
    var society = pp.world.societies[0];

    var boyle = pp.world.persons[pp.piBoyle];
    var barrow = pp.world.persons[pp.piBarrow];
    var hooke = pp.world.persons[pp.piHooke];

    boyle.societyId = society.id; boyle.jobIdx = 0;
    barrow.societyId = society.id; barrow.jobIdx = 1;
    hooke.societyId = society.id; hooke.jobIdx = 2;

    society.job0PersonId = boyle.id;
    society.job1PersonId = barrow.id;
    society.job2PersonId = hooke.id;
    */

    // 評価：低、低、高
    sto.callStoryFunc(this.stoExeClaimReport, reportId, [0, 0, 2]);

    // 評価：高、高、低
    sto.callStoryFunc(this.stoExeClaimReport, reportId, [4, 4, 1]);

    // 自分の論文

};

stoCheck_ComJoinSociety = function (societyId) {

    sto.callStoryFunc(this.stoExeJoinSociety, societyId, [1, 1, 1]);
    sto.callStoryFunc(this.stoExeJoinSociety, societyId, [0, 0, 3]);
    sto.callStoryFunc(this.stoExeJoinSociety, societyId, [3, 3, 0]);
    sto.callStoryFunc(this.stoExeJoinSociety, societyId, [4, 4, 4]);

};

