
pp.Frm = cc.Layer.extend({

    content: null,
    s9spr: null,
    lyrShadow: null,

    ctor: function (backImageOrFrameType, content, marginX, marginY, caption) {

        this._super();

        content = content || new cc.Sprite();

        var frameType;
        var image;
        if (cc.isString(backImageOrFrameType)) {
            image = backImageOrFrameType;
        }
        else {
            frameType = backImageOrFrameType;
            if (frameType == pp.POP_FRM_NO_BUTTONS) {
                image = res.Img_FrmWithoutButton;
                marginX = 40;
                marginY = 30;
            }
            else {
                image = res.Img_FrmSimple256x256;
                marginX = 20;
                marginY = 20;
            }
        }
        marginX = cc.isUndefined(marginX) ? 0 : marginX;
        marginY = cc.isUndefined(marginY) ? 0 : marginY;

        var s9spr = new tm.Scale9SpriteTiled(image);
        s9spr.attr({
            ignoreAnchor: true
        });

        if (image == res.ImgM_FrmWithButton) {
            s9spr.setCapInsets(cc.rect(Math.floor(s9spr.width / 3), Math.floor(s9spr.height / 6), Math.floor(s9spr.width / 3), Math.floor(s9spr.height / 3)));
        }

        var width = content.width;
        var height = content.height;

        var sprCaption;

        if (caption) {

            var lbl = new cc.LabelTTF(caption, pp.font, __(18, 16));
            lbl.setFontFillColor(cc.color.BLACK);
            lbl.textAlign = cc.TEXT_ALIGNMENT_CENTER;

            sprCaption = new cc.Scale9Sprite(res.Img_LyrCaptionPaper);

            var contentWidth = tm.imax(lbl.width, 60) + 80;

            sprCaption.setContentSize(contentWidth + 80, 40);
            sprCaption.attr({
                ignoreAnchor: false,
                anchorX: 0.5,
                anchorY: 1
            });

            sprCaption.addChild(lbl);
            lbl.x = sprCaption.width / 2;
            lbl.y = 20 + tm.p(0,4, 0);

            s9spr.addChild(sprCaption);

            height = height + sprCaption.height + 20;
            width = tm.imax(width, sprCaption.width);
        }

        width += marginX * 2;
        height += marginY * 2;

        s9spr.addChild(content);

        var lyrShadow = new cc.LayerColor(cc.color(0, 0, 0, 96));
        lyrShadow.attr({
            x: 10,
            y: -10
        });

        if (caption) {
            sprCaption.attr({
                x: width/2,
                y: height-marginY
            });
        }
        content.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 0,
            x: width/2 - content.width/2,
            y: marginY
        });

        this.addChild(s9spr, -1);
        this.addChild(lyrShadow, -2);

        this.content = content;
        this.lyrShadow = lyrShadow;
        this.s9spr = s9spr;

        this.setContentSize(width, height);
    },

    setContentSize: function (width, height) {

        this._super(width, height);

        this.s9spr.setContentSize(width, height);
        this.lyrShadow.setContentSize(width, height);
    }
});
