
pp.FH_HIDE_TO_TOP = 1;
pp.FH_HIDE_TO_BOTTOM = 2;
pp.FH_HIDE_TO_LEFT = 3;
pp.FH_HIDE_TO_RIGHT = 4;

pp.FrmHidable = pp.Frm.extend({

    shownPos: null,
    hiddenPos: null,
    isShown: true,
    menuS: null,
    align: 0,
    hideTo: 0,
    posDiff: null,

    touchPosBegan: null,

    ctor: function (image, align, hideTo, posDiff, noSwallow) {

        this._super(image);

        this.align = align = align || pp.ALIGN_NONE;
        this.hideTo = hideTo = hideTo || pp.FH_HIDE_TO_RIGHT;
        this.posDiff = posDiff || cc.p(0,0);

        this.attr({
            ignoreAnchor: false
        });

        var menuS;
        var menuRotate;
        switch (this.hideTo) {
            case pp.FH_HIDE_TO_TOP:    menuRotate = 0; break;
            case pp.FH_HIDE_TO_RIGHT:  menuRotate = 90; break;
            case pp.FH_HIDE_TO_BOTTOM: menuRotate = 180; break;
            case pp.FH_HIDE_TO_LEFT:   menuRotate = 270; break;
        }
        menuS = new pp.MenuSmall(["▲"], this.didClickSmall, this, [menuRotate], true);
        menuS.attr({ x: 16, y: this.height - menuS.height - 8 });
        this.addChild(menuS, 1);

        this.menuS = menuS;

        this.isShown = true;

        // Swallow touches
        if (!noSwallow)
        {
            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: true,
                    onTouchBegan: function (touch, event) {
                        var node = event.getCurrentTarget();
                        return tm.isInside(tm.getTouchPos(touch), node);
                    },
                    onTouchMoved: function () { return false; },
                    onTouchCancelled: function () { return false; },
                    onTouchEnded: function () { return false; }
                }),
                this
            );
        }

    },

    onDidSetSizeAndParent: function () {

        var parent = this.getParent();

        var roomLeft = 0;
        var roomTop = tm.m(pp.LYR_STATUS_BAR_HEIGHT, 0);
        var roomRight = 0;
        var roomBottom = 0;

        switch (this.align) {
            case pp.ALIGN_TOP_RIGHT:
                this.attr({
                    anchorX: 1,
                    anchorY: 1,
                    x: parent.width - roomRight + this.posDiff.x,
                    y: parent.height - roomTop + this.posDiff.y
                });
                break;
            case pp.ALIGN_TOP_LEFT:
                this.attr({
                    anchorX: 0,
                    anchorY: 1,
                    x: roomLeft + this.posDiff.x,
                    y: parent.height - roomTop + this.posDiff.y
                });
                break;
            case pp.ALIGN_BOTTOM_RIGHT:
                this.attr({
                    anchorX: 1,
                    anchorY: 0,
                    x: parent.width - roomRight - 1 + this.posDiff.x,
                    y: roomBottom + this.posDiff.y
                });
                break;
            case pp.ALIGN_BOTTOM_LEFT:
                this.attr({
                    anchorX: 0,
                    anchorY: 0,
                    x: roomLeft + this.posDiff.x,
                    y: roomBottom + this.posDiff.y
                });
                break;
        }

        this.savePos();
    },

    savePos: function () {

        var marginWidth = 40;
        var marginHeight = 40;

        this.shownPos = cc.p(this.x, this.y);

        switch (this.hideTo) {
            case pp.FH_HIDE_TO_BOTTOM:
                this.hiddenPos = cc.p(this.x, marginHeight);
                break;
            case pp.FH_HIDE_TO_TOP:
                this.hiddenPos = cc.p(this.x, this.y + (this.height - marginHeight));
                break;
            case pp.FH_HIDE_TO_LEFT:
                this.hiddenPos = cc.p(this.x - (this.width - marginWidth), this.y);
                break;
            case pp.FH_HIDE_TO_RIGHT:
                this.hiddenPos = cc.p(this.x + (this.width - marginWidth), this.y);
                break;
        }
    },

    hide: function (animated) {

        if (animated) {

            this.stopAllActions();

            this.x = this.shownPos.x;
            this.y = this.shownPos.y;

            this.runAction(
                cc.moveTo(0.2, this.hiddenPos)
            );
        }
        else {

            this.x = this.hiddenPos.x;
            this.y = this.hiddenPos.y;
        }

        this.isShown = false;

        if (this.hideTo == pp.FH_HIDE_TO_LEFT || this.hideTo == pp.FH_HIDE_TO_RIGHT) {
            this.menuS.items[0].scaleX = -1;
        }
        else {
            this.menuS.items[0].scaleY = -1;
        }
    },

    show: function (animated) {

        if (animated) {

            this.stopAllActions();

            this.x = this.hiddenPos.x;
            this.y = this.hiddenPos.y;

            this.runAction(
                cc.moveTo(0.2, this.shownPos)
            );
        }
        else {
            this.x = this.shownPos.x;
            this.y = this.shownPos.y;
        }

        this.isShown = true;

        if (this.hideTo == pp.FH_HIDE_TO_LEFT || this.hideTo == pp.FH_HIDE_TO_RIGHT) {
            this.menuS.items[0].scaleX = 1;
        }
        else {
            this.menuS.items[0].scaleY = 1;
        }
    },

    didClickSmall: function (item) {
        //cc.log("CLICK");
        pp.mediator.playSound(res.Snd_Click);

        if (this.isShown) {
            this.hide(true);
        }
        else {
            this.show(true);
        }
    }

});
