
pp.FL_MAX_LOG_LEN = 6;

pp.FrmLog = pp.FrmHidable.extend({

    scrView: null,
    scrContent: null,

    lblMonthlyLogs: null,

    ctor: function () {

        this._super(res.Img_FrmDate, pp.ALIGN_BOTTOM_LEFT, pp.FH_HIDE_TO_LEFT, tm.m(cc.p(0, 120), cc.p(0, 0)));

        this._name = "FrmLog";

        this.setContentSize(tm.m(cc.winSize.width, 501), tm.m(300, 200));

        this.menuS.attr({
            ignoreAnchor: false,
            anchorX: 1,
            anchorY: 1,
            x: this.width - tm.m(2, 8),
            y: this.height - tm.m(18, 8)
        });

        //--------

        var scrContent = new tm.Scale9SpriteTiled(res.Img_LyrDetailImage);
        this.scrContent = scrContent;
        scrContent.setContentSize(this.width - 64, this.height - 70); //@@@

        var scrView = this.scrView = new pp.ScrollView();
        scrView.direction = cc.SCROLLVIEW_DIRECTION_VERTICAL;

        scrView.setContainer(scrContent);
        scrView.setViewSize(cc.size(this.width - 64, this.height - 40));

        scrView.attr({
            ignoreAnchor: false,
            x: this.width / 2-1,
            y: this.height / 2+1
        });
        this.addChild(scrView);

        this.lblMonthlyLogs = [];
    },

    uiUpdate: function () {

        var TOP_MARGIN = 20;

        var scrContent = this.scrContent;
        var lblMonthlyLogs = this.lblMonthlyLogs;
        var minHeight = this.height - 70;
        var heightLabels = TOP_MARGIN;

        for (var i = 0; i < lblMonthlyLogs.length; i++) {
            var lblMonthlyLog = lblMonthlyLogs[i];
            heightLabels += lblMonthlyLog.height + 20;
        }
        scrContent.setContentSize(this.width - 64, tm.imax(minHeight, heightLabels));

        var y = heightLabels - TOP_MARGIN;
        for (var i = 0; i < lblMonthlyLogs.length; i++) {
            var lblMonthlyLog = lblMonthlyLogs[i];

            lblMonthlyLog.y = y;
            y -= lblMonthlyLog.height + 20;
        }
    },

    startMonth: function (mes) {
        //cc.log("startMonth: mes=" + mes);

        var lbl = new cc.LabelTTF(mes, pp.font, tm.m(21, 14));
        lbl.attr({
            x: 16,
            y: lbl.height + 16,
            anchorX: 0,
            anchorY: 1,
            textAlign: cc.TEXT_ALIGNMENT_LEFT
        });
        lbl.setFontFillColor(cc.color.BLACK);
        lbl.setDimensions(cc.size(this.scrView.getContainer().width - lbl.x * 2, 0)); //@@@
        this.scrView.addChild(lbl);

        var lblMonthlyLogs = this.lblMonthlyLogs;
        lblMonthlyLogs.push(lbl);
        while (lblMonthlyLogs.length > pp.FL_MAX_LOG_LEN) {
            var oldestLog = lblMonthlyLogs.shift();
            oldestLog.removeFromParent();
        }

        this.uiUpdate();
    },

    add: function (mes, skipRemoveTemp) {
        //cc.log("add: mes=" + mes);

        //mes = tm.insertNewLines(mes, 32);

        if (!skipRemoveTemp) {
            this.removeTemp();
        }

        var lblMonthlyLogs = this.lblMonthlyLogs;

        if (lblMonthlyLogs.length == 0) {
            this.startMonth(mes);
            return;
        }

        var lblCurrent = lblMonthlyLogs[lblMonthlyLogs.length-1];

        lblCurrent.string += "\n" + mes;

        this.uiUpdate();
    },

    addTemp: function (mes) {
        this.add(mes + "   ", true);
    },

    removeTemp: function () {
        if (this.lblMonthlyLogs.length == 0)
            return;

        var lblCurrent = this.lblMonthlyLogs[this.lblMonthlyLogs.length-1];
        var str = lblCurrent.string;
        lblCurrent.string = str.replace(/\n.*   $/, "");
    }

});
