
pp.SPR_PLACE_DY = 55;

pp.SprPlace = cc.Sprite.extend({

    placeId: 0,
    itmFaces: null,
    itmFacilities: null,
    itmPlaceLabel: null,
    itmPlaceLabel2: null,
    menu: null,
    callback: null,
    target: null,

    ctor: function (placeId, callback, target) {

        this._super();

        this._name = "SprPlace";

        this.placeId = placeId;
        this.callback = callback;
        this.target = target;

        var menu = this.menu = new cc.Menu();
        menu.ignoreAnchor = false;
        this.addChild(menu, 1);

        var place = pp.world.places[placeId];

        this.attr({
            x: place.longitude,
            y: pp.world.mapImageHeight - place.latitude
        });

        var dy = 0;
        if (place.infoPos == 1) {
            dy = 44;
        }

        var lbl = new tm.LabelTTF(place.name, pp.font, 20, cc.color.BLACK, cc.color.WHITE);
        var lbl2 = new tm.LabelTTF(place.name, pp.font, 20, cc.color.BLACK, cc.color.WHITE);
        lbl2.attr({ anchorX: 0.5, x: 2, y: -2 });
        var itm = new cc.MenuItemSprite(lbl, lbl2, callback, target);
        itm.attr({
            anchorX: 0,
            x: -10,
            y: place.infoPos == 1 ? 20 : -24
        });
        itm.tag = pp.cmPlaceOffset + placeId;
        menu.addChild(itm);
        this.itmPlaceLabel = itm;

        if (tm.m()) {
            var lbl = new tm.LabelTTF(place.name, pp.font, 10, cc.color.BLACK, cc.color.WHITE);
            var lbl2 = new tm.LabelTTF(place.name, pp.font, 10, cc.color.BLACK, cc.color.WHITE);
            lbl2.attr({anchorX: 0.5, x: 2, y: -2});
            var itm = new cc.MenuItemSprite(lbl, lbl2, callback, target);
            itm.attr({
                anchorX: place.infoPosX == 0 ? 1 : 0,
                x: place.infoPosX == 0 ? -10 : 10,
                y: 0
            });
            itm.tag = pp.cmPlaceOffset + placeId;
            menu.addChild(itm);
            this.itmPlaceLabel2 = itm;
        }

        var sprPointer = new cc.Sprite(res.Img_Pointer18x18_2, cc.rect(18,0,18,18));
        var sprPointer2 = new cc.Sprite(res.Img_Pointer18x18_2, cc.rect(18,0,18,18));
        sprPointer2.attr({ x: 2, y: -2 });
        var itm = new cc.MenuItemSprite(sprPointer, sprPointer2, callback, target);
        itm.tag = pp.cmPlaceOffset + placeId;
        menu.addChild(itm);

        this.updateFaces();
        this.updateFacilities();
        this.updateScale(1);
    },

    updateFaces: function () {

        var place = pp.world.places[this.placeId];

        var itmFaces = this.itmFaces;
        var sprStars = this.sprStars;

        if (cc.isArray(itmFaces)) {
            itmFaces.forEach(function (itmFace) {
                itmFace.removeFromParent();
            });
        }
        if (cc.isArray(sprStars)) {
            sprStars.forEach(function (sprStar) {
                sprStar.removeFromParent();
            });
        }

        itmFaces = this.itmFaces = [];
        sprStars = this.sprStars = [];

        var persons = place.getPersons();

        for (var i = 0; i < persons.length; i++) {

            var person = persons[i];

            var dy = place.infoPos == 0 ? -pp.SPR_PLACE_DY : pp.SPR_PLACE_DY;
            var sprFace = new cc.Sprite(person.getImageFileName());
            var sprFace2 = new cc.Sprite(person.getImageFileName());
            sprFace2.attr({ x: 2, y: -2 });
            var itmFace = new cc.MenuItemSprite(sprFace, sprFace2, this.callback, this.target);

            itmFace.attr({
                x: (sprFace.width/3 * 1.1) * i,
                y: dy,
                scale: 1/3,
                tag: pp.cmPersonOffset + person.id
            });

            itmFaces.push(itmFace);
            this.menu.addChild(itmFace);

            // Star
            var dy = place.infoPos == 0 ? -1 : 1;

            var starNum = Math.floor(person.fame / 100);
            var padDone = false;
            var paperNum = person.getReports(null, true).length;
            var idx = 0;
            while (true) {
                var spr;
                if (starNum >= 5) {
                    spr = new cc.Sprite(res.Img_StarR11x11);
                    starNum -= 5;
                }
                else if (starNum > 0) {
                    spr = new cc.Sprite(res.Img_Star11x11);
                    starNum -= 1;
                }
                else if (!padDone) {
                    var padNum = [0,2,1][idx%3]; // 0, 2, 1, 0...
                    idx += padNum;
                    padDone = true;
                    continue;
                }
                else if (paperNum >= 5) {
                    spr = new cc.Sprite(res.Img_PaperR11x11);
                    paperNum -= 5;
                }
                else if (paperNum > 0) {
                    spr = new cc.Sprite(res.Img_Paper11x11);
                    paperNum -= 1;
                }
                else
                    break;

                spr.attr({
                    anchorX: 0,
                    x: itmFace.x - sprFace.width/6 + (spr.width - 1) * (idx % 3),
                    y: itmFace.y + (sprFace.height*1.5/6 + (spr.height) * Math.floor(idx / 3)) * dy
                });
                this.addChild(spr);
                sprStars.push(spr);
                idx ++;
            }
        }

        if (pp.mediator.scn.lyrMap) {
            this.updateScale(pp.mediator.scn.lyrMap.scrView.getZoomScale());
        }
    },

    updateFacilities: function () {

        var place = pp.world.places[this.placeId];

        var itmFacilities = this.itmFacilities;

        if (cc.isArray(itmFacilities)) {
            itmFacilities.forEach(function (itmFacility) {
                itmFacility.removeFromParent();
            });
        }

        itmFacilities = this.itmFacilities = [];

        var facilities = place.getFacilities();

        for (var i = 0; i < facilities.length; i++) {

            var facility = facilities[i];

            var dy = place.infoPos == 0 ? -55 : 55;
            var image;
            var tag;
            if (facility instanceof pp.PrSociety) {
                image = pp.createSpriteFrameFromAtlas(pp.ATLAS_SOCIETY_M);
                tag = pp.cmSocietyOffset + facility.id;
            }
            else if (facility instanceof pp.PrUniversity) {
                image = pp.createSpriteFrameFromAtlas(pp.ATLAS_UNIVERSITY_M);
                tag = pp.cmUniversityOffset + facility.id;
            }
            else if (facility instanceof pp.PrObservatory) {
                image = pp.createSpriteFrameFromAtlas(pp.ATLAS_OBSERBATORY_M);
                tag = pp.cmObservatoryOffset + facility.id;
            }

            var sprFaci = new cc.Sprite(image);
            var sprFaci2 = new cc.Sprite(image);
            sprFaci2.attr({ x: 2, y: -2 });
            var itmFaci = new cc.MenuItemSprite(sprFaci, sprFaci2, this.callback, this.target);

            itmFaci.attr({
                x: (sprFaci.width + 3) * (- 1 - i),
                y: 0, //dy,
                tag: tag
            });

            itmFacilities.push(itmFaci);
            this.menu.addChild(itmFaci);
        }
    },

    updateScale: function (viewScale) {

        if (tm.m()) {
            this.scale = 2 / viewScale;

            var w = 0;
            var enabled = false;

            if (viewScale > 1.4) {
                if (viewScale < 1.6) {
                    w = (viewScale - 1.4) / 0.2;
                }
                else {
                    w = 1;
                    enabled = true;
                }
            }
            var opacity = w * 255;

            this.itmPlaceLabel.enabled = enabled;
            this.itmPlaceLabel.opacity = opacity;

            this.itmPlaceLabel2.enabled = !enabled;
            this.itmPlaceLabel2.opacity = 255 - opacity;

            for (var i = 0; i < this.itmFacilities.length; i++) {
                this.itmFacilities[i].setEnabled(enabled);
                this.itmFacilities[i].opacity = opacity;
            }

            for (var i = 0; i < this.sprStars.length; i++) {
                this.sprStars[i].opacity = opacity;
            }

            var place = pp.world.places[this.placeId];
            var dy1 = place.infoPos == 0 ? -pp.SPR_PLACE_DY : pp.SPR_PLACE_DY;
            var dy0 = dy1 * 0.4;

            for (var i = 0; i < this.itmFaces.length; i++) {
                var itmFace = this.itmFaces[i];
                itmFace.attr({
                    y: dy0 + (dy1 - dy0) * w,
                    x: (itmFace.width *(0.5 + w * 0.5)/3 * 1.1) * i,
                    scale: (0.5 + w * 0.5)/3
                });
            }

        }

    },

    getItmFace: function (personId) {
        for (var i = 0; i < this.itmFaces.length; i++) {
            var itmFace = this.itmFaces[i];
            if (personId == itmFace.tag - pp.cmPersonOffset) {
                return itmFace;
            }
        }
        return null;
    }
});

pp.LyrMap = cc.Layer.extend({

    container: null,

    sprFore: null,
    sprWhite: null,
    sprGreen: null,
    sprSea: null,
    lyrPlaces: null,
    sprFocus: null,
    scrView: null,
    sprPlaces: null,
    blinkingPersonId: 0,
    mnuZoom: null,

    actPlace: null,

    ctor: function (callback, target) {

        this._super();

        this._name = "LyrMap";

        this.sprPlaces = [];
        this.blinkingPersonId = pp.ID_INVALID;
        this.actPlace = null;


        // scrView = new cc.ScrollView(cc.winSize, new cc.Sprite(res.Img_Map));
        // Workaround for Cocos2d-JS v3.6
        var scrView = this.scrView = new cc.ScrollView();
        //scrView.setTouchEnabled(false); //@@@

        var container = this.container = new cc.Layer();

        var sprFore = new cc.Sprite(res.Img_MapFore);
        sprFore.ignoreAnchor = true;
        container.addChild(sprFore, 2);
        container.width = sprFore.width;
        container.height = sprFore.height;

        pp.world.mapImageHeight = sprFore.height;

        var sprWhite = new cc.Sprite(res.Img_MapWhite);
        sprWhite.ignoreAnchor = true;
        container.addChild(sprWhite, 1);
        this.sprWhite = sprWhite;

        var sprGreen = new cc.Sprite(res.Img_MapGreen);
        sprGreen.ignoreAnchor = true;
        container.addChild(sprGreen, 1);
        this.sprGreen = sprGreen;


        var sprSea = new cc.Sprite(res.Img_MapSea);
        sprSea.ignoreAnchor = true;
        container.addChild(sprSea, 0);

        sprSea.runAction(
            cc.repeatForever(
                cc.sequence(
                    cc.moveBy(10, cc.p(-134, -134)),
                    cc.place(0, 0)
                )
            )
        );

        scrView.setContainer(container);
        scrView.setViewSize(cc.winSize);

        scrView.setMaxScale(tm.m(2, 1));
        scrView.setDelegate(this);

        this.addChild(scrView, 0);

        var lyrPlaces = this.lyrPlaces = new cc.Layer();
        lyrPlaces.width = scrView.getContentSize().width;
        lyrPlaces.height = scrView.getContentSize().height;
        scrView.addChild(lyrPlaces, 2);

        //---

        for (var i = 0; i < pp.world.places.length; i++) {
            var sprPlace = new pp.SprPlace(i, callback, target);
            lyrPlaces.addChild(sprPlace);
            this.sprPlaces.push(sprPlace);
        }

        this.setFocus(0); // London

        // Zoom Buttons
        if (tm.m()) {
            var menu = this.menu = new pp.MenuZoom(this.scrView, true);

            menu.attr({
                x: 20,
                y: 1045 - pp.LYR_STATUS_BAR_HEIGHT
            });
            this.addChild(menu, 1000);
        }

        {
            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.KEYBOARD,
                    onKeyPressed: function (keyCode, event) {
                        //cc.log("PRESSED keyCode=" + keyCode + " (" + String.fromCharCode(keyCode) + ")");
                        if (keyCode == 189) { // -
                            this.scrView.setZoomScale(this.scrView.getZoomScale() - 0.5);
                        }
                        if (keyCode == 186) { // ;(+)
                            this.scrView.setZoomScale(this.scrView.getZoomScale() + 0.5);
                        }
                        return true;
                    }.bind(this),
                    onKeyReleased: function (keyCode, event) { return true; }
                }),
                this
            );
        }

    },

    scrollViewDidScroll:function (view) {
    },

    scrollViewDidZoom:function (view) {

        if (!tm.m())
            return;

        for (var i = 0; i < this.sprPlaces.length; i++) {
            this.sprPlaces[i].updateScale(view.getZoomScale());
        }

        if (this.sprFocus)
            this.sprFocus.scale = 2 / view.getZoomScale();
    },

    setFocus: function (placeId, callback, target) {
        if (placeId != pp.idInvalid) {
            if (this.sprFocus == null) {
                this.sprFocus = new cc.Sprite(res.Img_Pointer18x18_2, cc.rect(0, 0, 18, 18));
                this.sprFocus.scale = tm.m(2, 1);
                this.lyrPlaces.addChild(this.sprFocus, 2);
            }

            this.sprFocus.stopAllActions();

            this.actPlace = cc.repeatForever(
                cc.sequence(
                    cc.fadeTo(0.01, 255),
                    cc.delayTime(0.59),
                    cc.fadeTo(0.01, 1),
                    cc.delayTime(0.19)
                )
            );

            this.sprFocus.runAction(this.actPlace);

            this.actPlace.step(0); // force first tick
            this.actPlace.step(pp.mediator.scn.act800ms.getElapsed());
        }
        else {
            if (this.sprFocus)
                this.sprFocus.removeFromParent();
        }

        var place = pp.world.places[placeId];

        this.sprFocus.attr({
            x: place.longitude,
            y: this.lyrPlaces.height - place.latitude
        });

        var pos = cc.p(
            -this.sprFocus.x * this.scrView.getZoomScale()+ cc.winSize.width * tm.m(0.5, 0.3),
            -this.sprFocus.y * this.scrView.getZoomScale() + cc.winSize.height/2);

        if (callback) {

            var dist = cc.pDistance(pos, this.scrView.getContentOffset());
            //cc.log("DIST=" + dist);
            var duration = dist > 10 ? 1 : 0;

            this.scrView.setContentOffsetInDuration(pos, duration);
            this.scheduleOnce(function() {
                if (callback)
                    callback.call(target);
            }, duration);
        }
        else {
            this.scrView.setContentOffset(pos);
        }
    },

    updateColorForSeason: function () {

        switch (pp.world.month) {
            case 12: case 1: case 2:
            {
                this.sprGreen.runAction(cc.fadeOut(1));
                this.sprWhite.runAction(
                    cc.spawn(
                        cc.fadeIn(1),
                        cc.tintTo(1, 230, 230, 230)
                    )
                );
                break;
            }

            case 3: case 4: case 5:
            {
                this.sprGreen.runAction(cc.fadeTo(1, 80));
                this.sprWhite.runAction(
                    cc.spawn(
                        cc.fadeIn(1),
                        cc.tintTo(1, 200, 170, 110)
                    )
                );
                break;
            }

            case 6: case 7: case 8:
            {
                this.sprGreen.runAction(cc.fadeIn(1));
                this.sprWhite.runAction(cc.fadeOut(1));
                break;
            }

            case 9: case 10: case 11:
            {
                this.sprGreen.runAction(cc.fadeOut(1));
                this.sprWhite.runAction(
                    cc.spawn(
                        cc.fadeIn(1),
                        cc.tintTo(1, 200, 170, 110)
                    )
                );
                break;
            }
        }

    },

    updatePlace: function (placeId) {
        this.sprPlaces[placeId].updateFaces();
    },

    updateAllPlaces: function () {
        for (var i = 0; i < pp.world.places.length; i++) {
            this.updatePlace(i);
        }
    },

    getItmFace: function (personId) {
        if (personId == pp.ID_INVALID) return null;

        var person = pp.world.persons[personId];
        var sprPlace = this.sprPlaces[person.placeId];

        return sprPlace.getItmFace(personId);
    },

    blinkPerson: function (personId) {

        var currentPid = this.blinkingPersonId;

        var itmFace = this.getItmFace(currentPid);
        if (itmFace) {
            itmFace.stopAllActions();
            itmFace.opacity = 255; //true;
        }

        var itmFace = this.getItmFace(personId);
        var act = cc.repeatForever(
            cc.sequence(
                cc.fadeTo(0.01, 255),
                cc.delayTime(0.59),
                cc.fadeTo(0.01, 1),
                cc.delayTime(0.19)
            )
        );
        if (itmFace) {
            itmFace.runAction(act);
            act.step(0); // force first tick
            act.step(pp.mediator.scn.act800ms.getElapsed());
        }

        this.blinkingPersonId = personId;
    }
});

