pp.LyrModeIndicator = cc.LayerColor.extend({

    action: null,
    label: null,

    ctor: function () {

        this._super(cc.color(0,0,0,128), tm.m(320, 160), tm.m(30, 60));

        this.attr({
            ignoreAnchor: false,
            anchorX: 0,
            anchorY: 1
        });

        this.label = new cc.LabelTTF("", pp.font, tm.m(21, 16), cc.color.WHITE);
        this.addChild(this.label);
        this.label.attr({
            x: this.width/2,
            y: this.height/2,
            textAlign: cc.TEXT_ALIGNMENT_CENTER
        });

        this.action =
            cc.sequence(
                cc.fadeTo(0.01, 255),
                cc.delayTime(0.59),
                cc.fadeTo(0.01, 1),
                cc.delayTime(0.19)
            );

        this.label.runAction(
            cc.repeatForever(this.action)
        );

        this.uiUpdate();
    },

    setActionToSync: function (actToSync) {

        if (actToSync) {
            this.action.step(0);
            this.action.step(actToSync.getElapsed());
        }
    },

    uiUpdate: function () {

        if (pp.mediator.gameState == pp.gsTitle) {
            this.visible = false;
        }
        else if (pp.mediator.isCheckingText) {
            this.visible = true;
            this.label.string = "Checking Text";
        }
        else if (pp.world.tutorialStage != pp.tuOff && pp.world.tutorialStage != pp.tuInvlalid) {
            var compRatio = Math.floor(100 * pp.world.tutorialStage / pp.tuLast);
            this.visible = true;
            this.label.string = __("チュートリアル") + tm.m(' - ', CR) + "(" + compRatio + "% " + __("完了") + ")";
        }
        else {
            this.visible = false;
        }

    }

});
