
pp.SprCondition = cc.Sprite.extend({

    ctor: function (caption) {

        this._super(res.Img_LyrConditionNg);

        var label = new cc.LabelTTF(caption, "Arial", 16);
        label.attr({
            x: this.width/2,
            y: this.height - label.height - 20
        });
        label.setFontFillColor(cc.color.BLACK);
        this.addChild(label);

        var label = new tm.LabelTTF("200/200", "Trajan Pro", 30, cc.color.BLACK, 2);
        label.attr({
            x: this.width/2,
            y: this.height/2
        });
        label.setFontFillColor(cc.color.WHITE);
        this.addChild(label);

    }

});

pp.LyrWriteBook = cc.Layer.extend({

    sprConds: null,
    frmCaption: null,
    lyrKeyValues: null,
    menu: null,

    ctor: function (subject, body, date, personId) {

        this._super(); //cc.color(255,0,0,192));

        // Conditions
        {
            this.sprConds = [];
            var captions = [
                "力学知識",
                "力学実験データ",
                "天文学知識",
                "天文学観測データ",
                "数学知識",
                "数学計算データ"
            ];

            for (var ix = 0; ix < 2; ix++) {
                for (var iy = 0; iy < 3; iy++) {
                    var i = iy * 2 + ix;

                    var sprCond = new pp.SprCondition(captions[i]);
                    sprCond.attr({
                        x: this.width / 2 + (sprCond.width + 30) * ix + 80,
                        y: this.height - 128 - (sprCond.height + 16) * iy
                    });

                    this.addChild(sprCond);
                    this.sprConds.push(sprCond);
                }
            }
        }

        // Caption
        {
            var lbl = new cc.LabelTTF("大著執筆", pp.font, 18);
            lbl.setFontFillColor(cc.color.BLACK);
            lbl.textAlign = cc.TEXT_ALIGNMENT_CENTER;

            var lyrCaption = new cc.Scale9Sprite(res.Img_LyrCaptionPaper);
            var contentWidth = tm.imax(lbl.width, 60) + 80;

            lyrCaption.setContentSize(contentWidth + 80, lyrCaption.height);
            lyrCaption.addChild(lbl);
            lbl.x = lyrCaption.width / 2;
            lbl.y = lyrCaption.height / 2;

            // Caption Bar
            var frameCaption = new tm.Scale9SpriteTiled(res.Img_FrmCommand);
            frameCaption.setContentSize(lyrCaption.width + 80, lyrCaption.height + 40);

            frameCaption.addChild(lyrCaption);
            lyrCaption.x = frameCaption.width / 2;
            lyrCaption.y = frameCaption.height / 2 + 1;
            lyrCaption.anchorY = 0.5;

            this.addChild(frameCaption, 0);

            frameCaption.attr({
                x: 226,
                y: 690
            });

            this.frmCaption = frameCaption;
        }

        // Detail
        {
            var lyr = new pp.LyrKeyValues({
                "題　　材": "\n 力学法則により天体運動を数学的に\n 証明する。\n",
                "必要条件": "\n" +
                " 力学知識200以上\n" +
                " 力学実験データ200以上\n" +
                " 天文学知識200以上\n" +
                " 天文学観測データ200以上\n" +
                " 数学知識200以上\n" +
                " 数学計算データ200以上\n"
            }, null, true);

            lyr.attr({
                ignoreAnchor: false,
                x: this.frmCaption.x,
                y: 450
            });

            this.addChild(lyr);

            this.lyrKeyValues = lyr;
        }

        // Buttons
        {
            var menu = new pp.MenuRect(
                [ "状況分析", "執筆開始", "戻る"],
                function () {
                },
                this,
                false,
                null,
                true,
                40,
                3
            );

            menu.attr({
                ignoreAnchor: false,
                anchorX: 0.5,
                x: this.frmCaption.x,
                y: 40
            });

            this.addChild(menu);
            this.menu = menu;
        }
    }

});

