pp.MENU_TINT = cc.color(48,48,148);
//pp.MENU_TINT = cc.color(220,220,255);

pp.MenuRect = cc.Node.extend({

    menu: null,
    selectedIndex: null,
    isRadio: false,
    items: null,

    createMenuItem: function (string, callback, target, tint, isRadio, xMagnitude, barVal, isFlat, fontSize) {

        var createSpriteForMenuItem = function (tint, string, iconOpacity, xMagnitude, barVal, isFlat, fontSize) {

            xMagnitude = xMagnitude || 1;
            fontSize = fontSize || __(16, 14);

            var yMagnitude = tm.m(1.75, 1);
            fontSize *= tm.m(1.75, 1);

            var spr = new cc.Scale9Sprite(res.Img_BtnEmptyR);
            var width = spr.width;
            var height = spr.height;

            if (isFlat) {
                spr = new cc.LayerColor(cc.color.WHITE);
            }

            spr.setContentSize(width * xMagnitude, height * yMagnitude);
            spr.setColor(tint);
            spr.setCascadeColorEnabled(false);

            if (!isFlat)
            {
                var sprBaseBright = new cc.Scale9Sprite(res.Img_BtnBaseBrightR);
                sprBaseBright.setContentSize(sprBaseBright.width * xMagnitude, sprBaseBright.height * yMagnitude);
                sprBaseBright.ignoreAnchor = true;
                spr.addChild(sprBaseBright, 1);
            }

            if (string) {
                var label = new tm.LabelTTF(string, pp.font, fontSize, cc.color.BLACK, cc.color.WHITE, 2);
                label.attr({
                    x: spr.width/2,
                    y: spr.height/2,
                    anchorY: 0.5,
                    anchorX: 0.5,
                    textAlign: cc.TEXT_ALIGNMENT_CENTER
                });
                //label.setFontFillColor(cc.color.WHITE);
                //label.enableStroke(cc.color.BLACK, 2);

                label.opacity = iconOpacity ? iconOpacity : 255;
                spr.addChild(label, 2);
            }

            if (barVal) {
                var lyr = new pp.LyrBar([cc.color.RED, cc.color.GREEN], cc.color.BLACK, spr.width - 10, 6, barVal);
                lyr.attr({ ignoreAnchor: false, x: spr.width/2, y: 4, anchorY: 0, anchorX: 0.5 });
                spr.addChild(lyr, 2);
            }

            if (!isFlat)
            {
                var sprBright = new cc.Scale9Sprite(res.Img_BtnBrightR);
                sprBright.setContentSize(sprBright.width * xMagnitude, sprBright.height * yMagnitude);
                sprBright.ignoreAnchor = true;
                spr.addChild(sprBright, 3);
            }

            return spr;
        };

        if (isRadio) {
            var itemOn = this.createMenuItem(string, callback, target, tint, false, xMagnitude, barVal, isFlat, fontSize);
            var itemOff = this.createMenuItem(string, callback, target, cc.color(48,48,48), false, xMagnitude, barVal, isFlat, fontSize);

            return new cc.MenuItemToggle(itemOn, itemOff,
                function (item) {
                    this.didRadioSelectionChange(item);

                    callback.call(target, item);
                },
                this);
        }
        else {
            var sprUp = createSpriteForMenuItem(tint, string, undefined, xMagnitude, barVal, isFlat, fontSize);
            var sprDown = createSpriteForMenuItem(tint, string, undefined, xMagnitude, barVal, isFlat, fontSize);
            sprDown.attr({x: 2, y: -2});
            var sprDim = createSpriteForMenuItem(cc.color(127, 127, 127), string, 127, xMagnitude, null, isFlat, fontSize);

            return new cc.MenuItemSprite(
                sprUp,
                sprDown,
                sprDim,
                callback,
                target
            );
        }
    },

    ctor: function (strings, callback, target, isRadio, tint, isVertical, span, xMagnitude, barVal, isFlat, fontSize) {

        this._super();

        isRadio = isRadio == true;
        this.isRadio = isRadio;
        tint = tint || pp.MENU_TINT;
        span = span || 0;
        xMagnitude = xMagnitude || 1;

        var yMagnitude = tm.m(1.75, 1);
        xMagnitude *= tm.m(1.75, 1);

        // Buttons
        {
            var width;
            var height;

            // Button Frames
            if (isFlat)
            {
                var spr = new cc.Scale9Sprite(res.Img_BtnFrameR);

                spr.setContentSize(spr.width * xMagnitude, spr.height * yMagnitude);

                width = spr.width;
                height = spr.height;
            }
            else
            {
                for (var i = 0; i < strings.length; i++) {
                    var spr = new cc.Scale9Sprite(res.Img_BtnFrameR);
                    spr.setContentSize(spr.width * xMagnitude, spr.height * yMagnitude);
                    spr.attr({
                        x: isVertical ? 0 : (spr.width + span)*i,
                        y: isVertical ? (spr.height + span)*(strings.length - 1 - i) : 0,
                        ignoreAnchor: true
                    });
                    this.addChild(spr, 3);

                    var spr = new cc.Scale9Sprite(res.Img_BtnBaseR);
                    spr.setContentSize(spr.width * xMagnitude, spr.height * yMagnitude);
                    spr.attr({
                        x: isVertical ? 0 : (spr.width + span)*i,
                        y: isVertical ? (spr.height + span)*(strings.length - 1 - i) : 0,
                        ignoreAnchor: true
                    });
                    this.addChild(spr, 1);

                    width = spr.width;
                    height = spr.height;
                }
            }

            // Menu with Buttons
            {
                var menu = this.menu = new cc.Menu();
                menu.attr({ x: 0, y: 0 });
                this.addChild(menu, 2);

                this.items = [];

                for (var i = 0; i < strings.length; i++) {
                    var item = this.createMenuItem(strings[i], callback, target, tint, isRadio, xMagnitude, barVal, isFlat, fontSize);
                    item.attr({
                        x: isVertical ? 0 : (width + span)*i,
                        y: isVertical ? (height + span)*(strings.length - 1 - i) : 0,
                        ignoreAnchor: true
                    });

                    item.tag = i;
                    menu.addChild(item);

                    this.items.push(item);
                }
            }
        }

        this.width = isVertical ? width : (width + span) * strings.length - span;
        this.height = isVertical ? (height + span) * strings.length - span : height;

        if (this.isRadio && this.menu.getChildrenCount() > 0) {
            this.didRadioSelectionChange(this.menu.getChildren()[0]);
        }
    },

    didRadioSelectionChange: function (item) {
        item.setSelectedIndex(1-item.getSelectedIndex());
    },

    enableItem: function (i, val) {
        if (i < -1 || i >= this.items.length) return;
        val = val == null ? true : val;
        this.items[i].setEnabled(val);
    },

    disableItem: function (i) {
        this.enableItem(i, false);
    },

    setSelectedIndex: function (idx) {
        for (var i = 0; i < this.menu.getChildrenCount(); i++) {
            this.menu.getChildren()[i].setSelectedIndex(idx == i ? 0 : 1);
        }
    },

    getSelectedIndex: function () {
        for (var i = 0; i < this.menu.getChildrenCount(); i++) {
            if (this.menu.getChildren()[i].getSelectedIndex() == 0) return i;
        }
        return pp.idxInvalid;
    },

    setEnabled: function (enabled) {
        this.menu.setEnabled(enabled);
    }
});
