pp.POP_FRM_NO_BUTTONS = 1;
pp.POP_FRM_OK_BUTTON = 2;
pp.POP_FRM_CANCEL_BUTTON = 3;
pp.POP_FRM_OK_CANCEL_BUTTONS = 4;
pp.POP_FRM_NO_CANCEL_BUTTON = 5; // フレーム外クリック時、キャンセルされない
pp.POP_FRM_YES_NO_BUTTON = 6;
pp.POP_FRM_CUSTOM_BUTTONS_WITH_CANCEL = 7;
pp.POP_FRM_SIMPLE = 11;
pp.POP_FRM_FLAT = 12;
pp.POP_FRM_FLAT_OK_CANCEL_BUTTONS = 13;
pp.POP_FRM_FLAT_CANCEL_BUTTON = 14;

pp.POP_WAS_OK = 0;
pp.POP_WAS_CANCEL = -1;

pp.POP_CAPTION_NONE = 0;
pp.POP_CAPTION_INSIDE = 1;
pp.POP_CAPTION_OUTSIDE = 2;
pp.POP_CAPTION_CONGRATS = 3;
pp.POP_CAPTION_INSIDE_FLAT = 4;

pp.POP_MARGINE_SIDE = 120;
pp.POP_MARGINE_TOP = 20;
pp.POP_MARGINE_BOTTOM = 30;
pp.POP_MARGINE_BOTTOM_BUTTON = tm.m(160, 100);
pp.POP_MARGINE_BOTTOM_BUTTON_FLAT = tm.m(120, 100);

pp.POP_ROW_HEIGHT = 40;

pp.POP_MARGINE_SIDE_SIMPLE = 40;
pp.POP_MARGINE_TOP_SIMPLE = 20;
pp.POP_MARGINE_BOTTOM_SIMPLE = 20;

pp.POP_ANIME_SIMULTANEOUS = 1;
pp.POP_ANIME_IMAGE_FIRST = 2;
pp.POP_ANIME_VOICE = 3;
pp.POP_ANIME_VOICE_IMAGE = 4;

pp.POP_LABEL_MAX_WIDTH = tm.m(600, 650);

pp.Pop_defaultSound = true;
pp.Pop_needSwallow = true;
pp.Pop_position = cc.p(0, 0);
pp.Pop_margin_side = 0;
pp.Pop_margin_vertical = 0;
pp.Pop_from_pos = null;

pp.Pop = cc.Layer.extend({

    listener: null,

    layerMessage: null,
    layerCaption: null,
    layerImage: null,

    sprNext: null,

    frame0: null,
    frame1: null,
    frameType: 0,
    isDemoDone: false,
    onActionDone: null,
    onActionDoneTarget: null,

    captionType: 0,

    touchPosBegan: null,
    allowOverlap: false,

    cancelled: false,

    _needSwallow: true,

    animeStage: 0,
    animeMaxStage: 1,
    animeType: pp.POP_ANIME_SIMULTANEOUS,

    fromPos: null,

    ctor: function (lyrContent, caption, frameTypeOrOptions, callback, target, backOpacity, captionType, allowOverlap, animeType) {

        this._super();

        this._name = "Pop";

        this.listener = null;

        this.isDemoDone = false;

        this._needSwallow = pp.Pop_needSwallow;

        var layerMessage = this.layerMessage = new cc.Layer();
        var layerCaption = this.layerCaption = new cc.Layer();
        var layerImage = this.layerImage = new cc.Layer();
        this.addChild(layerMessage, 1);
        this.addChild(layerCaption, 1);
        this.addChild(layerImage, 1);

        var lyrContent0 = cc.isArray(lyrContent) ? lyrContent[0] : lyrContent;
        var lyrContent1 = cc.isArray(lyrContent) ? lyrContent[1] : null;

        var options = frameTypeOrOptions;
        var frameType = cc.isArray(frameTypeOrOptions) ? pp.POP_FRM_CUSTOM_BUTTONS_WITH_CANCEL : frameTypeOrOptions;

        this.allowOverlap = allowOverlap;
        this.frameType = frameType;
        captionType = captionType ||
            (caption ?
                (frameType == pp.POP_FRM_FLAT  || frameType == pp.POP_FRM_FLAT_CANCEL_BUTTON || frameType == pp.POP_FRM_FLAT_OK_CANCEL_BUTTONS ?
                    pp.POP_CAPTION_INSIDE_FLAT :
                    pp.POP_CAPTION_INSIDE) :
                pp.POP_CAPTION_NONE);
        this.captionType = captionType;

        animeType = animeType || pp.POP_ANIME_SIMULTANEOUS;
        if (animeType == pp.POP_ANIME_IMAGE_FIRST && lyrContent1 == null) {
            animeType = pp.POP_ANIME_SIMULTANEOUS;
        }
        if (animeType == pp.POP_ANIME_VOICE_IMAGE && lyrContent1 == null) {
            animeType = pp.POP_ANIME_VOICE;
        }

        var rowHeight = pp.ROW_HEIGHT;

        this.animeStage = 0;
        if (animeType == pp.POP_ANIME_SIMULTANEOUS) {
            this.animeMaxStage = 1;
        }
        else if (animeType == pp.POP_ANIME_IMAGE_FIRST) {
            this.animeMaxStage = 2;
        }
        else if (animeType == pp.POP_ANIME_VOICE) {
            this.animeMaxStage = 1 + this.getVoiceLength() - 1;
        }
        else if (animeType == pp.POP_ANIME_VOICE_IMAGE) {
            this.animeMaxStage = 2 + this.getVoiceLength() - 1;
        }
        this.animeType = animeType;

        // Black Wall
        {
            var opacity = backOpacity ? backOpacity : 1;
            var spr = new cc.LayerColor(cc.color(0, 0, 0));
            spr.setOpacity(opacity);
            this.addChild(spr, 0);
        }

        var frame0;
        switch (frameType) {
            case pp.POP_FRM_NO_BUTTONS:
            case pp.POP_FRM_NO_CANCEL_BUTTON:
                frame0 = new pp.Frm(tm.m(res.ImgM_FrmWithoutButton, res.Img_FrmWithoutButton)); //@@@
                break;
            case pp.POP_FRM_SIMPLE:
                frame0 = new pp.Frm(res.Img_FrmSimple256x256);
                break;
            case pp.POP_FRM_FLAT:
            case pp.POP_FRM_FLAT_CANCEL_BUTTON:
            case pp.POP_FRM_FLAT_OK_CANCEL_BUTTONS:
                frame0 = new cc.LayerColor(cc.color(0,0,0,192));
                break;
            default:
                frame0 = new pp.Frm(tm.m(res.ImgM_FrmWithButton, res.Img_FrmWithButton)); //@@@
                break;
        }
        frame0.attr({
            ignoreAnchor: false
        });
        this.frame0 = frame0;

        var frame1;
        if (lyrContent1) {
            frame1 = new pp.Frm(res.Img_FrmSimple256x256);
            lyrContent1.attr({
                ignoreAnchor: true,
                x: 20,
                y: 20
            });
            frame1.addChild(lyrContent1);
            frame1.setContentSize(lyrContent1.width + 40, lyrContent1.height + 40);
            frame1.attr({
                ignoreAnchor: false,
                x: cc.winSize.width / 2,
                y: cc.winSize.height / 2 - tm.m(70, 20)
            });
            layerImage.addChild(frame1);
        }
        this.frame1 = frame1;

        layerMessage.addChild(frame0);

        frame0.addChild(lyrContent0);

        var marginTop = frameType == pp.POP_FRM_SIMPLE ? pp.POP_MARGINE_TOP_SIMPLE : pp.POP_MARGINE_TOP;
        var marginBottom =
            frameType == pp.POP_FRM_NO_BUTTONS || frameType == pp.POP_FRM_NO_CANCEL_BUTTON || frameType == pp.POP_FRM_FLAT ?
                pp.POP_MARGINE_BOTTOM :
                frameType == pp.POP_FRM_SIMPLE ?
                    pp.POP_MARGINE_BOTTOM_SIMPLE :
                    (frameType == pp.POP_FRM_FLAT_CANCEL_BUTTON || frameType == pp.POP_FRM_FLAT_OK_CANCEL_BUTTONS ? pp.POP_MARGINE_BOTTOM_BUTTON_FLAT : pp.POP_MARGINE_BOTTOM_BUTTON);
        var marginSide = frameType == pp.POP_FRM_SIMPLE ? pp.POP_MARGINE_SIDE_SIMPLE : pp.POP_MARGINE_SIDE;
        marginSide += pp.Pop_margin_side;
        marginTop += pp.Pop_margin_vertical/2;
        marginBottom += pp.Pop_margin_vertical/2;

        if (lyrContent0.height < 40) {
            marginTop += 10;
            marginBottom += 10;
        }

        // Window Caption
        var frameCaption = null;
        if (captionType == pp.POP_CAPTION_CONGRATS) {
            frame0.setContentSize(lyrContent0.width + marginSide, lyrContent0.height + marginTop + marginBottom);

            // Caption Bar (Congrats!)
            frameCaption = new pp.Frm(res.Img_FrmDate);
            frameCaption.attr({
                ignoreAnchor: false,
                x: this.width / 2,
                y: this.height * 0.85 - tm.m(70, 20)
            });
            var spr = new cc.Sprite(res.Img_Congrats);
            frameCaption.setContentSize(spr.width + 80, spr.height + 80);
            spr.attr({
                x: frameCaption.width/2,
                y: frameCaption.height/2
            });
            frameCaption.addChild(spr);

            this.layerCaption.addChild(frameCaption, 0);

            frame1.y += tm.m(100, 0);
        }
        else if (caption && captionType != pp.POP_CAPTION_NONE) {
            var lbl = new tm.LabelTTF(caption, pp.font, __(tm.m(27, 18), tm.m(24, 16)));
            lbl.setFontFillColor(cc.color.BLACK);
            lbl.textAlign = cc.TEXT_ALIGNMENT_CENTER;

            var sprCaption = (captionType == pp.POP_CAPTION_INSIDE || captionType == pp.POP_CAPTION_OUTSIDE) ?
                new tm.Scale9SpriteTiled(tm.m(res.ImgM_LyrCaptionPaper, res.Img_LyrCaptionPaper)) :
                new cc.Scale9Sprite(res.Img_LyrCaptionTutorial, undefined, cc.rect(50, 0, 200, 39));
                //new cc.LayerColor(cc.color(192,192,192));

            var contentWidth = tm.imax(lbl.width, 60) + 80;

            sprCaption.ignoreAnchor = false;
            sprCaption.setContentSize(
                tm.m(captionType == pp.POP_CAPTION_OUTSIDE ? 640 : contentWidth + 80, contentWidth + 80),
                tm.m(rowHeight*1.5, rowHeight)
            );
            sprCaption.addChild(lbl);
            lbl.x = sprCaption.width / 2;
            lbl.y = sprCaption.height / 2;

            if (captionType && (captionType == pp.POP_CAPTION_INSIDE || captionType == pp.POP_CAPTION_INSIDE_FLAT)) {
                marginTop += frameType == pp.POP_FRM_SIMPLE ? 50 : 40;
                marginTop += tm.m(80, 20); //@@@
                var marginTop2 = frameType == pp.POP_FRM_SIMPLE ? 10 : 6;
                marginTop2 += tm.m(20, 10); //@@@

                sprCaption.attr({
                    anchorY: 1,
                    y: lyrContent0.height + marginBottom + marginTop / 2 + marginTop2
                });
                var contentWidth = tm.imax(lbl.width, 60) + 80;

                frame0.addChild(sprCaption);

                frame0.setContentSize(
                    tm.max(lyrContent0.width + marginSide, sprCaption.width + 80),
                    lyrContent0.height + marginTop + marginBottom);

                sprCaption.x = frame0.width / 2;
                lyrContent0.x = frame0.width / 2 - lyrContent0.width / 2;
            }
            else {
                frame0.setContentSize(
                    tm.m(tm.max(lyrContent0.width, 600), lyrContent0.width) + marginSide,
                    lyrContent0.height + marginTop + marginBottom);

                // Caption Bar (out side of frame)
                frameCaption = new pp.Frm(res.Img_FrmCommand);
                frameCaption.setContentSize(sprCaption.width + 80, sprCaption.height + 40);

                frameCaption.attr({
                    ignoreAnchor: false,
                    x: this.width / 2,
                    y: this.height / 2 + frame0.height / 2 + tm.m(-40, 10) + (lyrContent1 ? frame1.height / 2 - 20 : tm.m(80, 0)),
                    anchorY: 0
                });
                frameCaption.addChild(sprCaption);
                sprCaption.x = frameCaption.width / 2;
                sprCaption.y = frameCaption.height / 2 + 1;
                sprCaption.anchorY = 0.5;

                this.layerCaption.addChild(frameCaption, 0);
            }
        }
        else {
            frame0.setContentSize(lyrContent0.width + marginSide, lyrContent0.height + marginTop + marginBottom);
        }

        frame0.attr({
            x: cc.winSize.width / 2 + pp.Pop_position.x,
            y: cc.winSize.height / 2 - (lyrContent1 ? (frame1.height + frame0.height + frameCaption.height + 160) / 4 : 0) + pp.Pop_position.y
        });

        lyrContent0.attr({
            ignoreAnchor: false,
            anchorX: 0.5,
            anchorY: 0,
            x: frame0.width/2,
            y: marginBottom
        });

        if (frame1) frame1.y += frame0.height / 2;

        //*** OK & Cancel buttons
        {
            var buttons = [];

            if (frameType == pp.POP_FRM_CUSTOM_BUTTONS_WITH_CANCEL) {
                buttons = buttons.concat(options);
            }
            if (frameType == pp.POP_FRM_YES_NO_BUTTON) {
                buttons.push(__("はい"));
                buttons.push(__("いいえ"));
            }
            if (frameType == pp.POP_FRM_OK_BUTTON || frameType == pp.POP_FRM_FLAT_OK_CANCEL_BUTTONS || frameType == pp.POP_FRM_OK_CANCEL_BUTTONS) {
                buttons.push(__("O K"));
            }
            if (frameType == pp.POP_FRM_CANCEL_BUTTON || frameType == pp.POP_FRM_FLAT_CANCEL_BUTTON || frameType == pp.POP_FRM_OK_CANCEL_BUTTONS
                || frameType == pp.POP_FRM_FLAT_OK_CANCEL_BUTTONS || frameType == pp.POP_FRM_CUSTOM_BUTTONS_WITH_CANCEL) {
                buttons.push(__("キャンセル"));
            }
            var buttonsLength = buttons.length;

            var menu = new pp.MenuRect(
                buttons,
                function (item) {
                    if (frameType == pp.POP_FRM_CUSTOM_BUTTONS_WITH_CANCEL) {
                        if (item.tag == buttonsLength-1)
                            this.didGetSelection(pp.POP_WAS_CANCEL);
                        else
                            this.didGetSelection(item.tag);
                    }
                    else if (frameType == pp.POP_FRM_YES_NO_BUTTON) {
                        this.didGetSelection(item.tag);
                    }
                    else {
                        if (item.tag == 1 || frameType == pp.POP_FRM_CANCEL_BUTTON || frameType == pp.POP_FRM_FLAT_CANCEL_BUTTON) {

                            this.didGetSelection(pp.POP_WAS_CANCEL);
                        }
                        else {
                            this.didGetSelection(pp.POP_WAS_OK);
                        }
                    }
                },
                this,
                null,
                null,
                false,
                buttonsLength > 3 ? 0 : 48,
                null,
                null,
                (frameType == pp.POP_FRM_FLAT_CANCEL_BUTTON || frameType == pp.POP_FRM_FLAT_OK_CANCEL_BUTTONS)
            );
            menu.attr({
                x: frame0.width / 2,
                anchorX: 0.5,
                y: (frameType == pp.POP_FRM_FLAT_CANCEL_BUTTON || frameType == pp.POP_FRM_FLAT_OK_CANCEL_BUTTONS) ? tm.m(20, 30) : tm.m(24, 9)
            });
            frame0.addChild(menu, 1);
        }

        this.doNextAnime();

        this.onActionDone = callback;
        this.onActionDoneTarget = target;

        /*
        if (pp.mediator.messageWaitInSec != 0 && (pp.mediator.waitingMode & pp.MW_TIMEOUT)) {
            this.scheduleOnce(this.onTimeOut, pp.mediator.messageWaitInSec, "UI");
        }
        */


        // Swallow touches
        {
            this.listener = cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: this._needSwallow,
                    onTouchBegan: function (touch, event) {
                        var node = event.getCurrentTarget();
                        //cc.log(node._name + ": onTouchBegan, zorder = " + node.getGlobalZOrder() + ", " + node.getLocalZOrder());

                        node.touchPosBegan = tm.getTouchPos(touch);

                        return true;
                    },
                    onTouchMoved: function () { return; },
                    onTouchCancelled: function () { return; },
                    onTouchEnded: function (touch, event) {
                        var node = event.getCurrentTarget();

                        if (node.isDemoDone == false) {
                            return;
                        }

                        node.unschedule(node.onTimeOut);

                        if (node.animeStage == node.animeMaxStage) {
                            if (node.frameType == pp.POP_FRM_NO_BUTTONS || node.frameType == pp.POP_FRM_SIMPLE || node.frameType == pp.POP_FRM_FLAT) {
                                node.didGetSelection(pp.POP_WAS_OK);
                            }
                            else if (node.frameType == pp.POP_FRM_NO_CANCEL_BUTTON || node.frameType == pp.POP_FRM_OK_BUTTON || node.frameType == pp.POP_FRM_YES_NO_BUTTON) {
                                // nothing to do.
                                //cc.log("POP_FRM_NO_CANCEL_BUTTON");
                                //return false;
                            }
                            else {
                                if ((tm.isInside(tm.getTouchPos(touch), node.frame0)
                                    || tm.isInside(node.touchPosBegan, node.frame0))) {
                                    //cc.log("INSIDE");
                                }
                                else {
                                    node.didGetSelection(pp.POP_WAS_CANCEL);
                                    //cc.log("outside");
                                }
                            }
                            node.touchPosBegan = null;
                        }
                        else {
                            node.doNextAnime();
                        }
                    }
                }),
                this
            );
        }

    },

    onTimeOut: function (elapsed) {

        //cc.log("**************** onTimeOut called");

        if (this.isDemoDone == false) {
            //cc.log("OH IS_DEMO_DONE is false!");
            return;
        }

        if (this.animeStage == this.animeMaxStage) {
            if (this.frameType == pp.POP_FRM_NO_BUTTONS || this.frameType == pp.POP_FRM_SIMPLE || this.frameType == pp.POP_FRM_FLAT) {
                this.didGetSelection(pp.POP_WAS_OK);

                //if (pp.mediator.messageWaitInSec != 0 && (pp.mediator.waitingMode & pp.MW_TIMEOUT)) {
                //    this.unschedule(this.onTimeOut);
                //}
            }
        }
        else {
            this.scheduleOnce(function () { this.doNextAnime(); });
        }
    },

    getVoiceLength: function () {
        // abstract method
        return 0;
    },

    doNextAnimeForVoice: function (stage) {
        // abstract method
    },

    onFirstAnimeDone: function () {
        // abstract method
    },

    doNextAnime: function () {
        //cc.log("doNextAnime called: " + this.animeStage);


        switch (this.animeStage == this.animeMaxStage ? -1 : this.animeStage) {
            case 0:
                // First anime
                switch (this.animeType) {

                    case pp.POP_ANIME_VOICE:
                    case pp.POP_ANIME_SIMULTANEOUS:
                    {
                        this.layerCaption.removeFromParent(false);
                        this.layerImage.removeFromParent(false);
                        this.layerMessage.addChild(this.layerCaption);
                        this.layerMessage.addChild(this.layerImage);

                        if (pp.Pop_from_pos) {
                            this.layerMessage.attr({
                                x: pp.Pop_from_pos.x-this.layerMessage.width/2,
                                y: pp.Pop_from_pos.y-this.layerMessage.height/2,
                                scale: 0.1
                            });
                            this.layerMessage.runAction(
                                cc.spawn(
                                    cc.moveTo(0.2, cc.p(0, 0)),
                                    cc.scaleTo(0.2, 1)
                                )
                            );
                            this.fromPos = pp.Pop_from_pos;
                            pp.Pop_from_pos = null;
                        }
                        else {
                            this.layerMessage.x = -this.width;
                            this.layerMessage.runAction( cc.moveTo(0.2, cc.p(0, 0)) );
                        }

                        this.isDemoDone = false;
                        this.scheduleOnce(function () { this.isDemoDone = true; }, 0.3, "Anime" );

                        break;
                    }

                    case pp.POP_ANIME_VOICE_IMAGE:
                    case pp.POP_ANIME_IMAGE_FIRST:
                    {
                        this.layerMessage.x = -this.width;
                        this.layerImage.y = -this.height;

                        if (this.captionType == pp.POP_CAPTION_CONGRATS) {
                            this.layerCaption.x = 0;
                            this.layerCaption.removeFromParent(false);
                            this.layerMessage.addChild(this.layerCaption);
                        }
                        else {
                            this.layerCaption.x = -this.width;
                            this.layerCaption.runAction( cc.moveTo(0.2, cc.p(0, 0)) );
                        }

                        this.layerImage.runAction( cc.moveTo(0.4, cc.p(0, 0)) );

                        this.isDemoDone = false;
                        this.scheduleOnce(
                            function () {
                                pp.mediator.uiShowClickMark(this.frame1, pp.clmMore);
                                this.isDemoDone = true;
                            },
                            0.5, "Anime" );

                        break;
                    }
                }
                break;

            case 1:
                // 0 -> 1
                this.onFirstAnimeDone();

                switch (this.animeType) {
                    case pp.POP_ANIME_VOICE_IMAGE:
                    case pp.POP_ANIME_IMAGE_FIRST:
                    {
                        pp.mediator.uiRemoveClickMark();

                        this.layerMessage.runAction( cc.moveTo(0.2, cc.p(0, 0)) );

                        this.isDemoDone = false;
                        this.scheduleOnce(
                            function () {
                                pp.mediator.uiShowClickMark(this.frame0, this.allowOverlap ? pp.clmMore : pp.clmCleanup);
                                this.isDemoDone = true;
                            },
                            0.3, "Anime" );
                        break;
                    }
                    case pp.POP_ANIME_VOICE:
                    {
                        this.doNextAnimeForVoice(this.animeStage - (this.animeType == pp.POP_ANIME_VOICE ? 0 : 1));
                        break;
                    }
                }

                break;

            default:
                this.doNextAnimeForVoice(this.animeStage - (this.animeType == pp.POP_ANIME_VOICE ? 0 : 1));
                break;

            case -1:
                // Last anime & cleanup
                var delayForRemove = 0;
                switch (this.animeType) {

                    case pp.POP_ANIME_SIMULTANEOUS:
                    case pp.POP_ANIME_VOICE:
                    {
                        this.isDemoDone = false;

                        if (this.fromPos) {
                            this.layerMessage.runAction(
                                cc.spawn(
                                    cc.moveTo(0.2, cc.p(
                                            this.fromPos.x-this.layerMessage.width/2,
                                            this.fromPos.y-this.layerMessage.height/2)
                                    ),
                                    cc.scaleTo(0.2, 0.1)
                                )
                            );
                        }
                        else {
                            if (this.cancelled) {
                                this.layerMessage.runAction(cc.moveTo(0.2, cc.p(-cc.winSize.width, 0)));
                            }
                            else {
                                this.layerMessage.runAction( cc.moveTo(0.2, cc.p(cc.winSize.width, 0)) );
                            }
                        }

                        delayForRemove = 0.2;
                        break;
                    }

                    case pp.POP_ANIME_VOICE_IMAGE:
                    case pp.POP_ANIME_IMAGE_FIRST:
                    {
                        this.isDemoDone = false;

                        if (this.cancelled) {
                            this.layerMessage.runAction( cc.moveTo(0.2, cc.p(-cc.winSize.width, 0)) );
                            this.layerCaption.runAction( cc.moveTo(0.2, cc.p(-cc.winSize.width, 0)) );
                            this.layerImage.runAction( cc.moveTo(0.2, cc.p(-cc.winSize.width, 0)) );
                        }
                        else {
                            this.layerMessage.runAction( cc.moveTo(0.2, cc.p(cc.winSize.width, 0)) );
                            this.layerCaption.runAction( cc.moveTo(0.2, cc.p(cc.winSize.width, 0)) );
                            this.layerImage.runAction( cc.moveTo(0.2, cc.p(cc.winSize.width, 0)) );
                        }
                        delayForRemove = 0.2;
                        break;
                    }
                }

                this.runAction(
                    cc.sequence(
                        cc.delayTime(delayForRemove),
                        cc.removeSelf(true)
                    )
                );

                break;
        }

        this.animeStage = tm.min(this.animeStage + 1, this.animeMaxStage);

        if (pp.mediator.messageWaitInSec != 0 && (pp.mediator.waitingMode & pp.MW_TIMEOUT)) {
            this.scheduleOnce(this.onTimeOut, pp.mediator.messageWaitInSec, "UI");
        }
    },

    didGetSelection: function (sel) {

        if (sel == pp.POP_WAS_CANCEL) {

            //*** Cancelled
            if (this.onActionDone) {
                this.onActionDone.call(this.onActionDoneTarget, pp.POP_WAS_CANCEL);
            }

            this.cancelled = true;

            this.animeStage = this.animeMaxStage;
            this.doNextAnime();
        }
        else {
            //*** OK
            if (this.onActionDone) {
                this.onActionDone.call(this.onActionDoneTarget, sel);
            }

            this.cancelled = false;

            if (!this.allowOverlap) {
                this.animeStage = this.animeMaxStage;
                this.doNextAnime();
            }
        }

    },

    doLastAnimeForOverlapped: function () {
        this.animeStage = this.animeMaxStage;
        this.doNextAnime();
    }

    /*
    onExit: function () {
        cc.log(">> pp.Pop.onExit called.")
    }
    */
});
