
pp.PopDetail = pp.Pop.extend({

    ctor: function (caption, subContent, keyValues, description, callback, target, backOpacity, allowOverlap, frameTypeOrOptions, autoHeight) {

        var content = new cc.Layer();
        //backOpacity = cc.isNumber(backOpacity) ? backOpacity : 1;
        frameTypeOrOptions = frameTypeOrOptions || pp.POP_FRM_NO_BUTTONS;

        var lyrKeyValues = new pp.LyrKeyValues(keyValues, description, null, autoHeight);
        lyrKeyValues.attr({
            ignoreAnchor: false,
            anchorY: 0,
            anchorX: 0.5
        });

        content.addChild(lyrKeyValues);
        content.attr({
            width: tm.m(cc.winSize.width - pp.POP_MARGINE_SIDE - 20, lyrKeyValues.width + 20),
            height: lyrKeyValues.height + 0
        });

        if (subContent) {
            content.addChild(subContent);
            content.width = tm.m(cc.winSize.width - pp.POP_MARGINE_SIDE - 20, tm.max(content.width, subContent.width));
            content.height += subContent.height * subContent.scaleY + 20;
            lyrKeyValues.x = 10 + content.width /2;
            subContent.attr({
                ignoreAnchor: false,
                anchorX: 0.5,
                anchorY: 0.5,
                x: content.width / 2,
                y: lyrKeyValues.height + subContent.height * subContent.scaleY / 2 + 15,
            });
        }
        lyrKeyValues.x = content.width / 2;

        this._super(content, caption, frameTypeOrOptions, callback, target, backOpacity, pp.POP_CAPTION_INSIDE, allowOverlap);
    },

    didGetSelection: function (sel) {
        if (sel == pp.POP_WAS_CANCEL) {
            pp.mediator.playSound(res.Snd_Cancel);
        }
        else {
            pp.mediator.playSound(res.Snd_Click);
        }
        this._super(sel);
    }
});

pp.PopDetailReport = pp.PopDetail.extend({

    ctor: function (reportId, callback, target, backOpacity, allowOverlap) {

        var report = pp.world.reports[reportId];
        var disc = pp.world.discoveries[report.discoveryId];
        var societyName;
        //var acceptDateStr;
        var backingStr;
        if (report.societyId == pp.ID_INVALID) {
            societyName = "--";
            backingStr = "--";
        }
        else {
            societyName = pp.world.societies[report.societyId].name;
            backingStr = "" + report.backing;
        }

        var hasFigure = disc.type == pp.ttFigure || disc.type == pp.ttItem;
        var subContent = new cc.Layer();
        var lyrLetter = new pp.LyrLetter(
            report.getTitle(),
            report.getBody(),
            report.getComposedDateStr(),
            report.personId
        );

        if (hasFigure) {
            var lyrFigure;
            if (disc.type == pp.ttItem) {
                var item = pp.world.items[disc.itemId];
                var path = item.picture;

                lyrFigure = new pp.LyrDetailImage(path);
            }
            else {
                var path = disc.getFigurePath(report.credibility < 70);
                var blendFunc = new cc.BlendFunc(cc.ZERO, cc.SRC_COLOR);

                lyrFigure = new pp.LyrDetailImage(path, blendFunc);
            }
            lyrFigure.attr({
                ignoreAnchor: false,
                x: lyrLetter.width + lyrFigure.width / 2 + 20,
                y: lyrLetter.height / 2
            });
            lyrLetter.attr({
                ignoreAnchor: false,
                x: lyrLetter.width / 2,
                y: lyrLetter.height / 2
            });

            subContent.addChild(lyrFigure);
            subContent.addChild(lyrLetter);
            subContent.width = lyrFigure.width + lyrLetter.width + 20;
            subContent.height = lyrLetter.height;
        }
        else {
            subContent = lyrLetter;
        }

        //ctor: function (caption, subContent, keyValues, callback, target, backOpacity, allowOverlap) {

        var keyVal = {};
        keyVal[__("種　別")] = disc.getTypeName();

        if (disc.type == pp.ttFigure || disc.type == pp.ttItem)
            keyVal[__("難易度")] = disc.engineering;

        if (disc.type == pp.ttThing)
            keyVal[__("重要度")] = disc.importance;

        if (disc.type == pp.ttFigure || disc.type == pp.ttTheory)
            keyVal[__("完成度")] = report.getCredibilityStr();

        keyVal[__("組　織")] = societyName;
        keyVal[__("支持率")] = backingStr;

        this._super(
            __("論文"),
            subContent,
            keyVal,
            null,
            callback,
            target,
            backOpacity,
            allowOverlap
        );
    }
});

pp.PopDetailSociety = pp.PopDetail.extend({

    ctor: function (societyId, callback, target, backOpacity, allowOverlap, options) {

        var society = pp.world.societies[societyId];
        var place = pp.world.places[society.placeId];

        var keyValues = {};

        keyValues[__("所　在　地")] = place.name;
        keyValues[__("権　　　威")] = society.authority;
        keyValues[__("所属科学者")] = society.getPersons().length + __("名", "");

        keyValues[society.jobName0] = society.job0PersonName;
        keyValues[society.jobName1] = society.job1PersonName;
        keyValues[society.jobName2] = society.job2PersonName;

        this._super(
            society.name,
            pp.createSpriteFromAtlas(pp.ATLAS_SOCIETY_M, null, tm.m(2, 1)),
            keyValues,
            null,
            callback,
            target,
            backOpacity,
            allowOverlap,
            options
        );
    }

});

pp.PopDetailPlace = pp.PopDetail.extend({

    ctor: function (placeId, callback, target, backOpacity, allowOverlap, options) {

        var place = pp.world.places[placeId];

        var societies = place.getSocieties();
        var universities = place.getUniversities();
        var observatories = place.getObservatories();

        var strSociety = societies.length ? societies[0].name : __("なし");
        var strUniv = universities.length ? universities[0].name : __("なし");
        var strObs = observatories.length ? observatories[0].name : __("なし");

        for (var i = 0; i < pp.world.societies.length; i++) {
            var society = pp.world.societies[i];
            if (society.placeId == placeId && society.exist)
                strSociety = society.name;
        }

        var keyValues = {};

        //keyValues[__("学　　術")] = place.science;
        keyValues[__("所在人物")] = place.getPersons().length + __("名", "", "");
        keyValues[__("所在組織")] = strSociety;
        keyValues[__("大　　学")] = strUniv;
        keyValues[__("天 文 台")] = strObs;

        this._super(
            place.name,
            null,
            keyValues,
            null,
            callback,
            target,
            backOpacity,
            allowOverlap,
            options
        );
    }

});

pp.PopDetailDiscovery = pp.PopDetail.extend({

    ctor: function (ids, callback, target) {

        var discId = ids[0];
        var personId = ids[1];
        var disc = pp.world.discoveries[discId];
        var person = pp.world.persons[personId];
        var theme = pp.world.themes[disc.themeId];

        var keyValues = {};
        var subLayer = null;
        var credibility = person.discCredibilities[discId];

        keyValues[__("内　容")] = tmi.titleize(disc.name);
        keyValues["---"] = "";
        keyValues[__("人　物")] = person.fullName;
        keyValues[__("テーマ")] = theme.name;
        keyValues[__("種　別")] = disc.getTypeName();
        keyValues[__("状　態")] = disc.getStatusStr(personId);

        if (disc.type == pp.ttTheory || disc.type == pp.ttFigure)
            keyValues[__("完成度")] = person.getDiscCredibilityStr(discId);

        if (disc.type == pp.ttTheory || disc.type == pp.ttThing || disc.type == pp.ttItem)
            keyValues[__("重要度")] = disc.importance;

        if (disc.type == pp.ttFigure || disc.type == pp.ttItem)
            keyValues[__("難易度")] = disc.engineering;

        if (disc.type == pp.ttFigure && credibility > 0) {
            var blendFunc = new cc.BlendFunc(cc.ZERO, cc.SRC_COLOR);
            subLayer = new pp.LyrDetailImage(disc.getFigurePath(credibility < 70), blendFunc);
        }

        if (disc.type == pp.ttItem && credibility > 0) {
            var item = pp.world.items[disc.itemId];
            subLayer = new pp.LyrDetailImage(item.picture);
        }

        //ctor: function (caption, subContent, keyValues, callback, target, backOpacity, allowOverlap, frameType, autoHeight) {

        this._super(
            __("発見情報"),
            subLayer,
            keyValues,
            null,
            callback,
            target,
            null,
            null,
            null,
            true);
    }

});

pp.PopDetailItem = pp.PopDetail.extend({

    ctor: function (ids, callback, target, backOpacity, frameType) {

        var itemId = ids[0];
        var personId = ids[1];
        var item = pp.world.items[itemId];
        var field = pp.world.fields[item.fieldId];

        var keyValues = {};
        if (pp.isIdValid(personId)) {
            keyValues[__("所有者")] = pp.world.persons[personId].fullName;
        }
        keyValues[__("効　果")] = field.name + " +" + item.gain;
        keyValues[__("価　格")] = item.price;

        this._super(
            "No." + (pp.libItem.idToSortedIdx(itemId)+1) + ": " + item.name,
            new pp.LyrDetailImage(item.picture),
            keyValues,
            item.note,
            callback,
            target,
            backOpacity,
            null,
            frameType
        );
    }

});

pp.PopDetailFigure = pp.PopDetail.extend({

    ctor: function (ids, callback, target, backOpacity) {

        var figId = ids[0];
        var score = ids[1];
        var figure = pp.figures[figId];
        var isPoor = false;
        var disc = pp.world.discoveries[figure.discId];

        if (score) {
            isPoor = score < 70;
        }

        var keyValues = {};

        var strName = __(figure.name + "の拡大図", "Enlarged view of " + __(figure.name), __(figure.name) + "的放大视图");

        keyValues[__("名　称")] = strName;
        keyValues[__("分　野")] = pp.world.fields[pp.fdBiology].name;
        keyValues[__("難易度")] = disc.engineering;

        if (score)
            keyValues[__("完成度")] = score;

        var blendFunc = new cc.BlendFunc(cc.ZERO, cc.SRC_COLOR);

        this._super(
            "No. " + (figId+1) + ": " + strName,
            new pp.LyrDetailImage(isPoor ? figure.poorPicture : figure.picture, blendFunc),
            keyValues,
            null,
            callback,
            target,
            backOpacity
        );
    }

});

pp.PopDetailCut = pp.Pop.extend({

    ctor: function (id, callback, target, backOpacity) {

        var cut = pp.cuts[id];

        var lyr = new cc.Layer();
        var spr = new cc.Sprite(cut.picture);
        spr.attr({
            scale: tm.m(2, 1),
            anchorX: 0.5,
            anchorY: 0
        });
        lyr.attr({
            width: spr.width * spr.scale - tm.m(30, 0),
            height: spr.height * spr.scale,
        });
        spr.x = lyr.width / 2;
        lyr.addChild(spr);

        this._super(
            lyr,
            "No. " + (id+1) + ": " + __(cut.name),
            pp.POP_FRM_NO_BUTTONS,
            callback,
            target,
            backOpacity,
            pp.POP_CAPTION_OUTSIDE
        );
    }

});

pp.PopDetailUniversity = pp.PopDetail.extend({

    ctor: function (univId, callback, target, backOpacity, allowOverlap, options) {

        var univ = pp.world.universities[univId];
        var place = pp.world.places[univ.placeId];

        var keyValues = {};

        keyValues[__("学　術")] = univ.science;
        keyValues[__("所在地")] = place.name;

        this._super(
            univ.name,
            pp.createSpriteFromAtlas(pp.ATLAS_UNIVERSITY_M, null, tm.m(2, 1)),
            keyValues,
            null,
            callback,
            target,
            backOpacity,
            allowOverlap,
            options
        );
    }

});

pp.PopDetailObservatory = pp.PopDetail.extend({

    ctor: function (obsId, callback, target, backOpacity, allowOverlap, options) {

        var obs = pp.world.observatories[obsId];
        var place = pp.world.places[obs.placeId];

        var keyValues = {};

        keyValues[__("所在地")] = place.name;
        keyValues[__("設　備" )] = obs.equipment;
        /*
        keyValues["---"] = "";
        keyValues[__("解　説")] = obs.note;
        */

        this._super(
            obs.name,
            pp.createSpriteFromAtlas(pp.ATLAS_OBSERBATORY_M, null, tm.m(2, 1)),
            keyValues,
            obs.note,
            callback,
            target,
            backOpacity,
            allowOverlap,
            options
        );
    }

});

