if (!tm.isMobile())
pp.PopListSelect = pp.Pop.extend({

    headerStrings: null,
    colWidths: null,
    textAligns: null,

    selectedIdx: 0,
    selectedTime: 0,
    sprOptionsss: null,
    sprHeaderss: null,
    sortingCol: 0,
    sortingPageIdx: 0,
    isSortDescend: true,
    sprTriangle: null,
    stringsss: null,

    scrViews: null,
    lyrPages: null,
    lyrBackground: null,
    selectedPage: 0,

    nodListening: null,
    myTouchPos: null,

    mnuPage: null,

    buildPage: function (pageIdx, headerStrings, colWidths, textAligns, aStringss) {

        var sprOptionss = [];
        var sprHeaders = [];
        var stringss = [];

        this.selectedIdx = pp.IDX_INVALID;
        this.isSortDescend = true;

        var lyrPage = new cc.LayerColor(cc.color(32,32,32));
        //var scrContent = new cc.LayerColor(cc.color.RED);
        var scrContent = new tm.Scale9SpriteTiled(res.Img_LyrDetailImage);

        //cc.log("buildPage called. pageIdx=" + pageIdx);

        var scrView = new pp.ScrollView();

        scrView.direction = cc.SCROLLVIEW_DIRECTION_VERTICAL;

        var scrContentWidth = 0;
        for (var i = 0; i < colWidths.length; i++) {
            scrContentWidth += colWidths[i];
        }
        var hasScrollBar = pp.ROW_HEIGHT * aStringss.length > pp.MAX_SCR_VIEW_HEIGHT;

        scrContent.setContentSize(scrContentWidth, pp.ROW_HEIGHT * aStringss.length);

        scrView.setContainer(scrContent);
        scrView.setViewSize(cc.size(scrContent.width, tm.min(scrContent.height, pp.MAX_SCR_VIEW_HEIGHT)));
        lyrPage.attr({
            width: scrContentWidth + (hasScrollBar ? pp.SCR_BAR_WIDTH : 0),
            height: scrView.getViewSize().height + pp.ROW_HEIGHT
        });

        if (hasScrollBar) {
            var scrBarRail = new pp.ScrorllBar(scrView);
            scrBarRail.attr({
                x: lyrPage.width,
                y: lyrPage.height - pp.ROW_HEIGHT
            });
            lyrPage.addChild(scrBarRail);
        }

        var y0 = scrContent.height + pp.ROW_HEIGHT;
        for (var iy = -1; iy < aStringss.length; iy++) {
            var isHeader = iy == -1;
            var strings = isHeader ? headerStrings : aStringss[iy];
            var x0 = 0;
            if (!isHeader) {
                sprOptionss.push([]);
                stringss.push([]);
            }

            for (var ix = 0; ix < strings.length; ix++) {
                var string = "" + strings[ix];

                if (headerStrings[ix] == "image") {
                    continue;
                }

                var lbl = new tm.LabelTTF(string, pp.font, __(18, 14));
                if (!isHeader) {
                    sprOptionss[iy].push(lbl);
                    stringss[iy].push(string);
                }

                var lbltextalign = isHeader ? cc.TEXT_ALIGNMENT_CENTER : textAligns[ix];

                switch (lbltextalign) {

                    case cc.TEXT_ALIGNMENT_LEFT: {
                        lbl.attr({
                            x: 10,
                            anchorX: 0
                        });
                        break;
                    }
                    case cc.TEXT_ALIGNMENT_RIGHT: {
                        lbl.attr({
                            x: colWidths[ix] - 10,
                            anchorX: 1
                        });
                        break;
                    }
                    case cc.TEXT_ALIGNMENT_CENTER: {
                        lbl.attr({
                            x: colWidths[ix] / 2,
                            anchorX: 0.5
                        });
                        break;
                    }
                }

                lbl.attr({
                    textAlign: lbltextalign,
                    y: pp.ROW_HEIGHT/2 - lbl.height/2,
                    anchorY: 0
                });
                lbl.setFontFillColor(isHeader ? cc.color.WHITE : cc.color(32,32,32));

                var spr2 = isHeader ? new cc.Scale9Sprite(res.Img_ListHeader) : new cc.Scale9Sprite(res.Img_ListCell);
                spr2.ignoreAnchor = true;
                spr2.setContentSize(colWidths[ix], pp.ROW_HEIGHT);

                //var spr = new cc.LayerColor(cc.color(255,96,96));
                var spr = new cc.LayerColor(cc.color.RED);
                spr.addChild(spr2);

                spr.attr({
                    ignoreAnchor: false,
                    x: x0,
                    y: isHeader ? lyrPage.height : y0,
                    anchorX: 0,
                    anchorY: 1,
                    opacity: 1
                });
                spr.setContentSize(colWidths[ix], pp.ROW_HEIGHT);
                spr.setCascadeColorEnabled(false);
                spr.addChild(lbl);
                if (isHeader) {
                    lyrPage.addChild(spr);
                    sprHeaders.push(spr);
                }
                else {
                    scrContent.addChild(spr);
                    sprOptionss[iy].push(spr);
                }

                x0 += spr.width;
            }

            y0 -= pp.ROW_HEIGHT;

            if (!isHeader)
                stringss[iy].push(iy); // for focusedRealIdx
        }

        lyrPage.addChild(scrView);
        scrView.setContentOffset(scrView.minContainerOffset());

        this.sprHeaderss.push(sprHeaders);
        this.sprOptionsss.push(sprOptionss);
        this.stringsss.push(stringss);
        this.scrViews.push(scrView);

        return lyrPage;
    },

    ctor: function (headerStrings, colWidths, textAligns, stringss, caption, callback, target, backOpacity, allowOverlap) {

        this._name = "PopListSelect";

        this.sprOptionsss = [];
        this.stringsss = [];
        this.sprHeaderss = [];
        this.lyrPages = [];
        this.scrViews = [];
        this.sortingColIdx = pp.idxInvalid;
        this.sortingPageIdx = pp.idxInvalid;

        if (!cc.isArray(headerStrings[0])) {

            headerStrings = [headerStrings, ["A"]];
            colWidths = [colWidths];
            textAligns = [textAligns];
            stringss = [stringss];
        }

        var maxWidth = 0;
        var maxHeight = 0;
        var lyrBackground = new cc.Layer();
        for (var iPage = 0; iPage < colWidths.length; iPage++) {

            var lyrPage = this.buildPage(iPage, headerStrings[iPage], colWidths[iPage], textAligns[iPage], stringss[iPage]);

            maxWidth = tm.max(maxWidth, lyrPage.width);
            maxHeight = tm.max(maxHeight, lyrPage.height);

            lyrBackground.addChild(lyrPage);

            this.lyrPages.push(lyrPage);
        }
        lyrBackground.setContentSize(maxWidth, maxHeight);
        this.lyrBackground = lyrBackground;

        //@@@pp.Pop_needSwallow = false;

        this._super(lyrBackground,
            caption,
            pp.POP_FRM_OK_CANCEL_BUTTONS,
            function (sel) {
                if (sel == pp.POP_WAS_OK) {
                    var a = this.stringsss[this.getVisiblePage()][this.selectedIdx];
                    sel = a[a.length-1];
                }
                callback.call(target, sel);
            },
            this,
            backOpacity,
            pp.POP_CAPTION_INSIDE,
            allowOverlap
        );

        pp.Pop_needSwallow = true;

        if (this.lyrPages.length > 1) {
            //    ctor: function (strings, callback, target, isRadio, tint, isVertical, span, xMagnitude, barVal, isFlat)

            var mnu = new pp.MenuRect(
                headerStrings[headerStrings.length-1],
                function (item) {
                    pp.mediator.playSound(res.Snd_Click);
                    this.setVisiblePage(item.tag);
                },
                this,
                true,
                cc.color(148,148,48),
                false,
                0,
                0.5
            );
            mnu.attr({
                anchorX: 1,
                anchorY: 1,
                x: this.frame0.width - 30,
                y: this.frame0.height - 20
            });
            this.mnuPage = mnu;
            this.setSelectedIndex(0);
            this.frame0.addChild(mnu);
        }

        this.setSelected(0);

        this.nodListening = new cc.Node();
        this.addChild(this.nodListening, 10);

        this._name = "PopListSelect";
    },

    setSelectedIndex: function (idx) {
        this.setVisiblePage(idx);
        //this.mnuPage.setSelectedIndex(idx);
    },

    setVisiblePage: function (idx) {

        if (this.lyrPages.length == 1) return;

        if (idx == this.getVisiblePage()) return;

        this.scrViews[idx].setContentOffset(
            this.scrViews[this.getVisiblePage()].getContentOffset()
        );

        this.mnuPage.setSelectedIndex(idx);
        for (var i = 0; i < this.lyrPages.length; i++) {
            this.lyrPages[i].visible = idx == i;
        }
    },

    getVisiblePage: function () {

        if (this.lyrPages.length == 1) return 0;

        return this.mnuPage.getSelectedIndex();
    },

    onEnter: function () {

        // Add Click Event Handler
        if (this.nodListening)
        {

            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: false,
                    onTouchBegan: this.onMyTouchBegan,
                    onTouchMoved: function (touch, event) { },
                    onTouchEnded: this.onMyTouchEnded,
                    onTouchCancelled: function (touch, event) { }
                }),
                this.nodListening
            );


            // Swallow here (After Scroll View). Beware that priorities are based on nodes
            /*
            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: true,
                    onTouchBegan: function (touch, event) {
                        cc.log("SWL!");
                        return true; },
                    onTouchMoved: function (touch, event) { },
                    onTouchEnded: function (touch, event) { },
                    onTouchCancelled: function (touch, event) { }
                }),
                this
            );
            */
        }

        this._super();
    },

    setSelectedByUi: function (idx) {
        //cc.log(">> PopListSelect: setSelectedByUi called. idx = " + idx);
        var delta = Date.now() - this.selectedTime;
        this.selectedTime = Date.now();

        if (delta < 400 && idx == this.selectedIdx) {
            var a = this.stringsss[this.getVisiblePage()][idx];
            this.didGetSelection(a[a.length-1]);
        }

        if (idx != this.selectedIdx) {
            pp.mediator.playSound(res.Snd_Click);
        }

        this.setSelected(idx);
    },

    setSelected: function (idx) {

        if (idx == this.selectedIdx) {
            return;
        }

        var nPages = this.sprOptionsss.length;

        for (var iPage = 0; iPage < nPages; iPage++) {

            var sprOptionss = this.sprOptionsss[iPage];

            var selectedOptions = sprOptionss[idx];
            selectedOptions.forEach(function (spr) {
                if (spr.setFontFillColor) {
                    spr.setFontFillColor(cc.color.WHITE);
                    //spr._setUpdateTextureDirty(); // for Canvas render mode
                }
                else if (spr instanceof cc.Layer) {
                    spr.opacity = 128;
                }
            });

            this.scrViews[this.getVisiblePage()].scrollToShowNode(selectedOptions[1]);

            if (this.selectedIdx != pp.IDX_INVALID) {

                var unselectedOptions = sprOptionss[this.selectedIdx];
                unselectedOptions.forEach(function (spr) {
                    if (spr.setFontFillColor) {
                        spr.setFontFillColor(cc.color.BLACK);
                        //spr._setUpdateTextureDirty(); // for Canvas render mode
                    }
                    else if (spr instanceof cc.Layer) {
                        spr.opacity = 1;
                    }
                });
            }
        }

        this.selectedIdx = idx;
    },

    didGetSelection: function (sel) {
        if (sel == pp.POP_WAS_CANCEL) {
            pp.mediator.playSound(res.Snd_Cancel);
        }
        else {
            pp.mediator.playSound(res.Snd_Click);
        }
        this._super(sel);
    },

    onMyTouchBegan: function (touch, event) {

        var node = event.getCurrentTarget().getParent();
        var touchPos = tm.getTouchPos(touch);

        var layer = node.lyrBackground;
        if (tm.isInside(touchPos, layer)) {

            node.myTouchPos = touchPos;
            return true;
        }

        return false;
    },

    onMyTouchEnded: function (touch, event) {

        var node = event.getCurrentTarget().getParent();
        var touchPos = tm.getTouchPos(touch);
        var pageIdx = node.getVisiblePage();

        //cc.log("PopListSelect: Touched.touchPos=(" + touchPos.x + ", " + touchPos.y + ")");

        var dist = Math.abs(touchPos.x -node.myTouchPos.x) + Math.abs(touchPos.y-node.myTouchPos.y);
        if (dist > 3) {
            // Ignore dragging
            return false;
        }

        var sprHeaders = node.sprHeaderss[pageIdx];

        for (var i = 0; i < sprHeaders.length; i++) {
            var sprHeader = sprHeaders[i];

            if (tm.isInside(touchPos, sprHeader)) {

                //*** Header was clicked

                var isSortDescend = true;
                if (node.sortingColIdx == i && node.sortingPageIdx == pageIdx) {
                    isSortDescend = node.isSortDescend == false;
                }

                pp.mediator.playSound(res.Snd_Click);

                node.sortByCol(pageIdx, i, isSortDescend);

                //cc.log("HEADER" + i + " clicked! isSortDescend=" + isSortDescend);
                return true;
            }
        }

        var scrView = node.scrViews[pageIdx];
        if (tm.isInside(touchPos, scrView)) {
            var y = scrView.height - (touchPos.y - scrView.convertToWorldSpace().y);
            var scrY = scrView.getContentSize().height - scrView.height + scrView.getContentOffset().y;
            var iy = tm.int((y + scrY) / pp.ROW_HEIGHT);

            node.setSelectedByUi(iy);
            //cc.log("ROW: clicked! y=" + y + ", iy =" + iy); //@@@
            return true;
        }

        return false;
    },

    sortByCol: function (visiblePageIdx, colIdx, isSortDescend) {

        var nPages = this.stringsss.length;
        var nRows = this.stringsss[0].length;

        //--- Save focused row
        var strings = this.stringsss[0][this.selectedIdx];
        var focusedRealIdx = strings[strings.length-1];

        //--- Update triangle
        if (this.sprTriangle == null) {
            this.sprTriangle = new cc.Sprite(res.Img_ListTriangleDown);
            this.sprTriangle.attr({
                anchorX: 1,
                anchorY: 0.5,
                y: pp.ROW_HEIGHT / 2
            });
        }
        else {
            this.sprTriangle.removeFromParent(false);
        }
        this.sprTriangle.scaleY = isSortDescend ? 1 : -1;
        this.sprHeaderss[visiblePageIdx][colIdx].addChild(this.sprTriangle);
        this.sprTriangle.x = this.sprHeaderss[visiblePageIdx][colIdx].width - 4;

        this.sortingColIdx = colIdx;
        this.sortingPageIdx = visiblePageIdx;
        this.isSortDescend = isSortDescend;

        //--- Sort

        // Push other tables to the visible page
        for (var iPage = 0; iPage < nPages; iPage++) {
            if (iPage == visiblePageIdx) continue;

            for (var iy = 0; iy < nRows; iy++) {
                var toPushTo = this.stringsss[visiblePageIdx][iy];
                var toPush = this.stringsss[iPage][iy];
                this.stringsss[visiblePageIdx][iy].push(this.stringsss[iPage][iy]);
            }
        }

        //--- Sort
        this.stringsss[visiblePageIdx].sort(function (stringsA, stringsB) {
            var a = stringsA[colIdx];
            var b = stringsB[colIdx];
            var ret = 0;

            if (a == "Ｓ") {
                ret = b == "Ｓ" ? 0 : -1;
            }
            else if (b == "Ｓ") {
                ret = 1;
            }
            else if (tm.isNumber(a)) {
                ret = a - b;
            }
            else {
                if (a > b) ret = 1; else if (a < b) ret = -1; else ret = 0;
            }

            if (!isSortDescend)
                ret = -ret;

            //cc.log("a=" + a + ", b=" + b + ", isSortDescend=" + isSortDescend + ", ret=" + ret);
            return ret;
        });

        // Pop appended table
        for (var iPage = nPages-1; iPage >= 0; iPage--) {
            if (iPage == visiblePageIdx) continue;

            for (var iy = 0; iy < nRows; iy++) {
                var popped = this.stringsss[visiblePageIdx][iy].pop()
                this.stringsss[iPage][iy] = popped;
            }
        }

        //--- Update labels
        for (var iPage = 0; iPage < nPages; iPage++) {
            for (var iy = 0; iy < nRows; iy++) {
                var sprOptions = this.sprOptionsss[iPage][iy];

                for (var ix = 0; ix < sprOptions.length / 2; ix++) {
                    var sprOption = sprOptions[ix * 2];
                    sprOption.string = this.stringsss[iPage][iy][ix];
                }
            }
        }

        //--- Restore focused row
        for (var iy = 0; iy < nRows; iy++) {
            var strings = this.stringsss[0][iy];
            if (focusedRealIdx == strings[strings.length-1]) {
                this.setSelected(iy);
                break;
            }
        }
    }

});

