
pp.PopVoice = pp.Pop.extend({

    lblVoice: null,
    sprVoice: null,
    voices: null,
    isVoiceLeft: true,

    ctor: function (personIds, image, voices, caption, callback, target, backOpacity, allowOverlap) {

        this.isVoiceLeft = true;

        var personId0 = cc.isArray(personIds) ? personIds[0] : personIds;
        var personId1 = cc.isArray(personIds) ? personIds[1] : pp.ID_INVALID;

        //backOpacity = backOpacity || 1;
        var content = new cc.Layer(); //Color(cc.color.RED);

        var sprVoice = this.sprVoice = new tm.Scale9SpriteTiled(tm.m(res.Img_LyrBalloonUnder, res.Img_LyrBalloon));

        var person0 = pp.world.persons[personId0];
        var sprFace0 = new cc.Sprite(person0.getImageFileName());
        sprFace0.scale = tm.m(2, 1);
        sprFace0.width *= sprFace0.scale;
        sprFace0.height *= sprFace0.scale;
        sprFace0.texture.setAliasTexParameters();
        sprFace0.anchorX = 0;
        sprFace0.anchorY = 0;

        var lyrFace0 = new cc.LayerColor(cc.color.WHITE, sprFace0.width, sprFace0.height);
        var sprFrmFace0 = new tm.Scale9SpriteTiled(res.Img_FrmFace);
        sprFrmFace0.setContentSize(22+sprFace0.width, 22+sprFace0.height);

        var lblFName0 = new tm.LabelTTF(person0.firstName, pp.font, tm.m(__(30, 27), __(20, 18)), cc.color.BLACK);
        var lblLName0 = new tm.LabelTTF(person0.lastName, pp.font, tm.m(__(30, 27), __(20, 18)), cc.color.BLACK);

        var voice;
        if (cc.isArray(voices)) {
            voice = voices[0];
            this.voices = voices;
        }
        else {
            voice = voices;
            this.voices = [voices];
        }
        if (voice.substr(0, 1) == "@") {
            this.isVoiceLeft = false;
            voice = voice.substr(1);
        }
        else {
            this.isVoiceLeft = true;
        }

        var lblVoice = this.lblVoice = new cc.LabelTTF(voice, pp.font, tm.m(__(30, 24), __(20, 16)));
        lblVoice.setDimensions(cc.size(tm.m(560, 440), 0));

        content.addChild(sprVoice);
        content.addChild(lblVoice);

        content.addChild(sprFrmFace0);
        sprFrmFace0.addChild(lyrFace0);
        lyrFace0.addChild(sprFace0);
        content.addChild(lblFName0);
        content.addChild(lblLName0);

        var person1, sprFace1, lyrFace1, sprFrmFace1, lblFName1, lblLName1;
        if (personId1 != pp.ID_INVALID) {
            person1 = pp.world.persons[personId1];
            sprFace1 = new cc.Sprite(person1.getImageFileName());
            sprFace1.scale = tm.m(2, 1);
            sprFace1.width *= sprFace1.scale;
            sprFace1.height *= sprFace1.scale;
            if (sprFace1.textureLoaded())
                sprFace1.texture.setAliasTexParameters();
            sprFace1.anchorX = 0;
            sprFace1.anchorY = 0;

            lyrFace1 = new cc.LayerColor(cc.color.WHITE, sprFace0.width, sprFace0.height);
            sprFrmFace1 = new tm.Scale9SpriteTiled(res.Img_FrmFace);
            sprFrmFace1.setContentSize(22+sprFace1.width, 22+sprFace1.height);

            lblFName1 = new tm.LabelTTF(person1.firstName, pp.font, tm.m(__(30, 27), __(20, 18)), cc.color.BLACK);
            lblLName1 = new tm.LabelTTF(person1.lastName, pp.font, tm.m(__(30, 27), __(20, 18)), cc.color.BLACK);

            content.addChild(sprFrmFace1);
            sprFrmFace1.addChild(lyrFace1);
            lyrFace1.addChild(sprFace1);
            content.addChild(lblFName1);
            content.addChild(lblLName1);
        }

        if (tm.m())
            sprVoice.setContentSize(600, 200);

        content.width = sprVoice.width + 4 + tm.m(0, sprFrmFace0.width + (personId1 == pp.ID_INVALID ? 0 : 30 + sprFrmFace1.width));
        content.height = sprFrmFace0.height + lblFName0.height + lblLName0.height + 5 + tm.m(sprVoice.height, 0);

        sprVoice.attr({
            x: tm.m(0, sprFrmFace0.width + 4),
            y: content.height,
            anchorX: 0,
            anchorY: 1
        });
        lblVoice.attr({
            x: sprVoice.x + tm.m(20, 43),
            y: sprVoice.y - 15,
            anchorX: 0,
            anchorY: 1,
            textAlign: cc.TEXT_ALIGNMENT_LEFT
        });
        lblVoice.setFontFillColor(cc.color.BLACK);

        if (!this.isVoiceLeft) {
            sprVoice.scaleX = -1;
            sprVoice.x += sprVoice.width * tm.m(1, 1.05);
        }


        {
            lyrFace0.attr({
                ignoreAnchor: false,
                x: sprFrmFace0.width/2,
                y: sprFrmFace0.height/2
            });

            sprFrmFace0.attr({ y: lblFName0.height + lblLName0.height + 5, anchorX: 0, anchorY: 0 });
            lblFName0.attr({ x: sprFrmFace0.width / 2, y: lblLName0.height, anchorY: 0 });
            lblFName0.setFontFillColor(cc.color(220, 220, 160));

            lblLName0.attr({ x: sprFrmFace0.width / 2, anchorY: 0 });
            lblLName0.setFontFillColor(cc.color(220, 220, 160));

        }

        if (personId1 != pp.ID_INVALID)
        {
            lyrFace1.attr({
                ignoreAnchor: false,
                x: sprFrmFace1.width/2,
                y: sprFrmFace1.height/2
            });

            sprFace1.attr({ ignoreAnchor: true });
            sprFrmFace1.attr({ x: content.width, y: lblFName1.height + lblLName1.height + 5, anchorX: 1, anchorY: 0 });
            lblFName1.attr({ x: sprFrmFace1.x - sprFrmFace1.width / 2, y: lblLName1.height, anchorY: 0 });
            lblFName1.setFontFillColor(cc.color(220, 220, 160));

            lblLName1.attr({ x: sprFrmFace1.x - sprFrmFace1.width / 2, anchorY: 0 });
            lblLName1.setFontFillColor(cc.color(220, 220, 160));

        }

        var sprImage;
        if (image) {
            sprImage = new cc.Sprite(image);
            sprImage.scale = tm.m(2, 1);
            sprImage.width *= sprImage.scale;
            sprImage.height *= sprImage.scale;
            sprImage.anchorX = 0;
            sprImage.anchorY = 0;
            sprImage.texture.setAliasTexParameters();
        }

        this._super(
            image ? [content, sprImage] : content,
            caption,
            pp.POP_FRM_NO_BUTTONS,
            callback,
            target,
            backOpacity,
            tm.m(pp.POP_CAPTION_OUTSIDE, pp.POP_CAPTION_OUTSIDE),
            allowOverlap,
            pp.POP_ANIME_VOICE_IMAGE
        );

    },

    getVoiceLength: function () {
        return this.voices.length;
    },

    doNextAnimeForVoice: function (stage) {

        this.lblVoice.string = "";

        var voice = this.voices[stage];
        var scaleX0 = this.sprVoice.scaleX;
        var scaleX1 = scaleX0 * 0.2;
        var scaleX2 = 1;
        var x2 = tm.m(0, this.lblVoice.x - 35);
        this.isVoiceLeft = true;
        if (voice.substr(0, 1) == "@") {
            this.isVoiceLeft = false;
            voice = voice.substr(1);
            scaleX2 = -1;
            x2 += this.sprVoice.width + tm.m(0, 15);
        }

        this.sprVoice.runAction(
            cc.sequence(
                cc.callFunc(function () {
                    pp.mediator.uiRemoveClickMark();
                }),
                cc.scaleTo(0.2, scaleX1, 1),
                cc.moveTo(0.01, x2, this.sprVoice.y),
                cc.scaleTo(0.2, scaleX2, 1),
                cc.callFunc(function () {

                    if (stage < this.voices.length - 1) {
                        pp.mediator.uiShowClickMark(this.sprVoice, pp.clmMore, cc.color.BLACK, cc.p(this.sprVoice.scaleX < 0 ? -20 : 0, 0));
                    }
                    else {
                        pp.mediator.uiShowClickMark(this.frame0, this.allowOverlap ? pp.clmMore : pp.clmCleanup);
                    }

                    this.lblVoice.string = voice;
                }, this)
            )
        );

        this.isDemoDone = false;
        this.scheduleOnce(function () { this.isDemoDone = true; }, 0.3 );
    }

});
