
pp.Scn = cc.Scene.extend({

    lyrDarkWall: null,
    lyrModeIndicator: null,
    act800ms: null,
    lyrStatusBar: null,

    ctor: function () {
        this._super();

        this.lyrStatusBar = new pp.LyrStatusBar();
        this.addChild(this.lyrStatusBar, 200);

        this.lyrDarkWall = new cc.LayerColor(cc.color.BLACK);
        this.addChild(this.lyrDarkWall, 99);
        this.lyrDarkWall.opacity = 0;

        this.attr({
            width: cc.winSize.width,
            height: cc.winSize.height
        });

        this.act800ms = cc.delayTime(0.8);
        this.runAction(cc.repeatForever(this.act800ms));

        {
            var lyr = new pp.LyrModeIndicator();
            lyr.attr({x: tm.m(0, 10), y: this.height - tm.m(pp.LYR_STATUS_BAR_HEIGHT, 10)});
            this.addChild(lyr, 300);
            this.lyrModeIndicator = lyr;
            lyr.setActionToSync(this.act800ms);
        }

        {
            this.listener = cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: false,
                    onTouchBegan: function (touch, event) {
                        //var node = event.getCurrentTarget();
                        var pos = tm.getTouchPos(touch);
                        pp.mediator.lastClickPos = pos;
                        //cc.log("TOUCH POS=(" + pos.x + ", " + pos.y + ")");
                        return false;
                    },
                    onTouchMoved: function () { return; },
                    onTouchCancelled: function () { return; },
                    onTouchEnded: function (touch, event) {}
                }),
                this.lyrDarkWall
            );
        }

    },

    onEnterTransitionDidFinish: function () {
        pp.mediator.suiDidAnime();
    },

    uiUpdate: function () {
        this.lyrModeIndicator.uiUpdate();
    }

});
