
pp.SCN_GAME_SELECT_PLAYER = 0;
pp.SCN_GAME_MAIN = 1;

pp.ScnGame = pp.Scn.extend({

    frmDate: null,
    frmCommand: null,
    frmPerson: null,
    frmLog: null,
    frmPager: null,

    lyrMap: null,
    lyrControl: null,
    lyrSystemMenu: null,
    lyrPerson: null,

    ctor: function (mode) {
        this._super();

        this._name = "ScnGame";

        // Background Image
        {
            this.lyrMap = new pp.LyrMap(this.onDidMapClick, this);
            this.addChild(this.lyrMap, 0);
        }

        this.frmDate = new pp.FrmDate();
        this.addChild(this.frmDate, 4);
        this.frmDate.onDidSetSizeAndParent();
        this.frmDate.show();

        if (!tm.m())
        {
            this.frmPerson = new pp.FrmPerson();
            this.addChild(this.frmPerson, 4);
            this.frmPerson.onDidSetSizeAndParent();
            this.frmPerson.y += 80; //@@@
            this.frmPerson.savePos();
            this.frmPerson.hide();
        }

        {
            this.frmLog = new pp.FrmLog();
            this.addChild(this.frmLog, 4);
            this.frmLog.onDidSetSizeAndParent();
            this.frmLog.show();
        }

        {
            this.frmCommand = new pp.FrmCommand();
            this.addChild(this.frmCommand, 4);
            this.frmCommand.onDidSetSizeAndParent();
            this.frmCommand.hide();
        }

        {
            var frm = this.frmPager = new pp.FrmPager();
            frm.attr({
                ignoreAnchor: false,
                anchorX: tm.m(0, 1),
                anchorY: tm.m(0, 1),
                x: tm.m(0, this.width - 1),
                y: tm.m(0, this.height - 1)
            });
            this.addChild(frm, tm.m(4, 3));
        }

        this.setMode(mode || pp.SCN_GAME_SELECT_PLAYER); //pp.SCN_GAME_SELECT_PLAYER);
    },

    onEnter:function () {
        this._super();

        if (this.frmDate)
            this.frmDate.updateLabels();

        if ((!pp.mediator.isDemo || pp.mediator.gameState == pp.gsSelectPlayer) && this.frmPager)
            this.frmPager.menu.setSelectedIndex(pp.PG_MAP);
    },

    onEnterTransitionDidFinish: function () {

        this._super();
    },

    setMode: function (scnMode) {

        switch (scnMode) {
            case pp.SCN_GAME_SELECT_PLAYER:
                this.frmCommand.visible = false;
                if (this.frmPerson) this.frmPerson.visible = false;
                this.frmLog.visible = false;
                break;

            default:
            case pp.SCN_GAME_MAIN:
                this.frmCommand.visible = true;
                if (this.frmPerson) this.frmPerson.visible = true;
                this.frmLog.visible = true;
                break;
        }

    },

    uiUpdate: function () {
        this._super();

        if (this.frmDate)
            this.frmDate.updateLabels();

        if (this.frmPerson)
            this.frmPerson.setPersonId(pp.mediator.personId);

        //this.frmCommand.uiUpdate();

        if (this.frmPager)
            this.frmPager.uiUpdate();
    },

    onDidMapClick: function (item) {
        pp.mediator.playSound(res.Snd_Click);

        pp.mediator.suiDidGetUserInput(item.tag);
    }


});


