
pp.FrmItem = pp.Frm.extend({

    ctor: function (itemSortedIdx, locked) {

        //this._super(res.Img_FrmDate);
        this._super(tm.m(res.Img_FaceEmpty, res.Img_FrmSimple256x256));
        this.lyrShadow.opacity = 0;

        var NX = tm.m(5,8);
        var NY = tm.m(7,4);
        var ix = itemSortedIdx % NX;
        var iy = NY - 1 - Math.floor(itemSortedIdx / NX);

        this.attr({
            ignoreAnchor: false,
            x: 10 + ((cc.winSize.width-20)/NX) * (ix + 0.5),
            y: 80 + ((cc.winSize.height-40)/NY-tm.m(24, 28)) * (iy + 0.5)
        });

        this.setContentSize(cc.winSize.width/NX-10, cc.winSize.height/NY-tm.m(30,50));

        var item = pp.libItem.getSortedItems()[itemSortedIdx];
        var itemId = item.id;

        // Item
        {
            var lyrItmButton = new pp.LyrImagedButton(item.picture, "No."+(itemSortedIdx+1), null, function () {
                pp.mediator.scn.addChild(
                    new pp.PopDetailItem([itemId, pp.idInvalid], null, null, 128),
                    100);
            }, this, locked, -20);
            lyrItmButton.attr({
                ignoreAnchor: false,
                x: this.width / 2,
                y: this.height / 2 - 2
            });
            this.addChild(lyrItmButton);
        }
    }
});

//---

pp.FrmFigure = tm.Scale9SpriteTiled.extend({

    ctor: function (figureId, locked) {

        this._super(res.Img_FrmDate);

        var NX = tm.m(4, 5);
        var NY = 3;
        var ix = figureId % NX;
        var iy = NY - 1 - Math.floor(figureId / NX);

        this.attr({
            ignoreAnchor: false,
            x: 10 + ((cc.winSize.width-20)/NX) * (ix + 0.5),
            y: tm.m(70, 90) + ((cc.winSize.height-80)/NY-tm.m(40, 26)) * (iy + 0.5)
        });

        this.setContentSize(cc.winSize.width/NX-30, cc.winSize.height/NY-tm.m(120, 80));

        // Figures
        {
            var lyrFigButton = new pp.LyrImagedButton(pp.figures[figureId].picture, "No."+(figureId+1), null, function () {
                pp.mediator.scn.addChild(
                    new pp.PopDetailFigure([figureId, 0], null, null, 128),
                    100);
            }, this, locked);
            lyrFigButton.attr({
                ignoreAnchor: false,
                x: this.width / 2,
                y: this.height / 2 - 2
            });
            this.addChild(lyrFigButton);
        }
    }
});

//---

pp.FrmCut = pp.Frm.extend({

    ctor: function (cutId, locked) {

        this._super(res.Img_FrmDate);

        var NX = tm.m(5, 6);
        var NY = tm.m(4, 3);
        var ix = cutId % NX;
        var iy = NY - 1 - Math.floor(cutId / NX);

        this.attr({
            ignoreAnchor: false,
            x: 10 + ((cc.winSize.width-20)/NX) * (ix + 0.5),
            y: 90 + ((cc.winSize.height-80)/NY-tm.m(40,26)) * (iy + 0.5)
        });

        this.setContentSize(cc.winSize.width/NX-tm.m(10, 30), cc.winSize.height/NY-tm.m(90, 80));

        // Cuts
        {
            var lyrCutButton = new pp.LyrImagedButton(pp.cuts[cutId].picture, "No."+(cutId+1), null, function () {
                pp.mediator.scn.addChild(
                    new pp.PopDetailCut(cutId, null, null, 128),
                    100);
            }, this, locked);
            lyrCutButton.attr({
                ignoreAnchor: false,
                x: this.width / 2,
                y: this.height / 2 - 2
            });
            this.addChild(lyrCutButton);
        }
    }
});
//----------------------------------------------------------------------

pp.ScnLibrary = pp.Scn.extend({

    lyrSub: null,
    lblCaption: null,
    lblBottom: null,
    subPageIdx: 0,
    subPageFuncs: null,

    ctor: function () {

        this._super();

        this._name = "ScnLibrary";

        this.lyrSub = null;
        this.subPageIdx = 0;
        this.subPageFuncs = [
            this.setSubPageForItems,
            this.setSubPageForFigures,
            this.setSubPageForCuts
        ];

        // Caption
        var frmCaption;
        {
            frmCaption = new pp.FrmCaption("－－－－－－", 120);
            frmCaption.attr({
                ignoreAnchor: false,
                anchorX: 0.5,
                anchorY: 1,
                x: tm.m(1, 15) + frmCaption.width / 2,
                y: this.height - tm.m(pp.LYR_STATUS_BAR_HEIGHT + 1, 10)
            });
            this.addChild(frmCaption, 1);
            this.lblCaption = frmCaption.layer.label;
        }

        //Top Frame
        var frmTop;
        if (!tm.m())
        {
            frmTop = new tm.Scale9SpriteTiled(res.Img_FrmCommand);
            frmTop.setContentSize(this.width - frmCaption.width - 30 - 30, 64);
            frmTop.attr({
                ignoreAnchor: false,
                anchorY: 1,
                anchorX: 1,
                x: this.width - 15,
                y: this.height - 10
            });
            this.addChild(frmTop, 1);
        }

        //Bottom Frame
        var frmBottom;
        {
            frmBottom = new tm.Scale9SpriteTiled(res.Img_FrmCommand);
            frmBottom.setContentSize(this.width - tm.m(2, 30), 64);
            frmBottom.attr({
                ignoreAnchor: false,
                anchorY: 0,
                anchorX: 0.5,
                x: this.width/2,
                y: tm.m(0, 10)
            });
            this.addChild(frmBottom, 1);
        }

        // Info Message
        {
            var lbl = new tm.LabelTTF("", pp.font, 20, cc.color.BLACK, cc.color.YELLOW);
            lbl.attr({
                anchorY: 0.5,
                anchorX: 0.5,
                x: frmBottom.width/2,
                y: frmBottom.height/2
            });
            frmBottom.addChild(lbl);
            this.lblBottom = lbl;
        }

        // Paging menu
        var mnuPage;
        {
            //ctor: function (strings, callback, target, isRadio, tint, isVertical, span, xMagnitude)

            mnuPage = new pp.MenuRect(
                ["<<", ">>", __("戻る") ],
                function (itm) {

                    if (itm.tag == 2) {
                        this.didGetUserInput();
                    }
                    else {

                        this.subPageIdx = (this.subPageIdx + (itm.tag == 0 ? this.subPageFuncs.length - 1 : 1)) % this.subPageFuncs.length;

                        this.setSubPageIndex(this.subPageIdx);

                        pp.ScnLibrary.prevPageIdx = this.subPageIdx;

                        pp.mediator.playSound(res.Snd_Click);
                    }
                },
                this,
                false,
                cc.color(128, 128, 0),
                false,
                tm.m(8, 20),
                tm.m(0.5, 1.5)
            );

            if (tm.m()) {
                mnuPage.attr({
                    anchorX: 1,
                    anchorY: 1,
                    x: this.width - 8,
                    y: this.height - 3 - pp.LYR_STATUS_BAR_HEIGHT
                });
                this.addChild(mnuPage, 2);
            }
            else {
                mnuPage.attr({
                    anchorX: 0.5,
                    anchorY: 0.5,
                    x: frmTop.width/2,
                    y: frmTop.height/2
                });
                frmTop.addChild(mnuPage);
            }
        }

        this.setSubPageIndex(pp.ScnLibrary.prevPageIdx);

        // Background
        {
            var sprWall = new cc.Sprite(res.Img_FullRoom);
            sprWall.attr({
                anchorX: 0,
                anchorY: 0,
                scale: tm.m(2, 1)
            });
            this.addChild(sprWall, 0);

            var sprStars = new cc.Sprite(res.Img_UnvStars);
            sprStars.attr({
                x: this.width / 2,
                y: this.height / 2
            });
            this.addChild(sprStars, 0);

            sprStars.runAction(
                cc.rotateBy(16000, 36000*2)
            );
        }
    },

    setSubPageIndex: function (index) {

        if (this.lyrSub) {
            this.lyrSub.removeFromParent();
        }

        this.lyrSub = new cc.Layer();
        this.addChild(this.lyrSub, 1);

        this.subPageFuncs[index].call(this);
    },

    setSubPage: function (pageIdx, caption, unlockedNum, totalNum) {

        this.lblCaption.string = "" + (pageIdx + 1) + "." + __(caption);

        var ratioStr = "" + Math.floor(unlockedNum / totalNum * 100);
        var pageNum = this.subPageFuncs.length;

        this.lblBottom.string =
            __("達成率") + ": " + ratioStr + "% ( " + unlockedNum + " / " + totalNum + " )" +
            " － [" + __("ページ") + " " + (pageIdx + 1) + __("/", " of ") + pageNum + "]";
    },

    setSubPageForItems: function () {

        // Items
        var sortedItems = pp.libItem.getSortedItems();
        for (var i = 0; i < sortedItems.length; i++) {
            var frm = new pp.FrmItem(i, pp.libItem.isSortedItemLocked(i) && !pp.mediator.isCheckingText);
            this.lyrSub.addChild(frm, 1);
        }

        var unlockedNum = 0;
        for (var i = 0; i < pp.libItem.unlockeds.length; i++)
            if (pp.libItem.isUnlocked(i)) unlockedNum++;

        this.setSubPage(0, "アイテム図鑑", unlockedNum, pp.libItem.unlockeds.length);
    },

    setSubPageForFigures: function () {

        // Figures
        for (var i = 0; i < pp.figures.length; i++) {
            var frm = new pp.FrmFigure(i, pp.libFigure.isLocked(i) && !pp.mediator.isCheckingText);
            this.lyrSub.addChild(frm, 1);
        }

        var unlockedNum = 0;
        for (var i = 0; i < pp.libFigure.unlockeds.length; i++)
            if (pp.libFigure.isUnlocked(i)) unlockedNum++;

        this.setSubPage(1, "スケッチ図鑑", unlockedNum, pp.libFigure.unlockeds.length);
    },

    setSubPageForCuts: function () {

        // Cuts
        for (var i = 0; i < pp.cuts.length; i++) {
            var frm = new pp.FrmCut(i, pp.libCut.isLocked(i) && !pp.mediator.isCheckingText);
            this.lyrSub.addChild(frm, 1);
        }

        var unlockedNum = 0;
        for (var i = 0; i < pp.libCut.unlockeds.length; i++)
            if (pp.libCut.isUnlocked(i)) unlockedNum++;

        this.setSubPage(2, "イベント絵図鑑", unlockedNum, pp.libCut.unlockeds.length);
    },

    didGetUserInput: function (sel) {
        //cc.log("ScnThemeMap: sel=", sel);

        pp.mediator.playSound(res.Snd_Click);

        pp.mediator.suiDidGetUserInput(sel);
    }

});

pp.ScnLibrary.prevPageIdx = 0;