
pp.FrmThemeR = pp.Frm.extend({

    lyrThemeCaption: null,
    lyrVoice: null,
    lyrKeyValues: null,
    lyrFace: null,
    mnuTheme: null,
    mnuDiscs: null,
    lyrItems: null,
    lblStatus: null,

    callback: null,
    target: null,

    personId: 0,
    themePIdx: 0,

    lyrItemX: 0,

    ctor: function (callback, target) {

        this._super(res.Img_FrmDate);
        this.setContentSize(tm.m(cc.winSize.width, 984), tm.m(780, 380));

        this.callback = callback;
        this.target = target;

        this.personId = pp.mediator.personId;

        // Caption
        {
            var lyr = new pp.LyrCaption(__( "－－－－－－－－－－－－－", tm.m("－－－－－－－－－－－－－－－", "－－－－－－－－－－－－－－－－－")));
            lyr.attr({
                anchorX: 0.5,
                anchorY: 1,
                x: tm.m(this.width/2, 356),
                y: this.height - tm.m(37, 30)
            });
            this.addChild(lyr);
            this.lyrThemeCaption = lyr;
        }

        // Face
        var lyrFace;
        {
            lyrFace = new pp.LyrFace(this.personId);
            lyrFace.attr({
                ignoreAnchor: false,
                anchorX: 0.5,
                anchorY: 1,
                x: 90,
                y: this.height - tm.m(120, 82)
            });
            this.addChild(lyrFace);
            this.lyrFace = lyrFace;
        }

        // Voice
        var lyrVoice;
        {
            lyrVoice = new pp.LyrVoice();
            lyrVoice.attr({
                anchorX: 0,
                anchorY: 1,
                x: lyrFace.x + lyrFace.width * (1-lyrFace.anchorX) + 0,
                y: lyrFace.y
            });
            this.addChild(lyrVoice);
            this.lyrVoice = lyrVoice;
        }

        // Status
        var lblStatus;
        {
            lblStatus = new tm.LabelTTF("---", pp.font, tm.m(__(27, 22), 18));
            lblStatus.attr({
                anchorX: tm.m(0.5, 0),
                anchorY: 1,
                x: tm.m(90, lyrVoice.x + 22),
                y: tm.m(lyrFace.y - lyrFace.height - 20, lyrVoice.y - lyrVoice.height - 18)
            });
            this.addChild(lblStatus);
            this.lblStatus = lblStatus;
        }

        // Detail
        var lyrKeyValues;
        {
            lyrKeyValues = new pp.LyrKeyValues(
                {},
                null,
                tm.m(cc.size(340, 240), cc.size(220, 190)));
            lyrKeyValues.attr({
                ignoreAnchor: false,
                anchorX: tm.m(0.5, 0),
                anchorY: 1,
                x: tm.m(this.width/2, lyrVoice.x + lyrVoice.width * (1-lyrVoice.anchorX) + 10),
                y: tm.m(lyrVoice.y - lyrVoice.height - 15, lyrVoice.y)
            });
            this.addChild(lyrKeyValues);
            this.lyrKeyValues = lyrKeyValues;
        }

        // Discoveries
        {
            var lbl = new tm.LabelTTF(__("発見", tm.m("Discoveries", "Disco-\nveries"), "发现"), pp.font, tm.m(__(26, 24), __(18, 16)), cc.color.BLACK);
            lbl.attr({
                anchorX: tm.m(0.5, 0),
                anchorY: 0.5,
                x: tm.m(this.width / 2, 20),
                y: tm.m(135, 62)
            });
            lbl.setFontFillColor(cc.color.YELLOW);
            this.addChild(lbl);
        }

        // Paging menu
        var mnuPage;
        {
            //ctor: function (strings, callback, target, isRadio, tint, isVertical, span, xMagnitude)

            mnuPage = new pp.MenuRect(
                ["<<", ">>" ],
                function (itm) {
                    pp.mediator.playSound(res.Snd_Click);

                    if (pp.world.tutorialStage == pp.tuOff) {
                        var newPIdx = (this.themePIdx + (itm.tag == 0 ? - 1 : 1) + 3) % 3;
                        this.setThemePIdx(newPIdx);
                        pp.ScnPagedResearch.prevPageIdx = newPIdx;
                    }
                },
                this,
                false,
                cc.color(128, 128, 0),
                false,
                tm.m(535, 450),
                tm.m(0.5, 1)
            );
            mnuPage.attr({
                anchorX: 0,
                anchorY: 1,
                x: tm.m(20, 32),
                y: this.height - 27
            });
            this.addChild(mnuPage);
        }

        // Items
        {
            this.lyrItemX =  lyrKeyValues.x + lyrKeyValues.width * (1- lyrKeyValues.anchorX) + 18;
        }

        this.ignoreAnchor = false;

        this.setThemePIdx(pp.ScnPagedResearch.prevPageIdx);
        this.updateVoice(this.themePIdx);
    },

    updateThemeMenu: function (idx) {

        if (this.mnuTheme) {
            this.mnuTheme.removeFromParent();
            this.mnuTheme = null;
        }

        var strs = [];
        var ids = [];

        var person = pp.world.persons[this.personId];
        var themep = person.themePs[idx];

        if (themep.themeId == pp.idInvalid) {
            strs.push(__("テーマ選択"));
            ids.push(pp.cmrSelect);
        }
        else {
            var theme = pp.world.themes[themep.themeId];
            var field = pp.world.fields[theme.fieldId];

            strs.push(field.dataName);
            ids.push(pp.cmrData);

            if (field.isDeducable) {
                strs.push(field.deduceName);
                ids.push(pp.cmrDeduce);
            }

            strs.push(__("テーマ情報"));
            ids.push(pp.cmrInfoTheme);

            strs.push(__("研究中止"));
            ids.push(pp.cmrUnselect);
        }


        var callback = this.callback;
        var target = this.target;
        var themePIdx = this.themePIdx;

        //ctor: function (strings, callback, target, isRadio, tint, isVertical, span, xMagnitude, barVal, isFlat, fontSize) {

        var mnuTheme = new pp.MenuRect(
            strs,
            function (obj) {
                var comId = ids[obj.tag];
                callback.call(target, [ comId, themePIdx ] );
            },
            this,
            false,
            null,
            tm.m(false, true),
            tm.m(10, 20),
            tm.m(0.94, 1)
        );

        mnuTheme.attr({
            anchorX: tm.m(0, 1),
            anchorY: tm.m(0, 1),
            x: tm.m(30, this.width - 30),
            y: tm.m(165, this.height - 40)
        });

        this.addChild(mnuTheme);

        this.mnuTheme = mnuTheme;
    },

    updateDiscMenu: function (idx) {

        if (this.mnuDiscs) {
            this.mnuDiscs.removeFromParent();
            this.mnuDiscs = null;
        }

        var spsDiscs = [];
        var enableds = [];
        var ids = [];

        var person = pp.world.persons[this.personId];
        var themep = person.themePs[idx];

        if (themep.themeId != pp.idInvalid) {
            var theme = pp.world.themes[themep.themeId];
            var field = pp.world.fields[theme.fieldId];

            var discs = theme.getDiscoveries();

            for (var i = 0; i < discs.length; i++) {
                var disc = discs[i];
                var dc = person.discCredibilities[disc.id];
                var sp;
                var enabled;

                if (dc < 0) {
                    // before noticing
                    sp = new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*0, 32*0, 32, 32));
                    enabled = false;
                }
                else {
                    sp = [];
                    enabled = true;

                    switch (disc.type) {
                        case pp.ttTheory:
                            sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*1, 32*0, 32, 32)));
                            break;
                        case pp.ttItem:
                            if (dc == pp.crPreMake)
                                sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*2, 32*0, 32, 32)));
                            else
                                sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*4, 32*0, 32, 32)));
                            break;
                        case pp.ttFigure:
                            if (dc == pp.crPreMake)
                                sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*3, 32*0, 32, 32)));
                            else
                                sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*5, 32*0, 32, 32)));
                            break;
                        case pp.ttThing:
                            sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*6, 32*0, 32, 32)));
                            break;
                        case pp.ttBook:
                            sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*7, 32*0, 32, 32)));
                            break;
                    }

                    var reportId = person.getReportIdFromDiscId(disc.id);
                    if (reportId != pp.idInvalid) {
                        var report = pp.world.reports[reportId];
                        if (report.societyId == pp.idInvalid) {
                            sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*0, 32*1, 32, 32)));
                        }
                        else {
                            sp.push(new cc.SpriteFrame(res.Img_IconAtlas, cc.rect(32*1, 32*1, 32, 32)));
                        }
                    }
                }

                if (pp.mediator.isCheckingText)
                    enabled = true;

                spsDiscs.push(sp);
                ids.push(disc.id);
                enableds.push(enabled);
            }
        }

        var callback = this.callback;
        var target = this.target;

        //ctor: function (icons, callback, target, tint, isVertical, span, scale, iconScale) {

        var mnuDiscs = new pp.Menu(
            spsDiscs,
            function (obj) {
                callback.call(target, [ pp.cmrDiscovery, ids[obj.tag] ]);
            },
            target,
            null,
            false,
            0,
            tm.m(1.35, null),
            1
        );
        mnuDiscs.attr({
            anchorX: 0,
            anchorY: 0,
            x: tm.m(30, 70),
            y: 30
        });
        for (var i = 0; i < enableds.length; i++) {
            mnuDiscs.enableItem(i, enableds[i]);
        }
        this.addChild(mnuDiscs);
        this.mnuDiscs = mnuDiscs;
    },

    updateVoice: function (idx) {

        var voice = "";

        var person = pp.world.persons[this.personId];
        var themep = person.themePs[idx];

        if (themep.themeId == pp.idInvalid) {
            voice = __("・・・・・。", ".........")
        }
        else {

            var theme = pp.world.themes[themep.themeId];
            var field = pp.world.fields[theme.fieldId];

            var canData = themep.data < theme.getMaxData();
            var canDeduce = field.isDeducable && (themep.deduce < theme.getMaxDeduce());

            if (canData && canDeduce) {
                if (tm.irand(2) == 0)
                    canData = false;
                else
                    canDeduce = false;
            }

            if (canData) {
                var dataName = field.dataName;
                if (dataName == "Observe") dataName = "Observation";
                if (dataName == "Calculate") dataName = "Calculation";
                if (dataName == "Examine") dataName = "Examination";
                if (dataName == "Write") dataName = "Writing";
                voice = __(
                    "もう少し" + field.dataName + "を行う必要がありそうだな。",
                    "It would appear I need to conduct further " + tmi.toLowerCase(dataName) + ".",
                    "看来我还得做更多" + field.dataName + "。");
            }
            else if (canDeduce) {
                voice = __(
                    "もう少し推理を進める必要がありそうだな。",
                    "It would appear I need to conduct further reasoning.",
                    "看来我还得做更多推理。");
            }
            else {
                voice = __(
                    "このテーマで発見できることはもう無さそうだ。",
                    "Clearly, I have learned all there is to know about this topic.",
                    "这个课题下已经没有更多发现了。");
            }
        }

        this.lyrVoice.label.string = voice;
    },

    updateItems: function (idx) {

        var person = pp.world.persons[this.personId];
        var themep = person.themePs[idx];

        if (this.lyrItems) {
            for (var i = 0; i < this.lyrItems.length; i++) {
                this.lyrItems[i].removeFromParent();
            }
            this.lyrItems = null;
        }

        if (themep.themeId == pp.idInvalid)
            return;

        var callback = this.callback;
        var target = this.target;
        var themePIdx = this.themePIdx;
        var theme = pp.world.themes[themep.themeId];
        var field = pp.world.fields[theme.fieldId];

        this.lyrItems = [];

        for (var i = 0; i < pp.maxNumItemsInThemeP; i++) {

            var itemId = themep.itemIds[i];
            var image;
            var caption;
            var effect;

            if (itemId == pp.idInvalid) {
                image = res.Img_ItemOff;
                caption = "(" + __("器具", "Apparatus ") + (i+1) + ")";
                effect = "－－－－: --";
            }
            else {
                var item = pp.world.items[itemId];
                image = item.picture;
                caption = item.name;
                effect = __("効率", "Effect") + ": +" + item.gain;
            }

            var lyrItmButton = new pp.LyrImagedButton(image, caption, effect, new function (itemIdx) {
                    return (function () {
                        callback.call(target, [ pp.cmrItem, themePIdx, itemIdx ]);
                    })
                }(i),
                target);
            lyrItmButton.attr({
                x: tm.m(this.width - lyrItmButton.width, this.lyrItemX),
                y: tm.m(this.lyrVoice.y - lyrItmButton.height*2-20, 32) + (lyrItmButton.height + 20) * (pp.maxNumItemsInThemeP - 1 - i)
            });
            this.addChild(lyrItmButton);
            this.lyrItems.push(lyrItmButton);
        }
    },

    updateKeyValues: function (idx) {

        var person = pp.world.persons[this.personId];
        var themep = person.themePs[idx];
        var str = __("テーマ") + __(tm.toWideCharNumbers(idx+1), " " + (idx+1)) + ": ";
        var keyValues = {};

        if (themep.themeId != pp.idInvalid) {
            var theme = pp.world.themes[themep.themeId];
            str += theme.name;

            var field = pp.world.fields[theme.fieldId];
            var dataName = field.dataName;
            if (dataName == "Observe") dataName = "Observation";
            if (dataName == "Calculate") dataName = "Calculation";
            if (dataName == "Examine") dataName = "Examination";
            if (dataName == "Write") dataName = "Writing";

            keyValues[__(dataName, tm.padRight(dataName, 11))] = "" + themep.data + "/" + theme.getMaxData();

            if (field.isDeducable) {
                keyValues[__("推理", tm.padRight(__("推理"), 11))] = "" + themep.deduce + "/" + theme.getMaxDeduce();
            }
            else {
                keyValues[__("推理", tm.padRight(__("推理"), 11))] = "--/--";
            }

            keyValues[__("発見")] =
                "" + person.getDiscoveryCountWithThemePIdx(idx) + "/" + theme.discoveryCount + "\n" +
                __("    ", "  ") + __("理論") + ": " + person.getDiscoveriesWithType(pp.ttTheory, theme.id).length +
                "  " + __("発明") + ": " + person.getDiscoveriesWithType(pp.ttItem, theme.id).length + "\n" +
                __("    ", "  ") + __("描画") + ": " + person.getDiscoveriesWithType(pp.ttFigure, theme.id).length +
                "  " + __("存在") + ": " + person.getDiscoveriesWithType(pp.ttThing, theme.id).length;

            keyValues[__("論文")] = "" + person.getReports(themep.themeId).length;
        }
        else {
            str += "－－－";

            keyValues = __(
                {
                    "＊＊": "--/--",
                    "推理": "--/--",
                    "発見": "--/--\n    理論: --  発明: --\n    描画: --  存在: --",
                    "論文": "--"
                },
                {
                    "---------  ": "--/--",
                    "Discoveries": "--/--\n  Theory: -  Invention: -\n  Sketch: -  Existence: -",
                    "Paper": "--"
                },
                {
                    "＊＊": "--/--",
                    "推理": "--/--",
                    "发现": "--/--\n    理论: --  发明: --\n    制图: --  发现: --",
                    "论文": "--"
                }
            );

        }

        this.lyrThemeCaption.label.string = str;

        if (str.length > 40) {
            this.lyrThemeCaption.label.scaleX = 0.8;
        }
        else {
            this.lyrThemeCaption.label.scaleX = 1.0;
        }

        this.lyrKeyValues.setKeyValues(keyValues);
    },

    setThemePIdx: function (idx) {
        this.themePIdx = idx;
        this.updateVoice(idx);
        this.uiUpdate();
    },

    uiUpdate: function () {
        var idx = this.themePIdx;

        {
            var person = pp.world.persons[this.personId];
            var strAndCol = person.getStatusStringAndColor("");
            this.lblStatus.setFontFillColor(strAndCol[1]);
            this.lblStatus.setFontStroke(strAndCol[2]);
            this.lblStatus.string = strAndCol[0];
        }

        this.updateKeyValues(idx);
        this.updateThemeMenu(idx);
        this.updateDiscMenu(idx);
        this.updateItems(idx);
    }
});

//----------------------------------------------------------------------
pp.ScnPagedResearch = pp.ScnPaged.extend({

    frmDate: null,
    frmThemeR: null,
    menu: null,

    ctor: function () {

        this._super(pp.PG_RESEARCH);

        this._name = "ScnPagedResearch";

        // Background
        {
            var sprWall = new cc.Sprite(res.Img_FullRoom);
            sprWall.ignoreAnchor = true;
            sprWall.attr({
                y: cc.winSize.height - sprWall.height
            });
            this.addChild(sprWall, 0);
        }

        // Date
        var frmDate;
        if (tm.m())
        {
            frmDate = new pp.FrmDate();
            frmDate.updateLabels(pp.mediator.personId); //@@@
            frmDate.attr({
                anchorX: 0,
                anchorY: 1,
                x: 0,
                y: this.height - pp.LYR_STATUS_BAR_HEIGHT
            });
        }
        else
        {
            frmDate = new pp.FrmDateR();
            frmDate.updateLabels(pp.mediator.personId); //@@@
            frmDate.attr({
                anchorX: 0,
                anchorY: 1,
                x: 20,
                y: cc.winSize.height - 140 - 40
            });
        }

        this.addChild(frmDate, 1);
        this.frmDate = frmDate;

        // Cut
        {
            var sprImage = new cc.Sprite(res.Img_CutStudy);
            //sprImage.scale = tm.m(2, 1);
            //sprImage.width *= sprImage.scale;
            //sprImage.height *= sprImage.scale;
            //sprImage.texture.setAliasTexParameters();

            var frm = new pp.Frm(res.Img_FrmSimple256x256, sprImage, tm.m(14, 20), tm.m(10, 20));

            frm.attr({
                ignoreAnchor: false,
                anchorX: 0.5,
                anchorY: 1,
                x: this.width / 2,
                y: tm.m(frmDate.y - frmDate.height - 15 - 22 + pp.LYR_STATUS_BAR_HEIGHT/2, cc.winSize.height - 80)
            });
            this.addChild(frm, 1);

            /*

            sprImage.attr({
                anchorX: 0,
                anchorY: 1,
                x: this.width / 2 - sprImage.width,
                y: frmDate.y - frmDate.height
            });
            this.addChild(sprImage, 1);
            */
        }

        // Caption
        if (!tm.m())
        {
            var spr = new pp.FrmCaption(__("研究室"));
            spr.attr({
                anchorX: 0,
                anchorY: 1,
                x: 20,
                y: this.height - 40 - 40
            });
            this.addChild(spr, 1);
        }


        // Buttons
        if (!tm.m())
        {
            var strs = [
                __("人物情報", "Scientist", "人物情报"),
                __("その他の情報", "Other Info", "其他情报")
            ];
            var ids = [
                pp.cmrInfoSelf,
                pp.cmrInfo
            ];

            var menu = new pp.MenuRect(
                strs,
                function (obj) {
                    this.didGetUserInput(ids[obj.tag]);
                },
                this,
                false,
                null,
                true,
                20,
                2
            );

            var lyr = new cc.Layer();
            lyr.width = menu.width;
            lyr.height = 200 - 20; //; this.height - 40 - 40 - 40;
            lyr.addChild(menu);

            var lbl = new tm.LabelTTF(__("情報"), pp.font, __(20, 18), cc.color.BLACK, cc.color.YELLOW, 1);
            lbl.attr({
                anchorY: 1,
                x: lyr.width / 2,
                y: lyr.height - 10
            });
            //lbl.setFontFillColor(cc.color.YELLOW);
            lyr.addChild(lbl);

            menu.attr({
                anchorY: 1,
                y: lbl.y - lbl.height - 20
            });

            var frm = new pp.Frm(pp.POP_FRM_SIMPLE, lyr);
            frm.attr({
                x: this.width - frm.width - 20,
                y: this.height - frm.height - 40 - 40
            });

            this.addChild(frm, 1);
            this.menu = menu;
        }

        // Theme Frame
        {
            var frmThemeR = new pp.FrmThemeR(function (sel) {
                this.didGetUserInput(sel)
            }, this);
            frmThemeR.attr({
                anchorX: 0,
                anchorY: 0,
                x: tm.m(0, 20),
                y: tm.m(this.frmPager.height, 20)
            });
            this.addChild(frmThemeR, 1);
            this.frmThemeR = frmThemeR;

            //frmThemeR.setThemePIdx(pp.ScnPagedResearch.prevPageIdx);
        }

        var sprStars = new cc.Sprite(res.Img_UnvStars);
        sprStars.attr({
            x: this.width / 2,
            y: this.height / 2
        });
        this.addChild(sprStars, 0);

        sprStars.runAction(
            cc.rotateBy(16000, 36000*2)
        );
    },

    uiUpdate: function () {
        this._super();

        this.frmThemeR.uiUpdate();
    },

    updateVoice: function (idx) {
        this.frmThemeR.updateVoice(idx);
    },

    didGetUserInput: function (sel) {
        //cc.log("ScnResearch: sel=", sel);

        pp.mediator.playSound(res.Snd_Click);

        pp.mediator.suiDidGetUserInput(sel);
    }

});

pp.ScnPagedResearch.prevPageIdx = 0;
