
pp.ScnPagedSystem = pp.ScnPaged.extend({

    frame: null,

    ctor: function () {

        this._super(pp.PG_SYSTEM);

        this._name = "ScnPagedSystem";

        // Background
        {
            var sprWall = new cc.Sprite(res.Img_FullRoom);
            sprWall.attr({
                anchorX: 0,
                anchorY: 0,
                scale: tm.m(2, 1)
            });
            this.addChild(sprWall, 0);

            var sprStars = new cc.Sprite(res.Img_UnvStars);
            sprStars.attr({
                x: this.width / 2,
                y: this.height / 2
            });
            this.addChild(sprStars, 0);

            sprStars.runAction(
                cc.rotateBy(16000, 36000*2)
            );
        }

        this.uiUpdate();
    },

    createFrame: function () {

        //--- Build Menu items based on game mode
        var strs = [];
        var ids = [];

        strs.push(__("図鑑")); ids.push(pp.cmsLibrary);
        strs.push(__("セーブ")); ids.push(pp.cmsSave);
        strs.push(__("ロード")); ids.push(pp.cmsLoad);
        strs.push(tm.buildOptionStr("messageSpeed")); ids.push(pp.cmsMessageSpeed);
        strs.push(tm.buildOptionStr("toShowCpuTurn")); ids.push(pp.cmsCpuTurn);
        strs.push(__("今の状態からデモ")); ids.push(pp.cmsAutoMode);
        strs.push(__("ゲーム終了")); ids.push(pp.cmsQuitGame);

        if (pp.mediator.isDebug) { strs.push("(Debug)"); ids.push(pp.cmsDebug); }

        if (pp.mediator.isCheckingText) { strs.push("(Check Text)"); ids.push(pp.cmsCheckText); }

        var menu = new pp.MenuRect(
            strs,
            function (obj) {
                this.didGetUserInput(ids[obj.tag]);
            },
            this,
            false,
            null,
            true,
            20,
            tm.m(3.6, 4)
        );

        var frm = new pp.Frm(pp.POP_FRM_NO_BUTTONS, menu);
        frm.attr({
            ignoreAnchor: false,
            anchorX: 0.5,
            anchorY: 0.5,
            x: this.width/2,
            y: this.height/2
        });

        return frm;
    },

    didGetUserInput: function (sel) {
        //cc.log("ScnThemeMap: sel=", sel);

        pp.mediator.playSound(res.Snd_Click);

        pp.mediator.suiDidGetUserInput(sel);
    },

    uiUpdate: function () {

        if (this.frame) {
            this.frame.removeFromParent();
        }

        this.frame = this.createFrame();
        this.addChild(this.frame, 1);
    }

});
