pp.SprFlatBalloon = cc.Layer.extend({

    action: null,

    ctor: function (caption, pointX, pointY, color, bodyAlign) {

        var marginx = 100;
        var marginy = 40;
        var color = color || cc.color.WHITE;
        var caption = caption || "";
        var pointX = cc.isNumber(pointX) ? pointX : 100;
        var pointY = cc.isNumber(pointY) ? pointY : 100;
        var bodyAlign = bodyAlign || pp.ALIGN_BOTTOM_LEFT;

        this._super();
        this.ignoreAnchor = false;

        // Body & Caption
        {
            var label = new cc.LabelTTF(caption, pp.font, tm.m(24, 16));

            var sprBody = new cc.LayerColor(color, label.width + marginx, label.height + marginy);
            sprBody.attr({
                ignoreAnchor: false,
                cascadeOpacity: true
            });

            sprBody.addChild(label);
            label.attr({
                x: sprBody.width / 2,
                y: sprBody.height / 2
            });
            label.setFontFillColor(cc.color.BLACK);

            if (caption) {
                this.addChild(sprBody, 2);
            }
        }

        this.width = sprBody.width;
        this.height = sprBody.height;

        sprBody.attr({
            x: this.width/2,
            y: this.height/2
        });

        // Arrow
        {
            var spr = new cc.Sprite(res.Img_ShpArrow128x256);
            var length = Math.sqrt(pointX * pointX + pointY * pointY);
            var angle = Math.atan2(pointX, pointY) * 180 / cc.PI;

            spr.ignoreAnchorPointForPosition(true);
            spr.attr({
                ignoreAnchor: false,
                x: sprBody.x,
                y: sprBody.y,
                anchorX: 0.5,
                anchorY: 0,
                scaleY: length / spr.height,
                scaleX: 0.3,
                rotation: angle
            });

            this.addChild(spr, 1);
        }

        var diffX = bodyAlign == pp.ALIGN_BOTTOM_LEFT || bodyAlign == pp.ALIGN_TOP_LEFT ? -10 : 10;
        var diffY = bodyAlign == pp.ALIGN_BOTTOM_LEFT || bodyAlign == pp.ALIGN_BOTTOM_RIGHT ? -10 : 10;

        this.action = cc.repeatForever(
            cc.sequence(
                cc.moveBy(0.75, diffX, diffY),
                cc.moveBy(0.05, -diffX, -diffY)
            )
        );

        this.cascadeOpacity = true;

        this.runAction(this.action);
    },

    setActionToSync: function (actToSync) {

        if (actToSync) {
            this.action.step(0);
            this.action.step(actToSync.getElapsed());
        }
    }

});
