

pp.Wall = cc.Layer.extend({

    isDemoDone: false,
    onActionDone: null,
    onActionDoneTarget: null,

    sound: null,

    strTryInDebug: null,
    iTryInDebug: 0,

    ctor: function (content, callback, target, sound) {

        this._super();

        this.isDemoDone = true;
        this.onActionDone = callback;
        this.onActionDoneTarget = target;
        this.sound = sound || res.Snd_OK;

        this.strTryInDebug = "";
        this.iTryInDebug = 0;

        // Swallow touches
        {
            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: true,
                    onTouchBegan: function (touch, event) { return true; },
                    onTouchMoved: function (touch, event) { return true; },
                    onTouchEnded: this.onDidClick,
                    onTouchCancelled: function (touch, event) { return true; }
                }),
                this
            );
        }

        {
            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.KEYBOARD,
                    onKeyPressed: function (keyCode, event) {
                        //cc.log("PRESSED keyCode=" + keyCode + " (" + String.fromCharCode(keyCode) + ")");
                        this.tryInDebugMode(keyCode);
                        return true;
                    }.bind(this),
                    onKeyReleased: function (keyCode, event) { return true; }
                }),
                this
            );
        }

        this.addChild(content);

        this.doFirstAnime();
    },

    doFirstAnime: function () {
        this.isDemoDone = false;
        this.runAction(
            cc.sequence(
                cc.fadeIn(0.2),
                cc.callFunc(function () {
                    this.isDemoDone = true;
                }, this)
            )
        );
    },

    doFinalAnime: function () {
        this.isDemoDone = false;
        this.runAction(
            cc.sequence(
                cc.fadeOut(0.2),
                cc.callFunc(function () {
                    this.onActionDone.call(this.onActionDoneTarget);
                }, this),
                cc.removeSelf()
            )
        );
    },

    onDidClick: function (touch, event) {

        var node = event.getCurrentTarget();
        if (node.isDemoDone == false)
            return true;

        if (node.tryInDebugModeM(touch))
            return true;

        pp.mediator.playSound(node.sound);

        node.doFinalAnime();
        return true;

    },

    tryInDebugModeM: function (touch) {

        if (pp.mediator.isDebug)
            return false;

        var pos = tm.getTouchPos(touch);

        //cc.log("pos=(" + pos.x + ", " + pos.y + ")");

        var answer = tm.m(
            [ 360, 30, 596, 709, 460, 30, 294, 30, 101, 225],
            [ 571, 53, 290, 711, 303, 32, 600, 54, 451, 27 ]
        );

        var i = this.iTryInDebug;
        if (Math.abs(pos.x - answer[i*2]) + Math.abs(pos.y - answer[i*2+1]) > 60) {
            //cc.log("Failed with #" + i);
            this.iTryInDebug = 0;
            return false;
        }

        this.iTryInDebug++;

        if (this.iTryInDebug < answer.length / 2)
            return true;

        pp.mediator.isDebug = true;
        pp.mediator.playSound(res.Snd_OK);
        cc.log("Entered in DEBUG MODE.");
        return true;
    },

    tryInDebugMode: function (keyCode) {

        var answer = "DEBUG";

        this.strTryInDebug += String.fromCharCode(keyCode);

        var len = this.strTryInDebug.length;

        if (this.strTryInDebug.substr(0, len) != answer.substr(0, len)) {
            this.strTryInDebug = "";
            //cc.log("Failed with #" + len);
        }
        else if (len >= answer.length) {
            pp.mediator.isDebug = true;
            pp.mediator.playSound(res.Snd_OK);
            cc.log("Entered in DEBUG MODE.");
        }
        else {
            //cc.log("#" + len);
        }
    }
});
