
pp.WallBigMessage = cc.Layer.extend({

    lbl: null,

    onActionDone: null,
    onActionDoneTarget: null,

    ctor: function (str, callback, target, align) {

        this._super();

        this.onActionDone = callback;
        this.onActionDoneTarget = target;

        align = align || cc.TEXT_ALIGNMENT_LEFT;

        // Label
        {
            var lbl = this.lbl = new tm.LabelTTF(str, pp.font, tm.m(28, 20), cc.color.BLACK);
            lbl.attr({
                anchorX: 0.5,
                anchorY: 1,
                x: cc.winSize.width / 2,
                y: 0
            });
            lbl.setFontFillColor(cc.color.WHITE);
            lbl.setHorizontalAlignment(align);
            lbl.setDimensions(cc.winSize.width * 0.85, 0);
            this.addChild(lbl, 3);
        }

        // Start Anime
        var duration = (this.height + this.lbl.height) / 25; //@@@
        this.lbl.runAction(
            cc.sequence(
                cc.moveTo(duration, this.lbl.x, this.height + this.lbl.height),
                cc.callFunc(function () {
                    this.finalize();
                }, this)
            )
        );

        // Set up event manager
        {
            cc.eventManager.addListener(
                cc.EventListener.create({
                    event: cc.EventListener.TOUCH_ONE_BY_ONE,
                    swallowTouches: true,
                    onTouchBegan: function (touch, event) { return true; },
                    onTouchMoved: function (touch, event) { return true; },
                    onTouchEnded: this.onTouchEnded,
                    onTouchCancelled: function (touch, event) { return true; }
                }),
                this
            );
        }
    },

    onTouchEnded: function (touch, event) {
        var node = event.getCurrentTarget();
        var touchPos = tm.getTouchPos(touch);

        cc.director.getScheduler().setTimeScale(128);
        node.scheduleOnce(function () { cc.director.getScheduler().setTimeScale(1); }, 6.4);

        return true;
    },

    finalize: function () {

        cc.director.getScheduler().setTimeScale(1);

        if (this.onActionDone) {
            this.onActionDone.call(this.onActionDoneTarget);
        }
        this.removeFromParent();
    }

});


