uniform sampler2D sourceTexture;
uniform sampler2D blendTexture;
#define BlendColorDodgef(base, blend) 	((blend == 1.0) ? blend : min(base / (1.0 - blend), 1.0))
#define BlendColorBurnf(base, blend) 	((blend == 0.0) ? blend : max((1.0 - ((1.0 - base) / blend)), 0.0))
#define BlendVividLightf(base, blend) 	((blend < 0.5) ? BlendColorBurnf(base, (2.0 * blend)) : BlendColorDodgef(base, (2.0 * (blend - 0.5))))
#define BlendHardMixf(base, blend) 	((BlendVividLightf(base, blend) < 0.5) ? 0.0 : 1.0)
#define BlendLinearLightf(base, blend) 	(blend < 0.5 ? BlendLinearBurnf(base, (2.0 * blend)) : BlendLinearDodgef(base, (2.0 * (blend - 0.5))))
void main()
{
	 vec4 ref = texture2D(sourceTexture, gl_TexCoord[0].xy) * gl_Color;
 	 vec4 blendRef = texture2D(blendTexture, gl_TexCoord[0].xy) * gl_Color;


	 vec4 outcol;
	 outcol.r = BlendLinearLightf(ref.r,blendRef.r);
	 outcol.g = BlendLinearLightf(ref.g,blendRef.g);
	outcol.b = BlendLinearLightf(ref.b,blendRef.b);
	outcol.a = ref.a;
    gl_FragColor = outcol;
}