// The original texture
uniform sampler2D texture;

uniform float mX;
uniform float mY;
uniform float fallOff;
uniform vec2 resolution;
uniform float fallOffPower;
uniform vec3 fillColor;
uniform bool invert;

void main()
{
	vec2 texel = texture2D(texture,gl_FragCoord.xy);
	vec4 pixel = texture2D(texture, gl_TexCoord[0].xy);
	
	vec2 mousePos = vec2(mX  , mY);

	float dist = distance(gl_FragCoord.xy, mousePos);
	float perc = 1 - pow((dist / fallOff),fallOffPower);

	float pAlpha = 1 * perc;

	float minAlpha = min(pixel.w, pAlpha);
	//minAlpha = max(minAlpha, 0.2f);

	pixel.xyz = 0.f;
	pixel.w = minAlpha;
	
	//pixel.rgb = fillColor.rgb * pAlpha;

	gl_FragColor = pixel;

	
}
