#version 120    
uniform sampler2D tex0;
uniform float border; // 0.01
uniform float circle_radius; // 0.5
uniform vec3 circle_color_v3;
 // vec4(1.0, 1.0, 1.0, 1.0)
uniform vec2 circle_center; // vec2(0.5, 0.5)    
void main (void)
{
vec4 circle_color;
  circle_color.r = circle_color_v3.r;
  circle_color.g = circle_color_v3.g;
  circle_color.b = circle_color_v3.b;
  circle_color.a = 1.f;

   vec2 uv = gl_TexCoord[0].xy;
  
  vec4 bkg_color = texture2D(tex0,uv * vec2(1.0, -1.0));

  // Offset uv with the center of the circle.
  uv -= circle_center;
  
  float dist =  sqrt(dot(uv, uv));
  float delta = fwidth(dist);

  float useBorder = border - delta / 2.f;
  if ( (dist > (circle_radius+border)) || (dist < (circle_radius-border)) ){
    gl_FragColor = bkg_color;
	if(abs(circle_radius-dist) - useBorder < delta){
		 gl_FragColor = circle_color;
		 gl_FragColor.a = 1- ((abs(circle_radius-dist) - useBorder) / delta);
	}
  }
  else 
    gl_FragColor = circle_color;
}