#version 120    
uniform sampler2D tex0;
uniform float border; // 0.01
uniform float circle_radius; // 0.5
uniform vec4 circle_color; // vec4(1.0, 1.0, 1.0, 1.0)
uniform vec2 circle_center; // vec2(0.5, 0.5)    
void main (void)
{
  vec2 uv = gl_TexCoord[0].xy;
  
  vec4 bkg_color = texture2D(tex0,uv * vec2(1.0, -1.0));
  
  // Offset uv with the center of the circle.
  uv -= circle_center;
  
  float dist =  sqrt(dot(uv, uv));

  float t = 1.0 + smoothstep(circle_radius, circle_radius+border, dist) 
                - smoothstep(circle_radius-border, circle_radius, dist);

  gl_FragColor = mix(circle_color, bkg_color,t);
}