uniform sampler2D texture;
uniform bool invert;
void main()
{
	vec2 texel = texture2D(texture,gl_FragCoord.xy);
	vec4 pixel = texture2D(texture, gl_TexCoord[0].xy);

	float sum  = pixel.r + pixel.g + pixel.b;

	float greyscale = sum / 3.f;

	if(invert){
		pixel.r = 1 - greyscale;
		pixel.g = 1 -  greyscale;
		pixel.b = 1 -  greyscale;
	}
	else{
		pixel.r = greyscale;
		pixel.g = greyscale;
		pixel.b = greyscale;
	}
	gl_FragColor = pixel;
}