local assets=
{
	Asset("ANIM", "anim/wb.zip"),
    Asset("ANIM", "anim/swap_wb.zip"),
      Asset("IMAGE", "images/inventoryimages/lm.tex"),
    Asset("ATLAS", "images/inventoryimages/lm.xml"),

}


local prefabs =
{
     "firesplash_fx",
   
}


local function UpdateDamage(inst)
    if inst.components.perishable and inst.components.weapon then
        local dmg = TUNING.HAMBAT_DAMAGE * inst.components.perishable:GetPercent()
        dmg = Remap(dmg, 0, TUNING.HAMBAT_DAMAGE, TUNING.HAMBAT_MIN_DAMAGE_MODIFIER*TUNING.HAMBAT_DAMAGE, TUNING.HAMBAT_DAMAGE)
        inst.components.weapon:SetDamage(dmg)
    end
end

local function OnLoad(inst, data)
    UpdateDamage(inst)
end



local function onequip(inst, owner)
    UpdateDamage(inst)
    owner.AnimState:OverrideSymbol("swap_object", "swap_wb", "swap_galientsword")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    UpdateDamage(inst)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end






local function onattack(inst, attacker, target)

   if math.random() < .33 then
      target.components.health:DoDelta(-10)
 if target then
  SpawnPrefab("firesplash_fx").Transform:SetPosition(inst:GetPosition():Get())
end
        end
end

local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
if SaveGameIndex:IsModeShipwrecked() then
  
	MakeInventoryFloatable(inst, "idle", "idle")
end
    anim:SetBank("galientsword")
    anim:SetBuild("wb")
 anim:PlayAnimation("idle")   
    
    inst:AddTag("show_spoilage")
    inst:AddTag("icebox_valid")

  
   
    
   
 inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED*1.5)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.HAMBAT_DAMAGE)
    inst.components.weapon:SetOnAttack(UpdateDamage)


   
 inst.components.weapon:SetOnAttack(onattack)

  
inst.OnLoad = OnLoad

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/lm.xml"
    
    inst:AddComponent("equippable")

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

 
    
    return inst
end

return Prefab( "common/inventory/lm", fn, assets) 
