local assets=
{
	Asset("ANIM", "anim/ml.zip"),
	    
}
local UIAnim = require "widgets/uianim"
local Widget = require "widgets/widget"
local Text = require "widgets/text"

local ml = Class(Widget, function(self, owner)
	Widget._ctor(self, "ml")
	self.owner = owner

    self:SetPosition(0,60,0)

    self.point = 0
    

    self.anim = self:AddChild(UIAnim())
	self.anim:GetAnimState():SetBank("ml")
	self.anim:GetAnimState():SetBuild("ml")

    self.num = self:AddChild(Text(BODYTEXTFONT, 26))
    self.num:SetHAlign(ANCHOR_MIDDLE)
    self.num:SetPosition(3, -52, 0)

	self:StartUpdating()
end)

function ml:OnUpdate(dt)
	local newnum = self.owner.components.ml.current
	--local oldnum = self.point
	self.point = newnum
	--if newnum ~= oldnum then
		self.anim:GetAnimState():SetPercent("anim", newnum/100 * .99)
	--end

	self.num:SetString( tostring( math.ceil(newnum) ).."\0" )
end

return ml