assets =
{
	Asset("ANIM", "anim/meat_k.zip"),
	Asset("IMAGE", "images/inventoryimages/meat_k.tex"),
	Asset("ATLAS", "images/inventoryimages/meat_k.xml"),
}
local prefabs = 
	{
	"spoiled_food"
	}


local function fn()
	local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("monstermeat")
    inst.AnimState:SetBuild("meat_k")
    inst.AnimState:PlayAnimation("idle")

if SaveGameIndex:IsModeShipwrecked() then
	MakeInventoryFloatable(inst, "idle_water", "idle")
end
	
	inst:AddComponent("inspectable")

    inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/meat_k.xml"
	
	inst:AddComponent("tradable")
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = 50
	inst.components.edible.hungervalue = 40
	inst.components.edible.sanityvalue = 10
	inst.components.edible.foodtype = "VEGGIE"
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_PRESERVED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
	return inst
end


return Prefab( "common/inventory/meat_k", fn, assets, prefabs)