--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆
--◆◆[[Author: JinYering]]
--◆◆[[E-Mail: jin_yering@naver.com]]
--◆◆[[WhaRang The Millennium Fox]]
--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆--◆◆

local Assets =
{
	 Asset("ANIM",			"anim/fox_campfire_fire.zip"),
	 Asset("ANIM",			"anim/fox_campfire_coldfire_build.zip"),
	 Asset("SOUND",			"sound/common.fsb"),
}

local heats = {-15, -25, -35, -45}
local function GetHeatFn(inst)
	return heats[inst.components.firefx.level] or -20
end

local function fn(Sim)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local light = inst.entity:AddLight()

    anim:SetBank("fox_campfire_fire")
    anim:SetBuild("fox_campfire_coldfire_build")
	anim:SetBloomEffectHandle("shaders/anim.ksh")
    
    inst:AddTag("fx")

    inst:AddComponent("heater")
    inst.components.heater.heatfn = GetHeatFn
    inst.components.heater.iscooler = true

    inst:AddComponent("firefx")
    inst.components.firefx.levels =
    {
        {anim="level1", sound="dontstarve/common/campfire", radius=2, intensity=.8, falloff=.33, colour = {0, 183/255, 1}, soundintensity=.1},
        {anim="level2", sound="dontstarve/common/campfire", radius=3, intensity=.8, falloff=.33, colour = {0, 183/255, 1}, soundintensity=.3},
        {anim="level3", sound="dontstarve/common/campfire", radius=4, intensity=.8, falloff=.33, colour = {0, 183/255, 1}, soundintensity=.6},
        {anim="level3", sound="dontstarve/common/campfire", radius=5, intensity=.8, falloff=.33, colour = {0, 183/255, 1}, soundintensity=1},
    }
    
    anim:SetFinalOffset(-1)
    inst.components.firefx:SetLevel(1)
    inst.components.firefx.usedayparamforsound = true
    return inst
end

return Prefab( "common/fx/firepit_chill_fire", fn, Assets)