local assets=
{
    Asset("ANIM", "anim/gumifan.zip"),
    Asset("ANIM", "anim/swap_gumifan.zip"),
    Asset("ATLAS", "images/inventoryimages/gumifan.xml"),
}

local prefabs = {}

local function onfinished(inst)
local handfan = SpawnPrefab("handfan")
if handfan then
local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner or nil
local pt = Vector3(inst.Transform:GetWorldPosition())
local holder = owner and ( owner.components.inventory or owner.components.container) 
local slot = holder and holder:GetItemSlot(inst)			
inst:Remove()
        if holder then
        holder:Equip(handfan, slot)
        else
        handfan.Transform:SetPosition(pt:Get())
end
end
end

local function spawntornado(staff, target, pos)
    local tornado = SpawnPrefab("tornado")
    tornado.WINDSTAFF_CASTER = staff.components.inventoryitem.owner
    local spawnPos = staff:GetPosition() + TheCamera:GetDownVec()
    local totalRadius = target.Physics and target.Physics:GetRadius() or 0.5 + tornado.Physics:GetRadius() + 0.5
    local targetPos = target:GetPosition() + (TheCamera:GetDownVec() * totalRadius)
    tornado.Transform:SetPosition(getspawnlocation(staff, target):Get())
    tornado.components.knownlocations:RememberLocation("target", targetPos)

    staff.components.finiteuses:Use(1)
end

local framechance = .3

local function onattack(inst, attacker, target)

if math.random() < framechance and target.components.burnable and target.sg and not target.sg:HasStateTag("frozen") and not target:HasTag("wall") and not target:HasTag("structure") and target.sg.sg.states.hit then
        target.sg:GoToState("hit")
        target.components.burnable:Ignite()
end
if target.components.burnable and target.components.burnable:IsBurning() then
        target.components.burnable:Extinguish()
end
if target.components.combat then
        target.components.combat:SuggestTarget(attacker)
end
if target.components.sleeper and target.components.sleeper:IsAsleep() then
        target.components.sleeper:WakeUp()
end
if target.components.freezable then
        target.components.freezable:AddColdness(-1)
		
if target.components.freezable:IsFrozen() then
        target.components.freezable:Unfreeze()            
end
end
end

local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_gumifan", "swap_gumifan")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
		owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
end
 
local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
end

local function fn()
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
	
    MakeInventoryPhysics(inst)
    
    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon("gumifan.tex")
	
    anim:SetBank("gumifan")
    anim:SetBuild("gumifan")
    anim:PlayAnimation("idle")
	
    inst:AddComponent("weapon")
	inst.components.weapon:SetOnAttack(onattack)
	inst.components.weapon:SetDamage(55)
	inst.components.weapon:SetRange(2)
	inst:AddTag("sharp")
	inst:AddTag("gumifan")
	
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(250)
    inst.components.finiteuses:SetUses(250)
    inst.components.finiteuses:SetOnFinished(onfinished)
 
    inst:AddComponent("inspectable")
	inst.components.inspectable:RecordViews()
	
	inst:AddTag("irreplaceable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/gumifan.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( OnEquip )
    inst.components.equippable:SetOnUnequip( OnUnequip )
	
    inst:AddComponent("talker")
    --inst.components.talker.ontalk = ontalk

    inst.components.talker.fontsize = 26
    inst.components.talker.font = TALKINGFONT
    inst.components.talker.colour = Vector3(.9, .4, .4, 1)
    inst.components.talker.offset = Vector3(0,0,0)
    inst.components.talker.symbol = "swap_object"
    
	if GetPlayer().prefab == "wharang" then
	
    inst:AddComponent("sentientfan")
    
    inst:ListenForEvent("donetalking", function() inst.SoundEmitter:KillSound("talk") end)
    inst:ListenForEvent("ontalk", function() 
		if inst.components.sentientfan.sound_override then
			inst.SoundEmitter:KillSound("talk")
			inst.SoundEmitter:PlaySound(inst.components.sentientfan.sound_override, "special")
		else
			if not inst.SoundEmitter:PlayingSound("special") then
				inst.SoundEmitter:PlaySound("wharangfan/fan/fan_LP", "talk")
			end
		end
	end)
	end
 
    return inst
end

return  Prefab("common/inventory/gumifan", fn, assets)