require "prefabutil"

local function test_ground(inst, pt)
	local tiletype = GetGroundTypeAtPosition(pt)
	return tiletype == GROUND.DIRT or inst.data.tile == "webbing"
end

local function ondeploy(inst, pt, deployer)
	if deployer and deployer.SoundEmitter then
		deployer.SoundEmitter:PlaySound("dontstarve/wilson/dig")
	end

	local ground = GetWorld()
	if ground then
		local original_tile_type = ground.Map:GetTileAtPoint(pt.x, pt.y, pt.z)
		local x, y = ground.Map:GetTileCoordsAtPoint(pt.x, pt.y, pt.z)
		if x and y then
			ground.Map:SetTile(x,y, inst.data.tile)
			ground.Map:RebuildLayer( original_tile_type, x, y )
			ground.Map:RebuildLayer( inst.data.tile, x, y )
		end

		local minimap = TheSim:FindFirstEntityWithTag("minimap")
		if minimap then
			minimap.MiniMap:RebuildLayer( original_tile_type, x, y )
			minimap.MiniMap:RebuildLayer( inst.data.tile, x, y )
		end
	end
	
	inst.components.stackable:Get():Remove()
end


local assets =
{
	Asset("ANIM", "anim/wharang_turf.zip"),
	Asset("ATLAS", "images/inventoryimages/turf_flamerose.xml")
}
	
local prefabs =
{
	"gridplacer",
}

local data = {name = "flamerose", anim = "flamerose", tile = GROUND.FLAMEROSE}
	
local function fn(Sim)

	local inst = CreateEntity()
	inst:AddTag("groundtile")
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	MakeInventoryPhysics(inst)
		
	inst.AnimState:SetBank("wharang_turf")
	inst.AnimState:SetBuild("wharang_turf")
	inst.AnimState:PlayAnimation(data.anim)

	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM
		
	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/turf_flamerose.xml"

	inst.data = data
	
	inst:AddComponent("bait")
	inst:AddTag("molebait")
	
	inst:AddTag("asia")
	
	inst:AddComponent("fuel")
	inst.components.fuel.fuelvalue = TUNING.MED_FUEL
	MakeMediumBurnable(inst, TUNING.MED_BURNTIME)
	MakeSmallPropagator(inst)
		
	inst:AddComponent("deployable")
	--inst.components.deployable.test = function() return true end
	inst.components.deployable.ondeploy = ondeploy
	inst.components.deployable.test = test_ground
	inst.components.deployable.min_spacing = 0
	inst.components.deployable.placer = "gridplacer"

	---------------------  
	return inst	  
end

return Prefab( "common/objects/turf_"..data.name, fn, assets, prefabs)