require("stategraphs/commonstates")

local actionhandlers = 
{
}

local events=
{
    CommonHandlers.OnStep(),
    CommonHandlers.OnSleep(),
    CommonHandlers.OnLocomote(false,true),
    EventHandler("attacked", function(inst)
        if inst.components.health and not inst.components.health:IsDead() then
            inst.sg:GoToState("hit")
            inst.SoundEmitter:PlaySound("miho/miho/close")
        end
    end),
    EventHandler("death", function(inst) inst.sg:GoToState("death") end),
}

local states=
{
    State{
        name = "idle",
        tags = {"idle", "canrotate"},
        
        onenter = function(inst, pushanim)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("idle_loop")
			end,
            
            --[[if not inst.sg.mem.pant_ducking or inst.sg:InNewState() then
				inst.sg.mem.pant_ducking = 1
			end
        end,]]
        
        events=
        {
            EventHandler("animover", function(inst) inst.sg:GoToState("idle") end),
        },

        --[[timeline=
        {
            TimeEvent(7*FRAMES, function(inst) 
				--inst.sg.mem.pant_ducking = inst.sg.mem.pant_ducking or 1
				--inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/pant", nil, inst.sg.mem.pant_ducking) 
				--if inst.sg.mem.pant_ducking and inst.sg.mem.pant_ducking > .35 then
					--inst.sg.mem.pant_ducking = inst.sg.mem.pant_ducking - .05
				--end
			end),
        },   ]]     
   },
   
       State{
        name = "item",
        tags = {"busy"},
        onenter = function(inst)
            inst.Physics:Stop()
            inst.AnimState:PlayAnimation("food")
        end,
    },
}

CommonStates.AddWalkStates(states, {
    starttimeline =
    {
    },
    walktimeline = 
    { 
        --TimeEvent(0*FRAMES, function(inst)  end),
        TimeEvent(0*FRAMES, function(inst) 
            --inst.SoundEmitter:PlaySound("dontstarve/creatures/chester/boing")
			inst.SoundEmitter:PlaySound("dontstarve/movement/run_marble_small")
            inst.components.locomotor:RunForward() 
        end),
        --TimeEvent(12*FRAMES, function(inst) PlayFootstep(inst) end),
        TimeEvent(0*FRAMES, function(inst) 
            PlayFootstep(inst)
            inst.components.locomotor:WalkForward()
        end),
    }
}, nil, true)

CommonStates.AddSimpleState(states, "hit", "hit", {"busy"})

return StateGraph("moondumplings", states, events, "idle", actionhandlers)