Scriptname swordArmorSwordBlastRingScript extends ObjectReference Const

import Utility

ActorValue property HealthAV  Auto Const
ActorValue property AP  Auto Const

Weapon Property swordWeaponSwordBlast Auto Const
Ammo Property swordAmmoSwordBlast01 Auto Const
Ammo Property swordAmmoSwordBlast02 Auto Const

EffectShader Property swordFXSwordBlast  Auto Const
EffectShader Property swordFXPSArmor Auto Const

Sound Property swordSECharge  Auto Const
Sound Property swordSEPlasma01  Auto Const
Sound Property swordSEPlasma02  Auto Const
Sound Property swordSEPS  Auto Const
Sound Property swordSEPSAttacked01  Auto Const
Sound Property swordSEPSAttacked02  Auto Const
Sound Property swordSEPSAttacked03  Auto Const

GlobalVariable Property swordBlastAP  Auto Const
GlobalVariable Property swordBlastPSDuration  Auto Const

Event OnEquipped(Actor akActor)
	RegisterForAnimationEvent(akActor, "WeaponSwing") ; Before we can use OnAnimationEvent we must register.

	RegisterForAnimationEvent(akActor, "AttackRelease")
;	RegisterForAnimationEvent(akActor, "blockEnd")

	swordFXSwordBlast.Play(akActor, 1.0)
	swordSECharge.Play(akActor)

EndEvent

Event OnUnequipped(Actor akActor)
	UnregisterForAnimationEvent(akActor, "WeaponSwing")
	UnregisterForAnimationEvent(akActor, "AttackRelease")

endEvent

Event OnAnimationEvent(ObjectReference akSource, string asEventName)
	if asEventName == "WeaponSwing"
	
		float ActionPoint = swordBlastAP.getValue() as float 

		if akSource.GetValue(AP) as float >= ActionPoint 
			akSource.DamageValue(AP,ActionPoint)

			if RandomInt(0, 1) == 0
				swordWeaponSwordBlast.Fire(akSource, swordAmmoSwordBlast01)
			else
				swordWeaponSwordBlast.Fire(akSource, swordAmmoSwordBlast02)
			endif

			if RandomInt(0, 1) == 0
				swordSEPlasma01.Play(akSource)  
			else
				swordSEPlasma02.Play(akSource) 
			endIf
		endif
	endIf

	if asEventName == "AttackRelease"

		int index

		float life
		float Dummylife = 0.0
		float res 

		float ftimeStart = GetCurrentRealTime()
		float ftimeEnd = 0.0

		swordFXPSArmor.Play(akSource, swordBlastPSDuration.getValue() as float)
		swordSEPS.Play(akSource)    

		While ftimeEnd - ftimeStart < swordBlastPSDuration.getValue() as float 

			ftimeEnd = GetCurrentRealTime()

			life = akSource.GetValue(HealthAV) as float

			if life >= Dummylife 
				Dummylife = life 
			elseif life == Dummylife

			else
	
				res = Dummylife - life

				akSource.RestoreValue(HealthAV, res)
				Dummylife = akSource.GetValue(HealthAV) as float

				index = RandomInt(0, 2)
				if index == 1
					swordSEPSAttacked01.Play(akSource)  
				elseif  index == 2
					swordSEPSAttacked02.Play(akSource)
				else
					swordSEPSAttacked03.Play(akSource)
				endif


			endif
		endWhile 
	endIf

endEvent
