Scriptname swordWeaponFlameStrikeScript extends ObjectReference Const

import Math
import Utility

ActorValue property AP  Auto Const

Weapon Property swordWeaponFlameStrike  Auto Const

Explosion Property swordExplosionFlameStrike  Auto Const

Idle Property swordIdleFlameSwing Auto Const

ObjectReference Property Cast Auto Const

GlobalVariable Property SwordBlastFlameStrikeAP  Auto Const
GlobalVariable Property SwordBlastFlameStrikeLength  Auto Const

Event OnEquipped(Actor akActor)

	akActor.UnequipItem(swordWeaponFlameStrike,0, true)
	float ActionPoint = SwordBlastFlameStrikeAP.getValue() as float 

	if akActor.GetValue(AP) as float >= ActionPoint 
		akActor.DamageValue(AP,ActionPoint)

		; initial position vector
		float xPos
		float yPos  
		float zPos

		float xSourcePos = akActor.GetPositionX()
		float ySourcePos = akActor.GetPositionY()  
		float zSourcePos = akActor.GetPositionZ()

		; fly vector
		float dx
		float dy  
		float dz

		; private
		float ang  
		float xAng
		float yAng
		float zAng 
		float x1
		float x2  
		float sin  
		float cos  

		float ftimeStart = GetCurrentRealTime()
		float ftimeEnd = 0.0

		if !IsInMenuMode() 
			akActor.PlayIdle(swordIdleFlameSwing)
		endif

		ang = akActor.GetAngleZ()
		zang = ang

		if ang > 180
			ang = ang - 360
		endif

		x1 = ang*0.0174532925
		x2 = x1*x1
		sin = x1*(1-(x2/6)*(1-(x2/20)*(1-(x2/42)*(1-(x2/72)*(1-x2/110)))))
		cos = 1-(0.5)*x2*(1-(x2/12)*(1-(x2/30)*(1-(x2/56)*(1-x2/90))))
		dx = 10*sin
		dy = 10*cos

		; vertical fly vector
		ang = akActor.GetAngleX()
		xang = ang*cos ; uses settings from Horizontal Vector
		yang = -ang*sin

		x1 = -ang*0.0174532925

		x2 = x1*x1
		sin = x1*(1-(x2/6)*(1-(x2/20)*(1-(x2/42)*(1-(x2/72)*(1-x2/110)))))
		cos = 1-(0.5)*x2*(1-(x2/12)*(1-(x2/30)*(1-(x2/56)*(1-x2/90))))
		dz = 10*sin

		While ftimeEnd - ftimeStart < 1.0
			ftimeEnd = GetCurrentRealTime()
		endWhile 
	
		int index = 1

		While index <= SwordBlastFlameStrikeLength.getValue() as int

			; initial position vector (to add to player coords)
			xPos = 20*index*dx*cos
			yPos = 20*index*dy*cos
			zPos = 108+20*index*dz
			
			Cast.SetPosition(xSourcePos+xPos , ySourcePos+yPos , zSourcePos+zPos)
			Cast.placeatme(swordExplosionFlameStrike)

			index += 1

		endWhile 

	endif

EndEvent
