Scriptname swordWeaponGateofSynthScript extends ObjectReference Const

import Math
import Utility

ActorValue property AP  Auto Const

Weapon Property swordWeaponGateofSynth  Auto Const

Idle Property GoBIdle Auto Const

Activator Property swordActivatorLaserWorks01  Auto Const
Activator Property swordActivatorLaserWorks02  Auto Const
Activator Property swordActivatorLaserWorks03  Auto Const
Activator Property swordActivatorLaserWorks04  Auto Const

Activator Property swordActivatorLaserTrigger  Auto Const

GlobalVariable Property swordBlastGateofSynthAP Auto Const

Event OnEquipped(Actor akActor)

	akActor.UnequipItem(swordWeaponGateofSynth,0, true)

	Actor PlayerActor = Game.GetPlayer()
	float ActionPoint = swordBlastGateofSynthAP.getValue() as float 

	if akActor.GetValue(AP) as float >= ActionPoint 
		akActor.DamageValue(AP,ActionPoint)

		float xMove
		float yMove
		float rXMove
		float rYMove

		; initial position vector
		float xPos
		float yPos
		float zPos

		; fly vector
		float dx
		float dy  
		float dz

		; private
		float ang  
		float xAng
		float yAng
		float zAng 
		float z2Ang 
		float x1
		float x2  
		float sin  
		float cos 

		if !IsInMenuMode() 
			akActor.PlayIdle(GoBIdle)
		endif

		ObjectReference Cast
		ObjectReference Gun

		int index = 1
		int indexGun
		int indexMax = 4 + PlayerActor.GetLevel() / 3

		if  indexMax > 12
			indexMax = 12
		endif

		ang = akActor.GetAngleZ()
		zAng = ang

		if ang > 180
			ang = ang - 360
		endif

		x1 = ang*0.0174532925
		x2 = x1*x1
		sin = x1*(1-(x2/6)*(1-(x2/20)*(1-(x2/42)*(1-(x2/72)*(1-x2/110)))))
		cos = 1-(0.5)*x2*(1-(x2/12)*(1-(x2/30)*(1-(x2/56)*(1-x2/90))))
		dx = 10*sin
		dy = 10*cos

		; vertical fly vector
		ang = akActor.GetAngleX()
		xAng = ang*cos ; uses settings from Horizontal Vector
		yAng = -ang*sin

		While index <= indexMax 

			if (index % 3) == 1
				xMove = RandomInt(75, 675)
				zPos = RandomInt(45, 155)
			elseif (index % 3) == 2
				xMove = RandomInt(-75, -675)
				zPos = RandomInt(45, 155)
			else
				xMove = RandomInt(-675, 675)
				zPos = RandomInt(155, 225)
			endif
			yMove = -100

			z2Ang = akActor.getAngleZ()

			rXMove = (math.Sin(z2Ang) * yMove)+(math.Cos(z2Ang) * xMove)
			rYMove = (math.Cos(z2Ang) * yMove)-(math.Sin(z2Ang) * xMove)

			xPos = rXMove
			yPos = rYMove
	
			indexGun = RandomInt(0, 3)
			if indexGun == 0
				Gun = akActor.PlaceAtMe(swordActivatorLaserWorks01)
				Cast = akActor.PlaceAtMe(swordActivatorLaserTrigger)
			elseif indexGun == 1
				Gun = akActor.PlaceAtMe(swordActivatorLaserWorks02)
				Cast = akActor.PlaceAtMe(swordActivatorLaserTrigger)
			elseif indexGun == 2
				Gun = akActor.PlaceAtMe(swordActivatorLaserWorks03)
				Cast = akActor.PlaceAtMe(swordActivatorLaserTrigger)
			else
				Gun = akActor.PlaceAtMe(swordActivatorLaserWorks04)
				Cast = akActor.PlaceAtMe(swordActivatorLaserTrigger)
			endIf

			Gun.MoveTo(akActor, xPos , yPos , zPos , true)
			Gun.setAngle(xAng, yAng, zAng)
			Gun.Activate(PlayerActor)

			Cast.MoveTo(akActor, xPos , yPos , zPos , true)
			Cast.Activate(PlayerActor)

			if akActor.GetValue(AP) as float >= ActionPoint 
				akActor.DamageValue(AP,ActionPoint)
				index += 1
			else
				index = 100
			endif

		endWhile 

	endif

EndEvent
