Scriptname swordWeaponJudgementCutScript extends ObjectReference Const

import Utility

ActorValue property AP  Auto Const
ActorValue property healthAV  Auto Const

Weapon Property swordWeaponJudgementCut  Auto Const

Sound Property swordSEJudgementCut01  Auto Const
Sound Property swordSEJudgementCut02  Auto Const

GlobalVariable Property swordBlastDamageRate  Auto Const
GlobalVariable Property swordJudgementCutAP  Auto Const
GlobalVariable Property swordLockOnRadius  Auto const

;Spell Property swordSpellJudgementCut  Auto const

EffectShader property MagicEffectShader auto const

Explosion Property swordExplosionJudgementCut  Auto Const

;swordQuestLockOnScript Property LockOn Auto Const

Event OnEquipped(Actor akActor)

	Actor PlayerActor = Game.GetPlayer()
	akActor.UnequipItem(swordWeaponJudgementCut,0, true)

	int index
	Actor target 
	float Radius = swordLockOnRadius.getValue() as float

	float ftimeStart = GetCurrentRealTime()
	float ftimeEnd = 0.0

	while index < 5 &&  ftimeEnd - ftimeStart < 2.0

		ftimeEnd = GetCurrentRealTime()
		Target = Game.FindRandomActorFromRef(PlayerActor , Radius)

		if Target != PlayerActor && Target.IsHostileToActor(PlayerActor) && !Target.isDead()
			float ActionPoint = swordJudgementCutAP.getValue() as float 

			if akActor.GetValue(AP) as float >= ActionPoint 

				float Damage = 12 + (PlayerActor.GetLevel() / 2)
				Damage *= swordBlastDamageRate.getValue() as float

				akActor.DamageValue(AP,ActionPoint)
				Target.DamageValue(healthAV,Damage)

				if RandomInt(0, 1) == 0
					swordSEJudgementCut01.Play(akActor)  
				else
					swordSEJudgementCut02.Play(akActor) 
				endIf

;				swordSpellJudgementCut.RemoteCast(Target, PlayerActor) 	

				MagicEffectShader.play(Target, 1.0)
				Target.placeatme(swordExplosionJudgementCut)
				index += 1

;				Target.PushActorAway(Target, 10.0)
			endif
		endif

	endWhile
	
EndEvent



