Scriptname swordWeaponReignofFireScript extends ObjectReference Const

import Math
import Utility

ActorValue property AP  Auto Const

Weapon Property swordWeaponReignofFire  Auto Const

ActorBase Property swordActorReignofFire Auto Const

Idle Property RoFIdle Auto Const

GlobalVariable Property swordBlastReignofFireAP Auto Const

Event OnEquipped(Actor akActor)

	akActor.UnequipItem(swordWeaponReignofFire,0, true)

	Actor PlayerActor = Game.GetPlayer()
	float ActionPoint = swordBlastReignofFireAP.getValue() as float 

	if akActor.GetValue(AP) as float >= ActionPoint 
		akActor.DamageValue(AP,ActionPoint)

		float xMove
		float yMove
		float rXMove
		float rYMove

		; initial position vector
		float xPos
		float yPos
		float zPos

		float zAng 
		ObjectReference Cast

		if !IsInMenuMode() 
			akActor.PlayIdle(RoFIdle)
		endif

		xMove = RandomInt(-2000, 2000)
		yMove = RandomInt(-1000, -2000)
		zPos = RandomInt(3800, 4200)

		zAng = akActor.getAngleZ()

		rXMove = (math.Sin(zAng) * yMove)+(math.Cos(zAng) * xMove)
		rYMove = (math.Cos(zAng) * yMove)-(math.Sin(zAng) * xMove)

		xPos = rXMove
		yPos = rYMove
	
		Cast = akActor.PlaceAtMe(swordActorReignofFire)
		Cast.MoveTo(akActor, xPos , yPos , zPos , true)		

	endif

EndEvent
