/*
 * Decompiled with CFR 0.152.
 */
package net.infotrek.util.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import net.infotrek.util.prefs.FilePreferencesFactory;

public class FilePreferences
extends AbstractPreferences {
    private static final Logger log = Logger.getLogger(FilePreferences.class.getName());
    private Map<String, String> root;
    private Map<String, FilePreferences> children;
    private boolean isRemoved = false;

    public FilePreferences(AbstractPreferences parent, String name) {
        super(parent, name);
        log.finest("Instantiating node " + name);
        this.root = new TreeMap<String, String>();
        this.children = new TreeMap<String, FilePreferences>();
        try {
            this.sync();
        }
        catch (BackingStoreException e) {
            log.log(Level.SEVERE, "Unable to sync on creation of node " + name, e);
        }
    }

    @Override
    protected void putSpi(String key, String value) {
        this.root.put(key, value);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            log.log(Level.SEVERE, "Unable to flush after putting " + key, e);
        }
    }

    @Override
    protected String getSpi(String key) {
        return this.root.get(key);
    }

    @Override
    protected void removeSpi(String key) {
        this.root.remove(key);
        try {
            this.flush();
        }
        catch (BackingStoreException e) {
            log.log(Level.SEVERE, "Unable to flush after removing " + key, e);
        }
    }

    @Override
    protected void removeNodeSpi() throws BackingStoreException {
        this.isRemoved = true;
        this.flush();
    }

    @Override
    protected String[] keysSpi() throws BackingStoreException {
        return this.root.keySet().toArray(new String[this.root.keySet().size()]);
    }

    @Override
    protected String[] childrenNamesSpi() throws BackingStoreException {
        return this.children.keySet().toArray(new String[this.children.keySet().size()]);
    }

    @Override
    protected FilePreferences childSpi(String name) {
        FilePreferences child = this.children.get(name);
        if (child == null || child.isRemoved()) {
            child = new FilePreferences(this, name);
            this.children.put(name, child);
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void syncSpi() throws BackingStoreException {
        if (this.isRemoved()) {
            return;
        }
        File file = FilePreferencesFactory.getPreferencesFile();
        if (!file.exists()) {
            return;
        }
        File file2 = file;
        synchronized (file2) {
            Properties p = new Properties();
            try {
                p.load(new FileInputStream(file));
                StringBuilder sb = new StringBuilder();
                this.getPath(sb);
                String path = sb.toString();
                Enumeration<?> pnen = p.propertyNames();
                while (pnen.hasMoreElements()) {
                    String subKey;
                    String propKey = (String)pnen.nextElement();
                    if (!propKey.startsWith(path) || (subKey = propKey.substring(path.length())).indexOf(46) != -1) continue;
                    this.root.put(subKey, p.getProperty(propKey));
                }
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
    }

    private void getPath(StringBuilder sb) {
        FilePreferences parent = (FilePreferences)this.parent();
        if (parent == null) {
            return;
        }
        parent.getPath(sb);
        sb.append(this.name()).append('.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void flushSpi() throws BackingStoreException {
        File file;
        File file2 = file = FilePreferencesFactory.getPreferencesFile();
        synchronized (file2) {
            Properties p = new Properties();
            try {
                StringBuilder sb = new StringBuilder();
                this.getPath(sb);
                String path = sb.toString();
                if (file.exists()) {
                    p.load(new FileInputStream(file));
                    ArrayList<String> toRemove = new ArrayList<String>();
                    Enumeration<?> pnen = p.propertyNames();
                    while (pnen.hasMoreElements()) {
                        String subKey;
                        String propKey = (String)pnen.nextElement();
                        if (!propKey.startsWith(path) || (subKey = propKey.substring(path.length())).indexOf(46) != -1) continue;
                        toRemove.add(propKey);
                    }
                    for (String propKey : toRemove) {
                        p.remove(propKey);
                    }
                }
                if (!this.isRemoved) {
                    for (String s : this.root.keySet()) {
                        p.setProperty(path + s, this.root.get(s));
                    }
                }
                p.store(new FileOutputStream(file), "FilePreferences");
            }
            catch (IOException e) {
                throw new BackingStoreException(e);
            }
        }
    }
}

