/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import restringer.LittleEndianInput;

public class BoundedLittleEndianInput
extends LittleEndianInput {
    private final InputStream ORIGINAL;
    final int BOUND;
    int position;

    public BoundedLittleEndianInput(InputStream original, int bound) {
        this.ORIGINAL = Objects.requireNonNull(original);
        this.BOUND = bound;
        this.position = 0;
    }

    @Override
    public int available() throws IOException {
        int remaining = this.BOUND - this.position;
        assert (remaining >= 0);
        return remaining;
    }

    @Override
    public int read() throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        ++this.position;
        return this.ORIGINAL.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.available() <= 0) {
            return -1;
        }
        if (this.available() < len) {
            int bytesRead = this.ORIGINAL.read(b, off, this.available());
            assert (bytesRead == this.available()) : "Expected " + len + " but read " + bytesRead;
            this.position += bytesRead;
            return bytesRead;
        }
        int bytesRead = this.ORIGINAL.read(b, off, len);
        assert (bytesRead == len) : "Expected " + len + " but read " + bytesRead;
        this.position += bytesRead;
        return bytesRead;
    }

    @Override
    public int skipBytes(int n) throws IOException {
        int limit = Math.min(n, this.available());
        for (int i = 0; i < limit; ++i) {
            this.read();
        }
        return limit;
    }

    public String toString() {
        return String.format("Stream %d / %d (%s)", this.position, this.BOUND, this.ORIGINAL);
    }
}

