/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Objects;

public final class ComparatorInputStream
extends InputStream
implements Closeable {
    private final InputStream CURRENT;
    private final InputStream ORIGINAL;
    private final LinkedList<Byte> CONTEXT;
    private long position;
    private int skips;

    public ComparatorInputStream(InputStream current, InputStream original) {
        this(current, original, 0);
    }

    public ComparatorInputStream(InputStream current, InputStream original, int skips) {
        this.CURRENT = Objects.requireNonNull(current);
        this.ORIGINAL = Objects.requireNonNull(original);
        this.position = 0L;
        this.CONTEXT = new LinkedList();
        this.setSkips(skips);
    }

    @Override
    public int read() throws IOException {
        int originalByte;
        int currentByte = this.CURRENT.read();
        if ((byte)currentByte != (byte)(originalByte = this.ORIGINAL.read())) {
            if (this.skips > 0) {
                --this.skips;
            } else {
                StringBuilder context = new StringBuilder();
                this.CONTEXT.forEach(b -> context.append(String.format("%02x ", b)));
                throw new Mismatch(this.position, originalByte, currentByte, context.toString());
            }
        }
        ++this.position;
        this.CONTEXT.addLast((byte)originalByte);
        if (this.CONTEXT.size() > 32) {
            this.CONTEXT.removeFirst();
        }
        return currentByte;
    }

    @Override
    public int available() throws IOException {
        return this.CURRENT.available();
    }

    public void setSkips(int newSkips) {
        if (newSkips < 0) {
            throw new IllegalArgumentException("skips must be nonnegative.");
        }
        this.skips = newSkips;
    }

    public static final class Mismatch
    extends IOException {
        private final long POSITION;
        private final int ORIGINALBYTE;
        private final int WRITEBYTE;
        private final String CONTEXT;
        private static final String MSG = "Mismatch at %d: expected %02x but found %02x. Context:\n%s";

        private Mismatch(long position, int originalByte, int writeByte, String context) {
            super(String.format(MSG, position, originalByte, writeByte, context));
            this.POSITION = position;
            this.ORIGINALBYTE = originalByte;
            this.WRITEBYTE = writeByte;
            this.CONTEXT = context;
        }

        public long getPosition() {
            return this.POSITION;
        }

        public int getOriginal() {
            return this.ORIGINALBYTE;
        }

        public int getWritten() {
            return this.WRITEBYTE;
        }

        public String getContext() {
            return this.CONTEXT;
        }
    }
}

