/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class ComparatorOutputStream
extends OutputStream
implements Closeable {
    private final OutputStream CURRENT;
    private final InputStream ORIGINAL;
    private final LinkedList<Integer> CURR_CTX;
    private final LinkedList<Integer> ORIG_CTX;
    private long position;
    private int skips;

    public ComparatorOutputStream(InputStream original) {
        this(null, original, 0);
    }

    public ComparatorOutputStream(OutputStream current, InputStream original) {
        this(current, original, 0);
    }

    public ComparatorOutputStream(OutputStream current, InputStream original, int skips) {
        this.CURRENT = current;
        this.ORIGINAL = Objects.requireNonNull(original);
        this.position = 0L;
        this.CURR_CTX = new LinkedList();
        this.ORIG_CTX = new LinkedList();
        this.setSkips(skips);
    }

    @Override
    public void write(int b) throws IOException {
        int writeByte = 0xFF & b;
        int originalByte = this.ORIGINAL.read();
        this.updateContext(originalByte, writeByte);
        if (null != this.CURRENT) {
            this.CURRENT.write(writeByte);
        }
        if ((byte)writeByte != (byte)originalByte) {
            if (this.skips > 0) {
                --this.skips;
            } else {
                String ctxMsg = this.generateContextString();
                throw new Mismatch(this.position, originalByte, writeByte, ctxMsg);
            }
        }
        ++this.position;
    }

    public void setSkips(int newSkips) {
        if (newSkips < 0) {
            throw new IllegalArgumentException("skips must be nonnegative.");
        }
        this.skips = newSkips;
    }

    private String generateContextString() {
        assert (this.CURR_CTX.size() > 0);
        assert (this.CURR_CTX.size() == this.ORIG_CTX.size());
        int POS = this.CURR_CTX.size() - 1;
        try {
            for (int i2 = 0; i2 < 8 && this.ORIGINAL.available() > 0; ++i2) {
                int b = this.ORIGINAL.read();
                this.ORIG_CTX.add(b);
            }
        }
        catch (IOException i2) {
            // empty catch block
        }
        List origLeft = this.ORIG_CTX.subList(0, POS);
        List origRight = this.ORIG_CTX.subList(POS + 1, this.ORIG_CTX.size());
        List currLeft = this.CURR_CTX.subList(0, POS);
        int origByte = this.ORIG_CTX.get(POS);
        int currByte = this.CURR_CTX.get(POS);
        String origLeftStr = origLeft.stream().map(i -> String.format("%02x", i)).collect(Collectors.joining(" "));
        String origRightStr = origRight.stream().map(i -> String.format("%02x", i)).collect(Collectors.joining(" "));
        String currLeftStr = currLeft.stream().map(i -> String.format("%02x", i)).collect(Collectors.joining(" "));
        String origByteStr = String.format("%02x", origByte);
        String currByteStr = String.format("%02x", currByte);
        StringBuilder BUF = new StringBuilder();
        BUF.append("Original: ").append(origLeftStr).append("[").append(origByteStr).append("]").append(origRightStr).append("\n").append("Current : ").append(currLeftStr).append("[").append(currByteStr).append("]");
        return BUF.toString();
    }

    private void updateContext(int originalByte, int writeByte) {
        this.ORIG_CTX.addLast(originalByte);
        this.CURR_CTX.addLast(writeByte);
        while (this.CURR_CTX.size() > 16) {
            this.CURR_CTX.removeFirst();
        }
        while (this.ORIG_CTX.size() > 16) {
            this.ORIG_CTX.removeFirst();
        }
    }

    public static final class Mismatch
    extends IOException {
        private final long POSITION;
        private final int ORIGINALBYTE;
        private final int WRITEBYTE;
        private final String CONTEXT;
        private static final String MSG = "Mismatch at %d: expected %02x but found %02x. Context:\n%s";

        private Mismatch(long position, int originalByte, int writeByte, String context) {
            super(String.format(MSG, position, (byte)originalByte, (byte)writeByte, context));
            this.POSITION = position;
            this.ORIGINALBYTE = originalByte;
            this.WRITEBYTE = writeByte;
            this.CONTEXT = context;
        }

        public long getPosition() {
            return this.POSITION;
        }

        public int getOriginal() {
            return this.ORIGINALBYTE;
        }

        public int getWritten() {
            return this.WRITEBYTE;
        }

        public String getContext() {
            return this.CONTEXT;
        }
    }
}

