/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;

public class DebuggingInputStream
extends InputStream
implements Closeable {
    private final InputStream INPUT;
    private final PrintStream OUTPUT;
    private int offset;
    private int width;
    private int position;

    public DebuggingInputStream(InputStream input, PrintStream output) {
        this(input, output, 32);
    }

    public DebuggingInputStream(InputStream input, PrintStream output, int width) {
        if (null == input) {
            throw new NullPointerException("The inputstream must not be null.");
        }
        if (width < 1) {
            throw new IllegalArgumentException("The line width must be greater than zero.");
        }
        this.INPUT = input;
        this.OUTPUT = output;
        this.offset = 0;
        this.width = width;
        this.position = 0;
    }

    @Override
    public int read() throws IOException {
        int val = this.INPUT.read();
        if (null != this.OUTPUT) {
            if (this.offset == 0) {
                this.OUTPUT.printf("%08x:  ", this.position);
            }
            this.OUTPUT.printf("%02x ", val);
            ++this.position;
            ++this.offset;
            if (this.offset >= this.width) {
                this.offset = 0;
                this.OUTPUT.println();
            }
        }
        return val;
    }

    @Override
    public void close() throws IOException {
        this.INPUT.close();
    }

    @Override
    public int available() throws IOException {
        return this.INPUT.available();
    }
}

