/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javafx.stage.FileChooser;
import javax.swing.filechooser.FileNameExtensionFilter;

public enum Game {
    SKYRIM_LE("Skyrim Legendary Edition", "Skyrim Savefile", "ess", "skse", "skyrim", "tesv.exe"),
    SKYRIM_SE("Skyrim Special Edition", "Skyrim SE Savefile", "ess", "ssse", "skyrim special edition", "skyrimse.exe"),
    FALLOUT4("Fallout 4", "Fallout 4 Savefile", "fos", "f4se", "fallout 4", "fallout4.exe");

    public final String NAME;
    public final String EXT;
    public final Pattern REGEX;
    public final String SCRIPTEXT;
    public final String DIR;
    public final String EXE;
    public final FileNameExtensionFilter SWING_FILTER;
    public final FileChooser.ExtensionFilter FX_FILTER;
    public static List<Game> VALUES;

    public static Game matchFilename(String filename) {
        for (Game game : VALUES) {
            if (!game.REGEX.asPredicate().test(filename)) continue;
            return game;
        }
        return null;
    }

    public boolean testFilename(File f) {
        return this.REGEX.asPredicate().test(f.getName());
    }

    public boolean isStr32() {
        return this.isSSE() || this.isFO4();
    }

    public boolean isID64() {
        return this.isSSE() || this.isFO4();
    }

    public boolean isFO4() {
        return this == FALLOUT4;
    }

    public boolean isSkyrim() {
        return this.isSSE() || this.isSLE();
    }

    public boolean isSSE() {
        return this == SKYRIM_SE;
    }

    public boolean isSLE() {
        return this == SKYRIM_LE;
    }

    private Game(String name, String save, String extension, String scriptExt, String dir, String exe) {
        this.NAME = name;
        this.EXT = extension;
        this.SCRIPTEXT = scriptExt;
        this.DIR = dir;
        this.EXE = exe;
        this.REGEX = Pattern.compile(String.format(".+\\.(%s)", extension), 2);
        this.SWING_FILTER = new FileNameExtensionFilter(save, extension);
        this.FX_FILTER = new FileChooser.ExtensionFilter(save, new String[]{"*." + extension});
    }

    static {
        VALUES = Collections.unmodifiableList(Arrays.asList(Game.values()));
    }
}

