/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class IString
implements CharSequence,
Serializable,
Comparable<IString> {
    public static final IString BLANK = new IString();
    private final String STRING;
    private final int HASHCODE;
    private static final Map<String, IString> CACHE = new ConcurrentHashMap<String, IString>(65536);

    public static IString get(String val) {
        return CACHE.computeIfAbsent(val, v -> new IString(v.intern()));
    }

    protected IString(String val) {
        this.STRING = Objects.requireNonNull(val);
        this.HASHCODE = this.STRING.toLowerCase().hashCode();
    }

    protected IString(CharSequence val) {
        this.STRING = Objects.requireNonNull(val.toString());
        this.HASHCODE = this.STRING.toLowerCase().hashCode();
    }

    protected IString(IString other) {
        Objects.requireNonNull(other);
        this.STRING = other.STRING;
        this.HASHCODE = other.HASHCODE;
    }

    private IString() {
        this("".intern());
    }

    @Override
    public boolean isEmpty() {
        return this.STRING.isEmpty();
    }

    @Override
    public int length() {
        return this.STRING.length();
    }

    @Override
    public char charAt(int index) {
        return this.STRING.charAt(index);
    }

    @Override
    public IString subSequence(int start, int end) {
        return new IString(this.STRING.substring(start, end));
    }

    public byte[] getBytes() {
        return this.STRING.getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public String toString() {
        return this.STRING;
    }

    public int hashCode() {
        return this.HASHCODE;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IString) {
            return this.equals((IString)obj);
        }
        if (obj instanceof String) {
            return this.equals((String)obj);
        }
        return super.equals(obj);
    }

    public boolean equals(String other) {
        Objects.requireNonNull(other);
        return this.STRING.equalsIgnoreCase(other);
    }

    public boolean equals(IString other) {
        Objects.requireNonNull(other);
        if (this.HASHCODE != other.hashCode()) {
            return false;
        }
        return this.STRING.equalsIgnoreCase(other.toString());
    }

    @Override
    public int compareTo(IString o) {
        return Objects.compare(this.STRING, o.STRING, String::compareToIgnoreCase);
    }

    public boolean matches(String regex) {
        return Pattern.compile(regex, 2).matcher(this.STRING).matches();
    }

    public static IString format(String format, Object ... args) {
        return new IString(String.format(format, args));
    }
}

