/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Objects;
import restringer.LittleEndianInput;

public class LittleEndianRAF
extends LittleEndianInput {
    private final RandomAccessFile RAF;

    public static LittleEndianRAF open(File file) throws FileNotFoundException {
        Objects.requireNonNull(file);
        assert (file.isFile());
        assert (file.canRead());
        assert (file.exists());
        LittleEndianRAF RAF = new LittleEndianRAF(file, "r");
        return RAF;
    }

    public LittleEndianRAF(File file, String mode) throws FileNotFoundException {
        this.RAF = new RandomAccessFile(file, mode);
    }

    public RandomAccessFile getBigEndian() {
        return this.RAF;
    }

    @Override
    public int available() throws IOException {
        return (int)(this.length() - this.getFilePointer());
    }

    public void seek(long pos) throws IOException {
        this.RAF.seek(pos);
    }

    public long getFilePointer() throws IOException {
        return this.RAF.getFilePointer();
    }

    @Override
    public void close() throws IOException {
        this.RAF.close();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.RAF.skipBytes(n);
    }

    public void setLength(long newLength) throws IOException {
        this.RAF.setLength(newLength);
    }

    public long length() throws IOException {
        return this.RAF.length();
    }

    @Override
    public int read() throws IOException {
        return this.RAF.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        int bytesRead = this.RAF.read(b);
        return bytesRead;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.RAF.read(b, off, len);
        return bytesRead;
    }

    public String toString() {
        return this.RAF.toString();
    }
}

