/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import restringer.Game;
import restringer.ReAssembler;
import restringer.ReSaver;
import restringer.ReStringer;

public class Main {
    public static void main(String[] args) {
        CommandLine LINE;
        Options OPTIONS = new Options();
        OPTIONS.addOption("b", "bytecode", false, "Disassemble a PEX file to bytecode.");
        OPTIONS.addOption("c", "cleaned", false, "Disassemble a PEX file to cleaned bytecode.");
        OPTIONS.addOption("h", "help", false, "Display these instructions.");
        OPTIONS.addOption("s", "screen", false, "Disassemble to the screen instead of a file.");
        OPTIONS.addOption("1", "resaver", false, "Launch ReSaver.");
        OPTIONS.addOption("2", "restringer", false, "Launch ReStringer.");
        DefaultParser PARSER = new DefaultParser();
        try {
            LINE = PARSER.parse(OPTIONS, args);
        }
        catch (ParseException ex) {
            System.err.println("Unexpected argument: " + ex.getMessage());
            HelpFormatter HELP = new HelpFormatter();
            HELP.printHelp("ReAssembler [OPTIONS] [FILE1] [FILE2] [FILE3] ...", OPTIONS);
            return;
        }
        if (LINE.hasOption('h')) {
            HelpFormatter HELP = new HelpFormatter();
            HELP.printHelp("ReAssembler [OPTIONS] [FILE1] [FILE2] [FILE3] ...", OPTIONS);
        } else if (LINE.hasOption('1')) {
            ReSaver.execute(LINE);
        } else if (LINE.hasOption('2')) {
            ReStringer.execute(LINE);
        } else if (LINE.getArgList().stream().anyMatch(ReAssembler.FILENAMEPATTERN.asPredicate())) {
            ReAssembler.execute(LINE);
        } else if (LINE.getArgList().size() == 1) {
            String ARG = LINE.getArgList().get(0);
            Game GAME = Game.matchFilename(ARG);
            if (GAME != null) {
                ReSaver.execute(LINE);
            }
        } else {
            System.out.println("No scriptfiles!");
            HelpFormatter HELP = new HelpFormatter();
            HELP.printHelp("ReAssembler [OPTIONS] [FILE1] [FILE2] [FILE3] ...", OPTIONS);
        }
    }
}

