/*
 * Decompiled with CFR 0.152.
 */
package restringer;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import restringer.Game;
import restringer.IString;
import restringer.LittleEndianInputStream;
import restringer.LittleEndianRAF;
import restringer.Timer;
import restringer.bsa.BSAParser;
import restringer.esp.StringsFile;
import restringer.pex.PexFile;

public final class Mod
implements Serializable {
    private final Game GAME;
    private final File DIRECTORY;
    private final File SCRIPT_DIR;
    private final File STRING_DIR;
    private final String MODNAME;
    private final String SHORTNAME;
    private final Map<File, PexFile> SCRIPTS;
    private Analysis fastAnalysis;
    private Status status;
    private final List<File> ESP_FILES;
    private final List<File> BSA_FILES;
    private final List<File> PEX_FILES;
    private final List<File> STR_FILES;
    private final Timer TIMER;
    private static final String SCRIPTS_PATH = "\\scripts";
    private static final String STRINGS_PATH = "\\strings";
    private static final String ESP_PATTERN = "(.+)\\.es[mp]";
    private static final String PEX_PATTERN = "(.+)\\.pex";
    private static final String BSA_PATTERN = "(.+)\\.bsa";
    private static final String STR_PATTERN = "^(.+)_(.+)\\.(.?.?strings)$";
    public static final Pattern ESP_REGEX = Pattern.compile("(.+)\\.es[mp]", 2);
    public static final Pattern PEX_REGEX = Pattern.compile("(.+)\\.pex", 2);
    public static final Pattern BSA_REGEX = Pattern.compile("(.+)\\.bsa", 2);
    public static final Pattern STR_REGEX = Pattern.compile("^(.+)_(.+)\\.(.?.?strings)$", 2);
    public static final FileFilter ESP_FILTER = f -> ESP_REGEX.matcher(f.getName()).matches();
    public static final FileFilter PEX_FILTER = f -> PEX_REGEX.matcher(f.getName()).matches();
    public static final FileFilter BSA_FILTER = f -> BSA_REGEX.matcher(f.getName()).matches();
    public static final FileFilter STR_FILTER = f -> STR_REGEX.matcher(f.getName()).matches();
    private static final FileFilter DATA_FILTER = f -> f.isDirectory() && f.getName().equalsIgnoreCase("data");
    private static final Logger LOG = Logger.getLogger(Mod.class.getCanonicalName());

    public Mod(Game game, File dir) {
        Objects.requireNonNull(game);
        Objects.requireNonNull(dir);
        this.GAME = game;
        if (dir.exists() && !dir.isDirectory()) {
            throw new IllegalArgumentException("The 'directory' argument isn't a directory.");
        }
        this.DIRECTORY = dir.exists() && 0 == dir.listFiles(BSA_FILTER).length && 0 == dir.listFiles(PEX_FILTER).length && 0 == dir.listFiles(ESP_FILTER).length && 0 < dir.listFiles(DATA_FILTER).length ? dir.listFiles(DATA_FILTER)[0] : dir;
        String dirName = this.DIRECTORY.getName();
        String parentName = this.DIRECTORY.getParentFile().getName();
        this.MODNAME = dirName.equalsIgnoreCase("data") && parentName.equalsIgnoreCase("skyrim") ? "Skyrim DATA Directory" : this.DIRECTORY.getName();
        this.SCRIPT_DIR = new File(this.DIRECTORY, SCRIPTS_PATH);
        this.STRING_DIR = new File(this.DIRECTORY, STRINGS_PATH);
        this.SHORTNAME = this.MODNAME.length() < 25 ? this.MODNAME : this.MODNAME.substring(0, 22) + "...";
        this.TIMER = new Timer(String.format("Timer for %s", this.MODNAME));
        this.ESP_FILES = new ArrayList<File>();
        this.BSA_FILES = new ArrayList<File>();
        this.PEX_FILES = new ArrayList<File>();
        this.STR_FILES = new ArrayList<File>();
        this.SCRIPTS = new ConcurrentHashMap<File, PexFile>();
        this.fastAnalysis = null;
        File[] espFiles = this.DIRECTORY.listFiles(ESP_FILTER);
        File[] bsaFiles = this.DIRECTORY.listFiles(BSA_FILTER);
        File[] pexFiles = this.SCRIPT_DIR.listFiles(PEX_FILTER);
        File[] strFiles = this.STRING_DIR.listFiles(STR_FILTER);
        if (!dir.exists()) {
            this.status = Status.DISABLED;
            LOG.warning(String.format("Mod \"%s\" doesn't exist.", this.MODNAME));
        } else {
            if (espFiles.length == 0) {
                LOG.fine(String.format("Mod \"%s\" contains no ESP or ESM files.", this.MODNAME));
            } else {
                this.ESP_FILES.addAll(Arrays.asList(espFiles));
                LOG.fine(String.format("Mod \"%s\" contains %d ESP/ESM files.", this.MODNAME, espFiles.length));
            }
            if (bsaFiles.length == 0) {
                LOG.fine(String.format("Mod \"%s\" contains no BSA files.", this.MODNAME));
            } else {
                this.BSA_FILES.addAll(Arrays.asList(bsaFiles));
                LOG.fine(String.format("Mod \"%s\" contains %d BSA files.", this.MODNAME, bsaFiles.length));
            }
            if (null == pexFiles) {
                LOG.fine(String.format("Mod \"%s\" contains no \"scripts\" folder.", this.MODNAME));
            } else if (pexFiles.length == 0) {
                LOG.fine(String.format("Mod \"%s\" contains no loose scripts.", this.MODNAME));
            } else {
                this.PEX_FILES.addAll(Arrays.asList(pexFiles));
                LOG.fine(String.format("Mod \"%s\" contains %d loose scripts.", this.MODNAME, pexFiles.length));
            }
            if (null == strFiles) {
                LOG.fine(String.format("Mod \"%s\" contains no \"scripts\" folder.", this.MODNAME));
            } else if (strFiles.length == 0) {
                LOG.fine(String.format("Mod \"%s\" contains no loose localization files.", this.MODNAME));
            } else {
                this.STR_FILES.addAll(Arrays.asList(strFiles));
                LOG.fine(String.format("Mod \"%s\" contains %d loose localization files.", this.MODNAME, strFiles.length));
            }
            this.status = this.isEmpty() ? Status.DISABLED : Status.CHECKED;
        }
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status newStatus) {
        this.status = Objects.requireNonNull(newStatus);
    }

    public boolean isEmpty() {
        return this.BSA_FILES.isEmpty() && this.ESP_FILES.isEmpty() && this.PEX_FILES.isEmpty();
    }

    public File getDirectory() {
        return this.DIRECTORY;
    }

    public int getNumBSAs() {
        return this.BSA_FILES.size();
    }

    public int getNumLooseScripts() {
        return this.PEX_FILES.size();
    }

    public int getNumLooseStrings() {
        return this.STR_FILES.size();
    }

    public int getNumESPs() {
        return this.ESP_FILES.size();
    }

    public String getName() {
        return this.MODNAME;
    }

    public List<String> getESPNames() {
        ArrayList<String> NAMES = new ArrayList<String>(this.ESP_FILES.size());
        this.ESP_FILES.forEach(v -> NAMES.add(v.getName()));
        return NAMES;
    }

    public void readScripts(boolean bestEffort) throws ScriptReadError {
        this.TIMER.reset();
        this.TIMER.start();
        LinkedList bsaErrorNames = new LinkedList();
        LinkedList scriptErrorNames = new LinkedList();
        this.BSA_FILES.parallelStream().forEach(bsaFile -> {
            try (LittleEndianRAF input = LittleEndianRAF.open(bsaFile);){
                BSAParser BSA = new BSAParser(bsaFile.getName(), input);
                Map<File, PexFile> bsaScripts = BSA.getScripts();
                bsaScripts.forEach((f, pex) -> {
                    File filename = new File((File)bsaFile, f.getName());
                    this.SCRIPTS.put(filename, (PexFile)pex);
                });
                LOG.fine(String.format("Read %d BSA scripts from file \"%s\".", bsaScripts.size(), bsaFile.getName()));
            }
            catch (IOException ex) {
                bsaErrorNames.add(bsaFile.getName());
                LOG.severe(String.format("Error while reading \"%s\".", bsaFile.getName()));
            }
        });
        int bsaFilesRead = this.BSA_FILES.size() - bsaErrorNames.size();
        LOG.fine(String.format("Mod \"%s\": read %d scripts from %d BSA files.", this.SHORTNAME, this.SCRIPTS.size(), bsaFilesRead));
        this.PEX_FILES.forEach(scriptFile -> {
            try {
                PexFile script = PexFile.readScript(scriptFile);
                IString filename = script.getFilename();
                Optional<File> match = this.SCRIPTS.keySet().stream().filter(f -> filename.equals(f.getName())).findAny();
                if (match.isPresent()) {
                    PexFile existing = this.SCRIPTS.get(match.get());
                    long originalDate = existing.getDate();
                    long newDate = script.getDate();
                    if (newDate > originalDate) {
                        this.SCRIPTS.put((File)scriptFile, script);
                    }
                } else {
                    this.SCRIPTS.put((File)scriptFile, script);
                }
            }
            catch (IOException ex) {
                scriptErrorNames.add(scriptFile.getName());
                LOG.severe(String.format("Error while reading \"%s\".", scriptFile.getName()));
            }
        });
        this.TIMER.stop();
        LOG.info(String.format("Mod \"%s\": finished reading %d script files; took %s", this.SHORTNAME, this.SCRIPTS.size(), this.TIMER.getFormattedTime()));
        if (!(bestEffort || scriptErrorNames.isEmpty() && bsaErrorNames.isEmpty())) {
            throw new ScriptReadError(bsaErrorNames, scriptErrorNames);
        }
        if (!scriptErrorNames.isEmpty() || !bsaErrorNames.isEmpty()) {
            LOG.warning(String.format("Mod \"%s\": %d scripts and %d BSAs could not be read.", this.SHORTNAME, scriptErrorNames.size(), bsaErrorNames.size()));
        }
    }

    public List<StringsFile> readStrings(File espFile, String language, boolean bestEffort) throws StringsReadError {
        Objects.requireNonNull(espFile);
        if (!this.ESP_FILES.contains(espFile)) {
            throw new IllegalArgumentException("That plugin is not part of the Mod.");
        }
        String NAME = espFile.getName().split("\\.(?=[^\\.]+$)")[0].toLowerCase();
        String LANG = "_" + language.toLowerCase();
        File BSAFILE = new File(espFile.getParentFile(), NAME + ".bsa");
        this.TIMER.reset();
        this.TIMER.start();
        ArrayList<StringsFile> STRINGS = new ArrayList<StringsFile>(3);
        LinkedList<String> bsaErrorNames = new LinkedList<String>();
        LinkedList strErrorNames = new LinkedList();
        if (this.BSA_FILES.contains(BSAFILE)) {
            try (LittleEndianRAF input = LittleEndianRAF.open(BSAFILE);){
                BSAParser BSA = new BSAParser(BSAFILE.getName(), input);
                List<StringsFile> bsaStrings = BSA.getStrings(language);
                STRINGS.addAll(bsaStrings);
                LOG.fine(String.format("Read %d BSA stringtables from file \"%s\".", bsaStrings.size(), BSAFILE.getName()));
            }
            catch (IOException ex) {
                bsaErrorNames.add(BSAFILE.getName());
                LOG.severe(String.format("Error while reading \"%s\".", BSAFILE.getName()));
            }
        }
        int bsaStrCount = STRINGS.stream().mapToInt(s -> s.getMap().size()).sum();
        LOG.info(String.format("Mod \"%s\": read %d strings from %s.", this.SHORTNAME, bsaStrCount, BSAFILE.getName()));
        this.STR_FILES.stream().filter(f -> f.getName().toLowerCase().contains(LANG)).filter(f -> f.getName().toLowerCase().contains(NAME)).forEach(strFile -> {
            try (LittleEndianInputStream input = LittleEndianInputStream.open(strFile);){
                StringsFile.Type type = StringsFile.Type.match(strFile.getName());
                StringsFile str = new StringsFile(strFile.getName(), input, type);
                STRINGS.add(str);
            }
            catch (IOException ex) {
                strErrorNames.add(strFile.getName());
                LOG.severe(String.format("Error while reading \"%s\".", strFile.getName()));
            }
        });
        this.TIMER.stop();
        int strCount = STRINGS.stream().mapToInt(s -> s.getMap().size()).sum();
        LOG.info(String.format("Mod \"%s\": finished reading %d strings from %d stringtables; took %s", this.SHORTNAME, strCount, STRINGS.size(), this.TIMER.getFormattedTime()));
        if (!(bestEffort || strErrorNames.isEmpty() && bsaErrorNames.isEmpty())) {
            throw new StringsReadError(bsaErrorNames, strErrorNames);
        }
        if (!strErrorNames.isEmpty() || !bsaErrorNames.isEmpty()) {
            LOG.warning(String.format("Mod \"%s\": %d scripts and %d BSAs could not be read.", this.SHORTNAME, strErrorNames.size(), bsaErrorNames.size()));
        }
        return STRINGS;
    }

    public void clearScripts() {
        this.SCRIPTS.clear();
        System.gc();
    }

    public Map<File, PexFile> getScripts() {
        return Collections.unmodifiableMap(this.SCRIPTS);
    }

    public String toString() {
        return this.DIRECTORY.getPath();
    }

    public Analysis fastAnalysis() {
        return this.fastAnalysis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analysis analysis() {
        Mod mod = this;
        synchronized (mod) {
            if (null != this.fastAnalysis) {
                return this.fastAnalysis;
            }
            LOG.fine(String.format("Analyzing mod \"%s\"", this.SHORTNAME));
            this.TIMER.reset();
            this.TIMER.start();
            long scriptBytes = 0L;
            long bsaBytes = 0L;
            int numScripts = 0;
            int numStrings = 0;
            int numBSAs = 0;
            try {
                this.readScripts(true);
            }
            catch (ScriptReadError scriptReadError) {
                // empty catch block
            }
            for (File file : this.BSA_FILES) {
                bsaBytes += file.length();
                ++numBSAs;
            }
            for (Map.Entry entry : this.SCRIPTS.entrySet()) {
                File file = (File)entry.getKey();
                PexFile pex = (PexFile)entry.getValue();
                numStrings += pex.STRINGS.size();
                scriptBytes += file.length();
                ++numScripts;
            }
            ObjectOpenHashSet STRINGS = new ObjectOpenHashSet(numStrings);
            this.SCRIPTS.values().forEach(p -> p.SCRIPTS.forEach(v -> STRINGS.addAll(v.getVariableNames())));
            this.fastAnalysis = new Analysis(scriptBytes, bsaBytes, numScripts, STRINGS.size(), numBSAs);
            this.TIMER.stop();
            LOG.info(String.format("Analyzed mod \"%s\", took %s.", this.SHORTNAME, this.TIMER.getFormattedTime()));
        }
        return this.fastAnalysis;
    }

    public List<File> getESPFiles() {
        return new ArrayList<File>(this.ESP_FILES);
    }

    public List<File> getBSAFiles() {
        return new ArrayList<File>(this.BSA_FILES);
    }

    public List<File> getPexFiles() {
        return new ArrayList<File>(this.PEX_FILES);
    }

    public int hashCode() {
        return this.DIRECTORY.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Mod other = (Mod)obj;
        return Objects.equals(this.DIRECTORY, other.DIRECTORY);
    }

    public class StringsReadError
    extends IOException {
        private final Mod MOD;
        private final List<String> BSA_NAMES;
        private final List<String> STR_NAMES;

        private StringsReadError(List<String> strNames, List<String> bsaNames) {
            super("Some stringtables could not be read: " + strNames.toString());
            Objects.requireNonNull(bsaNames);
            Objects.requireNonNull(strNames);
            this.MOD = Mod.this;
            this.BSA_NAMES = Collections.unmodifiableList(new ArrayList<String>(bsaNames));
            this.STR_NAMES = Collections.unmodifiableList(new ArrayList<String>(strNames));
        }

        public Mod getMod() {
            return this.MOD;
        }

        public List<String> getBSANames() {
            return this.BSA_NAMES;
        }

        public List<String> getStringsNames() {
            return this.STR_NAMES;
        }
    }

    public class ScriptReadError
    extends IOException {
        private final Mod MOD;
        private final List<String> BSA_NAMES;
        private final List<String> SCRIPT_NAMES;

        private ScriptReadError(List<String> scriptNames, List<String> bsaNames) {
            super("Some scripts could not be read: " + scriptNames.toString());
            Objects.requireNonNull(bsaNames);
            Objects.requireNonNull(scriptNames);
            this.MOD = Mod.this;
            this.BSA_NAMES = Collections.unmodifiableList(new ArrayList<String>(bsaNames));
            this.SCRIPT_NAMES = Collections.unmodifiableList(new ArrayList<String>(scriptNames));
        }

        public Mod getMod() {
            return this.MOD;
        }

        public List<String> getBSANames() {
            return this.BSA_NAMES;
        }

        public List<String> getScriptNames() {
            return this.SCRIPT_NAMES;
        }
    }

    public static class Analysis {
        public final long NUMBYTES;
        public final long SCRIPTBYTES;
        public final long BSABYTES;
        public final int NUMSCRIPTS;
        public final int NUMSTRINGS;
        public final int NUMBSAS;
        public static Analysis INPROGRESS = new Analysis(Long.MAX_VALUE, Long.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);

        static Analysis combine(Analysis a1, Analysis a2) {
            return new Analysis(a1.SCRIPTBYTES + a2.SCRIPTBYTES, a1.BSABYTES + a2.BSABYTES, a1.NUMSCRIPTS + a2.NUMSCRIPTS, a1.NUMSTRINGS + a2.NUMSTRINGS, a1.NUMBSAS + a2.NUMBSAS);
        }

        public Analysis() {
            this(0L, 0L, 0, 0, 0);
        }

        public Analysis(long scriptBytes, long bsaBytes, int scripts, int strings, int bsas) {
            assert (0L <= scriptBytes);
            assert (0L <= bsaBytes);
            assert (0 <= scripts);
            assert (0 <= strings);
            assert (0 <= bsas);
            this.NUMBYTES = scriptBytes + bsaBytes;
            this.BSABYTES = bsaBytes;
            this.SCRIPTBYTES = scriptBytes;
            this.NUMSCRIPTS = scripts;
            this.NUMSTRINGS = strings;
            this.NUMBSAS = bsas;
        }

        public String toString() {
            return "Analysis{NUMBYTES=" + this.NUMBYTES + ", SCRIPTBYTES=" + this.SCRIPTBYTES + ", BSABYTES=" + this.BSABYTES + ", NUMSCRIPTS=" + this.NUMSCRIPTS + ", NUMSTRINGS=" + this.NUMSTRINGS + ", NUMBSAS=" + this.NUMBSAS + '}';
        }
    }

    public static enum Status {
        CHECKED,
        UNCHECKED,
        DISABLED;

    }
}

